/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.api.property;

import java.util.List;

public abstract class MultipartProperty<T> {
    public final String name;
    public final Class<T> clazz;
    public final T defaultValue;
    private final String asString;

    public MultipartProperty(String name, Class<T> clazz, T defaultValue) {
        this.name = name;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.asString = name + "<" + clazz.getSimpleName() + ">";
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final String toString() {
        return this.asString;
    }

    public abstract T combine(List<T> var1);

    public static class PreferedBooleanProperty
    extends MultipartProperty<Boolean> {
        public PreferedBooleanProperty(String name, Boolean defaultValue) {
            super(name, Boolean.class, defaultValue);
        }

        @Override
        public Boolean combine(List<Boolean> values) {
            for (Boolean val : values) {
                if (val == null || val.booleanValue() == ((Boolean)this.defaultValue).booleanValue()) continue;
                return val;
            }
            return (Boolean)this.defaultValue;
        }
    }

    public static class IntegerBoundProperty
    extends MultipartProperty<Integer> {
        public final Integer min;
        public final Integer max;

        public IntegerBoundProperty(String name, int min, int max, int defaultValue) {
            super(name, Integer.class, defaultValue);
            this.min = min;
            this.max = max;
        }

        @Override
        public Integer combine(List<Integer> values) {
            Integer highest = (Integer)this.defaultValue;
            for (Integer val : values) {
                if (val < this.min) continue;
                if (val >= this.max) {
                    return this.max;
                }
                if (val <= highest) continue;
                highest = val;
            }
            return highest;
        }
    }
}

