/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.NativeMultipart;
import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.impl.MultipartBlockEntity;
import alexiil.mc.lib.multipart.impl.PartContainer;
import alexiil.mc.lib.multipart.impl.PartHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4990;

public final class MultipartUtilImpl {
    @Nullable
    public static PartContainer get(class_1937 world, class_2338 pos) {
        return MultipartUtilImpl.get((class_1922)world, pos);
    }

    @Nullable
    public static PartContainer get(class_1922 view, class_2338 pos) {
        class_2586 be = view.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            return ((MultipartBlockEntity)be).container;
        }
        return null;
    }

    @Nullable
    public static MultipartContainer turnIntoMultipart(class_1937 world, class_2338 pos) {
        boolean hasWater;
        PartContainer existing = MultipartUtilImpl.get(world, pos);
        if (existing != null) {
            return existing;
        }
        class_3611 fluid = world.method_8316(pos).method_15772();
        boolean bl = hasWater = fluid == class_3612.field_15910;
        if (fluid != class_3612.field_15910 && fluid != class_3612.field_15906) {
            return null;
        }
        class_2680 state = world.method_8320(pos);
        NativeMultipart nativeBlock = MultipartUtilImpl.getNative(world, pos);
        if (nativeBlock != null) {
            List<MultipartContainer.MultipartCreator> conversions = nativeBlock.getMultipartConversion(world, pos, state);
            if (conversions == null) {
                return null;
            }
            if (!conversions.isEmpty()) {
                MultipartContainer.PartOffer offer = MultipartUtilImpl.offerAdder(world, pos, hasWater, conversions, null, false);
                if (offer == null) {
                    return null;
                }
                offer.apply();
                return offer.getHolder().getContainer();
            }
        }
        return null;
    }

    private static NativeMultipart getNative(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof NativeMultipart) {
            NativeMultipart nativeBlock = (NativeMultipart)class_22482;
            return nativeBlock;
        }
        return (NativeMultipart)NativeMultipart.LOOKUP.find(world, pos, null);
    }

    @Nullable
    public static MultipartContainer.PartOffer offerNewPart(final class_1937 world, final class_2338 pos, MultipartContainer.MultipartCreator creator, boolean respectEntityBBs) {
        boolean hasWater;
        PartContainer currentContainer = MultipartUtilImpl.get(world, pos);
        if (currentContainer != null) {
            return currentContainer.offerNewPart(creator, respectEntityBBs);
        }
        class_3611 fluid = world.method_8316(pos).method_15772();
        boolean bl = hasWater = fluid == class_3612.field_15910;
        if (fluid != class_3612.field_15910 && fluid != class_3612.field_15906) {
            return null;
        }
        class_2680 state = world.method_8320(pos);
        NativeMultipart nativeBlock = MultipartUtilImpl.getNative(world, pos);
        if (nativeBlock != null) {
            List<MultipartContainer.MultipartCreator> conversions = nativeBlock.getMultipartConversion(world, pos, state);
            if (conversions == null) {
                return null;
            }
            if (!conversions.isEmpty()) {
                return MultipartUtilImpl.offerAdder(world, pos, hasWater, conversions, creator, respectEntityBBs);
            }
        } else if (!state.method_45474()) {
            return null;
        }
        MultipartBlockEntity be = new MultipartBlockEntity(pos, state);
        be.method_31662(world);
        final PartContainer container = new PartContainer(be, class_4990.field_23292);
        final PartHolder holder = new PartHolder(container, creator);
        class_265 shape = holder.part.getCollisionShape();
        if (respectEntityBBs && !shape.method_1110() && !world.method_8611(null, shape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))) {
            return null;
        }
        return new MultipartContainer.PartOffer(){

            @Override
            public MultipartHolder getHolder() {
                return holder;
            }

            @Override
            public void apply() {
                class_2680 newState = LibMultiPart.BLOCK.method_9564();
                newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(hasWater));
                world.method_8652(pos, newState, 3);
                MultipartBlockEntity newBe = (MultipartBlockEntity)world.method_8321(pos);
                assert (newBe != null);
                newBe.container = container;
                container.blockEntity = newBe;
                container.addPartInternal(holder);
            }
        };
    }

    @Nullable
    private static MultipartContainer.PartOffer offerAdder(final class_1937 world, final class_2338 pos, final boolean hasWater, List<MultipartContainer.MultipartCreator> existing, MultipartContainer.MultipartCreator creatorB, boolean respectEntityBBs) {
        PartHolder offeredHolder;
        MultipartBlockEntity be = new MultipartBlockEntity(pos, (class_2680)LibMultiPart.BLOCK.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(hasWater)));
        be.method_31662(world);
        final PartContainer container = new PartContainer(be, class_4990.field_23292);
        final ArrayList<PartHolder> existingHolders = new ArrayList<PartHolder>();
        for (MultipartContainer.MultipartCreator creator : existing) {
            PartHolder holder = new PartHolder(container, creator);
            existingHolders.add(holder);
            container.parts.add(holder);
            class_265 shape = holder.part.getCollisionShape();
            if (!respectEntityBBs || shape.method_1110() || world.method_8611(null, shape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))) continue;
            return null;
        }
        PartHolder partHolder = offeredHolder = creatorB == null ? null : new PartHolder(container, creatorB);
        if (offeredHolder != null) {
            class_265 shape = offeredHolder.part.getCollisionShape();
            if (respectEntityBBs && !shape.method_1110() && !world.method_8611(null, shape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))) {
                return null;
            }
            container.recalculateShape();
            if (!container.canAdd(offeredHolder, true)) {
                return null;
            }
        }
        if (offeredHolder == null && existingHolders.isEmpty()) {
            return null;
        }
        return new MultipartContainer.PartOffer(){

            @Override
            public MultipartHolder getHolder() {
                return offeredHolder != null ? offeredHolder : (MultipartHolder)existingHolders.get(0);
            }

            @Override
            public void apply() {
                container.parts.clear();
                for (PartHolder holder : existingHolders) {
                    holder.part.preConvertNativeMultipart();
                }
                class_2680 oldState = world.method_8320(pos);
                class_2680 newState = LibMultiPart.BLOCK.method_9564();
                newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(hasWater));
                world.method_8652(pos, newState, 0);
                MultipartBlockEntity newBe = (MultipartBlockEntity)world.method_8321(pos);
                assert (newBe != null);
                newBe.container = container;
                container.blockEntity = newBe;
                for (PartHolder holder : existingHolders) {
                    container.addPartInternal(holder);
                }
                if (offeredHolder != null) {
                    container.addPartInternal(offeredHolder);
                }
                world.method_8413(pos, oldState, newState, 3);
                world.method_8408(pos, (class_2248)LibMultiPart.BLOCK);
                oldState.method_30102((class_1936)world, pos, 2);
                newState.method_30101((class_1936)world, pos, 2);
                newState.method_30102((class_1936)world, pos, 2);
            }
        };
    }
}

