/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.event.PartAddedEvent;
import alexiil.mc.lib.multipart.api.event.PartContainerState;
import alexiil.mc.lib.multipart.api.event.PartOfferedEvent;
import alexiil.mc.lib.multipart.api.event.PartPostTransformEvent;
import alexiil.mc.lib.multipart.api.event.PartPreTransformEvent;
import alexiil.mc.lib.multipart.api.event.PartRedstonePowerEvent;
import alexiil.mc.lib.multipart.api.event.PartRemovedEvent;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.multipart.api.event.PartTransformCheckEvent;
import alexiil.mc.lib.multipart.api.event.PartTransformEvent;
import alexiil.mc.lib.multipart.api.misc.DirectionTransformationUtil;
import alexiil.mc.lib.multipart.api.property.MultipartProperties;
import alexiil.mc.lib.multipart.api.property.MultipartProperty;
import alexiil.mc.lib.multipart.api.property.MultipartPropertyContainer;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.multipart.impl.ArrayUtil;
import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.impl.LmpReflection;
import alexiil.mc.lib.multipart.impl.MultipartBlock;
import alexiil.mc.lib.multipart.impl.MultipartBlockEntity;
import alexiil.mc.lib.multipart.impl.MultipartUtilImpl;
import alexiil.mc.lib.multipart.impl.PartHolder;
import alexiil.mc.lib.multipart.impl.PosPartId;
import alexiil.mc.lib.multipart.impl.SimpleEventBus;
import alexiil.mc.lib.multipart.impl.SimplePropertyContainer;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.NetIdSignalK;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdDuel;
import alexiil.mc.lib.net.ParentNetIdSingle;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4990;
import net.minecraft.class_7225;

public class PartContainer
implements MultipartContainer {
    static final ParentNetIdSingle<PartContainer> NET_KEY = MultipartBlockEntity.NET_KEY.extractor(PartContainer.class, "container", c -> c.blockEntity, b -> b.container);
    static final NetIdDataK<PartContainer> NET_INITIAL_RENDER_DATA;
    static final NetIdDataK<PartContainer> NET_ADD_PART;
    static final NetIdDataK<PartContainer> NET_REMOVE_PART;
    static final NetIdDataK<PartContainer> NET_REMOVE_PARTS;
    static final NetIdSignalK<PartContainer> NET_ENSURE_EMPTY;
    static final NetIdSignalK<PartContainer> NET_REDRAW;
    static final NetIdSignalK<PartContainer> NET_RECALCULATE_SHAPE;
    public static final ParentNetIdSingle<AbstractPart> NET_KEY_PART;
    public final SimpleEventBus eventBus = new SimpleEventBus(this);
    public final SimplePropertyContainer properties = new SimplePropertyContainer(this);
    public final List<PartHolder> parts = new ArrayList<PartHolder>();
    final Long2ObjectMap<PartHolder> partsByUid = new Long2ObjectOpenHashMap();
    MultipartBlockEntity blockEntity;
    class_265 cachedShape = null;
    class_265 cachedCollisionShape = null;
    class_265 cachedCullingShape = null;
    class_265 cachedOutlineShape = null;
    class_265 cachedSidesShape = null;
    boolean havePropertiesChanged = false;
    boolean hasTicked = false;
    class_4990 cachedTransformation = class_4990.field_23292;
    final class_4990 initialTransformation;
    boolean validated = false;
    boolean hasInitialisedFromRemote = false;
    long nextId = 1L;
    ImmutableList<PartModelKey> partModelKeys = ImmutableList.of();
    private static final PartRedstonePowerEvent.PartRedstonePowerEventFactory STRONG_EVENT_FACTORY;
    private static final PartRedstonePowerEvent.PartRedstonePowerEventFactory WEAK_EVENT_FACTORY;
    private static final Function<PartRedstonePowerEvent, Integer> EVENT_VALUE;

    static PartHolder extractPartHolder(AbstractPart value) {
        MultipartHolder holder = value.holder;
        if (holder == null || holder instanceof PartHolder) {
            return (PartHolder)holder;
        }
        throw new IllegalStateException("Found an AbstractPart that doesn't have the correct class for it's holder! It should be using " + PartHolder.class.getName() + ", but instead it's using " + holder.getClass().getName() + "!");
    }

    public static void init() {
    }

    public PartContainer(MultipartBlockEntity blockEntity, class_4990 initialTransformation) {
        assert (blockEntity != null) : "The given blockEntity was null!";
        this.blockEntity = blockEntity;
        this.initialTransformation = initialTransformation;
    }

    private void log(String text) {
        LibMultiPart.LOGGER.info("[part-container] @ " + String.valueOf(this.getMultipartPos()) + " " + text);
    }

    private void warn(String text) {
        LibMultiPart.LOGGER.warn("[part-container] @ " + String.valueOf(this.getMultipartPos()) + " " + text);
    }

    @Override
    public class_1937 getMultipartWorld() {
        return this.blockEntity.method_10997();
    }

    @Override
    public class_2338 getMultipartPos() {
        return this.blockEntity.method_11016();
    }

    @Override
    public class_2586 getMultipartBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public boolean canPlayerInteract(class_1657 player) {
        return this.blockEntity.canPlayerInteract(player);
    }

    @Override
    public class_2586 getNeighbourBlockEntity(class_2350 dir) {
        return this.getMultipartWorld().method_8321(this.getMultipartPos().method_10093(dir));
    }

    @Override
    public List<AbstractPart> getAllParts() {
        ArrayList<AbstractPart> list = new ArrayList<AbstractPart>();
        for (PartHolder holder : this.parts) {
            list.add(holder.part);
        }
        return list;
    }

    @Override
    public List<AbstractPart> getAllParts(Predicate<AbstractPart> filter) {
        ArrayList<AbstractPart> list = new ArrayList<AbstractPart>();
        for (PartHolder holder : this.parts) {
            if (!filter.test(holder.part)) continue;
            list.add(holder.part);
        }
        return list;
    }

    @Override
    public <P> List<P> getParts(Class<P> clazz) {
        ArrayList<P> list = new ArrayList<P>();
        for (PartHolder holder : this.parts) {
            AbstractPart part = holder.part;
            if (!clazz.isInstance(part)) continue;
            list.add(clazz.cast(part));
        }
        return list;
    }

    @Override
    public <P> List<P> getParts(Class<P> clazz, Predicate<P> filter) {
        ArrayList<P> list = new ArrayList<P>();
        for (PartHolder holder : this.parts) {
            AbstractPart part = holder.part;
            if (!clazz.isInstance(part) || !filter.test(clazz.cast(part))) continue;
            list.add(clazz.cast(part));
        }
        return list;
    }

    @Override
    public AbstractPart getFirstPart(Predicate<AbstractPart> filter) {
        for (PartHolder holder : this.parts) {
            if (!filter.test(holder.part)) continue;
            return holder.part;
        }
        return null;
    }

    @Override
    public <P> P getFirstPart(Class<P> clazz) {
        for (PartHolder holder : this.parts) {
            AbstractPart part = holder.part;
            if (!clazz.isInstance(part)) continue;
            return clazz.cast(part);
        }
        return null;
    }

    @Override
    public <P> P getFirstPart(Class<P> clazz, Predicate<P> filter) {
        for (PartHolder holder : this.parts) {
            AbstractPart part = holder.part;
            if (!clazz.isInstance(part) || !filter.test(clazz.cast(part))) continue;
            return clazz.cast(part);
        }
        return null;
    }

    @Override
    public AbstractPart getPart(class_243 vec) {
        for (PartHolder holder : this.parts) {
            AbstractPart part = holder.part;
            if (!MultipartBlock.doesContain(part, vec)) continue;
            return part;
        }
        return null;
    }

    @Override
    public AbstractPart getPart(long uniqueId) {
        PartHolder holder = (PartHolder)this.partsByUid.get(uniqueId);
        assert (holder == null == this.getAllParts(p -> p.holder.getUniqueId() == uniqueId).isEmpty());
        return holder == null ? null : holder.part;
    }

    @Override
    public MultipartContainer.PartOffer offerNewPart(MultipartContainer.MultipartCreator creator, boolean respectEntityBBs) {
        final PartHolder holder = new PartHolder(this, creator);
        if (!this.canAdd(holder, respectEntityBBs)) {
            return null;
        }
        return new MultipartContainer.PartOffer(){

            @Override
            public MultipartHolder getHolder() {
                return holder;
            }

            @Override
            public void apply() {
                PartContainer.this.addPartInternal(holder);
            }
        };
    }

    @Override
    public MultipartHolder addNewPart(MultipartContainer.MultipartCreator creator, boolean respectEntityBBs) {
        PartHolder holder = new PartHolder(this, creator);
        if (!this.canAdd(holder, respectEntityBBs)) {
            return null;
        }
        this.addPartInternal(holder);
        return holder;
    }

    boolean canAdd(PartHolder offered, boolean respectEntityBBs) {
        class_265 currentShape = this.getCurrentShape();
        for (PartHolder holder : this.parts) {
            class_265 shapeOffered;
            AbstractPart part = holder.part;
            class_265 shapeOther = part.getShape();
            if (!class_259.method_1074((class_265)shapeOther, (class_265)(shapeOffered = offered.part.getShape()), (class_247)class_247.field_16896)) continue;
            if (!class_259.method_1074((class_265)currentShape, (class_265)shapeOffered, (class_247)class_247.field_16893)) {
                return false;
            }
            class_265 leftoverShape = shapeOther;
            for (PartHolder h2 : this.parts) {
                class_265 h2shape;
                if (h2.part == part || !(h2shape = h2.part.getShape()).method_1107().method_994(leftoverShape.method_1107()) || !(leftoverShape = class_259.method_1082((class_265)leftoverShape, (class_265)h2shape, (class_247)class_247.field_16886)).method_1110()) continue;
                return false;
            }
            if (!class_259.method_1074((class_265)leftoverShape, (class_265)shapeOffered, (class_247)class_247.field_16886)) {
                return false;
            }
            if (part.canOverlapWith(offered.part) || offered.part.canOverlapWith(part)) continue;
            return false;
        }
        class_265 collisionShape = offered.getPart().getCollisionShape();
        if (respectEntityBBs && !collisionShape.method_1110()) {
            class_2338 pos = this.getMultipartPos();
            class_265 offsetShape = collisionShape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (!this.getMultipartWorld().method_8611(null, offsetShape)) {
                return false;
            }
        }
        PartOfferedEvent event = new PartOfferedEvent(offered.part);
        this.eventBus.fireEvent(event);
        return event.isAllowed();
    }

    void addPartInternal(PartHolder holder) {
        assert (holder.uniqueId == Long.MIN_VALUE);
        holder.uniqueId = this.nextId++;
        this.parts.add(holder);
        PartHolder prev = (PartHolder)this.partsByUid.put(holder.uniqueId, (Object)holder);
        assert (prev == null) : "Already contained a part with the given ID";
        holder.part.onAdded(this.eventBus);
        this.sendNetworkUpdate(this, NET_ADD_PART, (p, buffer, ctx) -> holder.writeCreation(buffer, ctx));
        this.recalculateShape();
        this.eventBus.fireEvent(new PartAddedEvent(holder.part));
        this.updateOwnNeighbours();
        this.markChunkDirty();
    }

    private void readAddPart(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_ADD_PART");
        }
        PartHolder holder = new PartHolder(this, buffer, ctx);
        assert (holder.part != null);
        this.parts.add(holder);
        PartHolder prev = (PartHolder)this.partsByUid.put(holder.uniqueId, (Object)holder);
        if (prev != null) {
            throw new InvalidInputDataException("Already contained a part with the uniqueId " + holder.uniqueId + "\n" + String.valueOf(this.parts) + "\n" + String.valueOf(this.partsByUid));
        }
        holder.part.onAdded(this.eventBus);
        this.eventBus.fireEvent(new PartAddedEvent(holder.part));
        this.recalculateShape();
        this.redrawIfChanged();
    }

    @Override
    public boolean removePart(AbstractPart part) {
        PartHolder holder;
        int index;
        if (LibMultiPart.DEBUG) {
            this.log("removePart(" + String.valueOf(part) + ")");
        }
        if ((index = this.parts.indexOf(holder = (PartHolder)part.holder)) < 0) {
            return false;
        }
        if (!this.blockEntity.isServerWorld()) {
            return true;
        }
        if (holder.inverseRequiredParts == null) {
            this.removeSingle(index);
            return true;
        }
        Set<PartHolder> toRemove = PartContainer.getAllRemoved(holder);
        IdentityHashMap<PartContainer, IntList> indexLists = new IdentityHashMap<PartContainer, IntList>();
        for (PartHolder partHolder : toRemove) {
            indexLists.computeIfAbsent(partHolder.container, k -> new IntArrayList()).add(partHolder.container.parts.indexOf(partHolder));
        }
        for (Map.Entry entry : indexLists.entrySet()) {
            PartContainer c = (PartContainer)entry.getKey();
            int[] indices = ((IntList)entry.getValue()).toIntArray();
            if (indices.length == 1) {
                c.removeSingle(indices[0]);
                continue;
            }
            c.removeMultiple(indices);
        }
        return true;
    }

    public static Set<PartHolder> getAllRemoved(PartHolder holder) {
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet();
        ReferenceOpenHashSet openSet = new ReferenceOpenHashSet();
        openSet.add(holder);
        int iterationCount = 0;
        int maxIterationCount = 10000;
        while (!openSet.isEmpty()) {
            Iterator iter = openSet.iterator();
            PartHolder next = (PartHolder)iter.next();
            iter.remove();
            if (!toRemove.add(next)) continue;
            if (iterationCount++ > 10000) {
                LibMultiPart.LOGGER.warn("Tried to remove " + iterationCount + " parts, which seems a little excessive!");
                break;
            }
            if (next.inverseRequiredParts == null) continue;
            openSet.addAll(next.inverseRequiredParts);
        }
        return toRemove;
    }

    private void removeSingle(int index) {
        if (LibMultiPart.DEBUG) {
            this.log("removeSingle(" + index + ")");
        }
        PartHolder removed = this.parts.remove(index);
        assert (removed != null);
        PartHolder removedById = (PartHolder)this.partsByUid.remove(removed.uniqueId);
        assert (removedById == removed);
        removed.clearRequiredParts();
        if (!this.parts.isEmpty()) {
            this.sendNetworkUpdate(this, NET_REMOVE_PART, (p, buffer, ctx) -> buffer.method_52997(index));
        }
        this.eventBus.removeListeners(removed.part);
        removed.part.onRemoved();
        this.properties.clearValues(removed.part);
        this.eventBus.fireEvent(new PartRemovedEvent(removed.part));
        this.postRemovePart();
    }

    private void postRemovePart() {
        if (this.parts.isEmpty()) {
            if (LibMultiPart.DEBUG) {
                this.log("postRemovePart(): removing multipart block");
            }
            this.sendNetworkUpdate(this, NET_ENSURE_EMPTY);
            this.blockEntity.world().method_8650(this.getMultipartPos(), false);
        } else {
            this.recalculateShape();
            this.updateOwnNeighbours();
            this.markChunkDirty();
        }
    }

    private void readRemovePart(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        short index = buffer.readUnsignedByte();
        if (index >= this.parts.size()) {
            throw new InvalidInputDataException("Invalid part index " + index + " - we've probably got desynced!");
        }
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_REMOVE_PART(" + index + ")");
        }
        PartHolder removed = this.parts.remove(index);
        assert (removed != null);
        PartHolder removedById = (PartHolder)this.partsByUid.remove(removed.uniqueId);
        assert (removedById == removed);
        this.eventBus.removeListeners(removed.part);
        removed.part.onRemoved();
        this.properties.clearValues(removed.part);
        this.eventBus.fireEvent(new PartRemovedEvent(removed.part));
        this.recalculateShape();
        this.redrawIfChanged();
    }

    private void readEnsureEmpty(IMsgReadCtx ctx) {
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_ENSURE_EMPTY");
        }
        int partCount = this.parts.size();
        PartHolder[] removedHolders = new PartHolder[partCount];
        for (int i = 0; i < partCount; ++i) {
            PartHolder holder = removedHolders[i] = this.parts.get(i);
            holder.clearRequiredParts();
            PartHolder removedById = (PartHolder)this.partsByUid.remove(holder.uniqueId);
            assert (removedById == holder);
        }
        for (PartHolder holder : removedHolders) {
            this.eventBus.removeListeners(holder.part);
        }
        for (PartHolder holder : removedHolders) {
            holder.part.onRemoved();
        }
        for (PartHolder holder : removedHolders) {
            this.properties.clearValues(holder.part);
        }
    }

    private void removeMultiple(int[] indices) {
        if (LibMultiPart.DEBUG) {
            this.log("removeMultiple(" + Arrays.toString(indices) + ")");
        }
        Arrays.sort(indices);
        ArrayUtil.reverse(indices);
        PartHolder[] holders = new PartHolder[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int partIndex = indices[i];
            PartHolder holder = holders[i] = this.parts.remove(partIndex);
            holder.clearRequiredParts();
            PartHolder removedById = (PartHolder)this.partsByUid.remove(holder.uniqueId);
            assert (removedById == holder);
        }
        if (!this.isClientWorld()) {
            this.sendNetworkUpdate(this, NET_REMOVE_PARTS, (p, buffer, ctx) -> {
                buffer.method_52997(indices.length);
                for (int i : indices) {
                    buffer.method_52997(i);
                }
            });
        }
        for (PartHolder holder : holders) {
            this.eventBus.removeListeners(holder.part);
        }
        for (PartHolder holder : holders) {
            holder.part.onRemoved();
        }
        for (PartHolder holder : holders) {
            this.properties.clearValues(holder.part);
        }
        for (PartHolder holder : holders) {
            this.fireEvent(new PartRemovedEvent(holder.part));
        }
        if (this.isClientWorld()) {
            this.recalculateShape();
            this.redrawIfChanged();
        } else {
            this.postRemovePart();
        }
    }

    private void readRemoveParts(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        int count = buffer.readUnsignedByte();
        int[] indices = new int[count];
        for (int i = 0; i < count; ++i) {
            indices[i] = buffer.readUnsignedByte();
        }
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_REMOVE_PARTS(" + Arrays.toString(indices) + ")");
        }
        this.removeMultiple(indices);
    }

    @Override
    public void markChunkDirty() {
        if (!this.isClientWorld()) {
            this.getMultipartWorld().method_8524(this.getMultipartPos());
        }
    }

    @Override
    public class_265 getCurrentShape() {
        if (this.cachedShape == null) {
            this.cachedShape = class_259.method_1073();
            for (PartHolder holder : this.parts) {
                this.cachedShape = class_259.method_1084((class_265)this.cachedShape, (class_265)holder.part.getShape());
            }
        }
        return this.cachedShape;
    }

    @Override
    public class_265 getCollisionShape() {
        if (this.cachedCollisionShape == null) {
            this.cachedCollisionShape = class_259.method_1073();
            for (PartHolder holder : this.parts) {
                this.cachedCollisionShape = class_259.method_1084((class_265)this.cachedCollisionShape, (class_265)holder.part.getCollisionShape());
            }
        }
        return this.cachedCollisionShape;
    }

    public class_265 getCullingShape() {
        if (this.cachedCullingShape == null) {
            this.cachedCullingShape = class_259.method_1073();
            for (PartHolder holder : this.parts) {
                this.cachedCullingShape = class_259.method_1084((class_265)this.cachedCullingShape, (class_265)holder.part.getCullingShape());
            }
        }
        return this.cachedCullingShape;
    }

    @Override
    public class_265 getOutlineShape() {
        if (this.cachedOutlineShape == null) {
            this.cachedOutlineShape = class_259.method_1073();
            for (PartHolder holder : this.parts) {
                this.cachedOutlineShape = class_259.method_1084((class_265)this.cachedOutlineShape, (class_265)holder.part.getOutlineShape());
            }
            if (this.cachedOutlineShape.method_1110()) {
                this.cachedOutlineShape = class_259.method_1073();
            }
        }
        return this.cachedOutlineShape;
    }

    public class_265 getSidesShape() {
        if (this.cachedSidesShape == null) {
            this.cachedSidesShape = class_259.method_1073();
            for (PartHolder holder : this.parts) {
                this.cachedSidesShape = class_259.method_1084((class_265)this.cachedSidesShape, (class_265)holder.part.getSidesShape());
            }
            if (this.cachedSidesShape.method_1110()) {
                this.cachedSidesShape = class_259.method_1073();
            }
        }
        return this.cachedSidesShape;
    }

    @Override
    public void recalculateShape() {
        this.cachedShape = null;
        this.cachedCollisionShape = null;
        this.cachedCullingShape = null;
        this.cachedOutlineShape = null;
        this.cachedSidesShape = null;
    }

    @Override
    public void recalculateShapeSynced() {
        this.recalculateShape();
        this.sendNetworkUpdate(this, NET_RECALCULATE_SHAPE);
    }

    private void receiveRecalculateShape(IMsgReadCtx ctx) throws InvalidInputDataException {
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_RECALCULATE_SHAPE");
        }
        this.recalculateShape();
    }

    @Override
    public void redrawIfChanged() {
        if (this.isClientWorld()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (PartHolder holder : this.parts) {
                PartModelKey key = holder.part.getModelKey();
                if (key == null) continue;
                builder.add((Object)key);
            }
            ImmutableList list = builder.build();
            if (list.equals(this.partModelKeys)) {
                return;
            }
            this.partModelKeys = list;
            this.blockEntity.world().method_16109(this.blockEntity.method_11016(), class_2246.field_10124.method_9564(), class_2246.field_10597.method_9564());
        } else {
            this.sendNetworkUpdate(this, NET_REDRAW);
        }
    }

    private void receiveRedraw(IMsgReadCtx ctx) throws InvalidInputDataException {
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_REDRAW");
        }
        this.redrawIfChanged();
    }

    public ImmutableList<PartModelKey> getPartModelKeys() {
        return this.partModelKeys;
    }

    private void writeInitialRenderData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        if (LibMultiPart.DEBUG) {
            this.log("W: NET_INITIAL_RENDER_DATA");
        }
        ctx.assertServerSide();
        buffer.method_52997(this.parts.size());
        for (PartHolder holder : this.parts) {
            holder.writeCreation(buffer, ctx);
        }
    }

    private void readInitialRenderData(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        if (LibMultiPart.DEBUG) {
            this.log("R: NET_INITIAL_RENDER_DATA");
        }
        ctx.assertClientSide();
        if (this.hasInitialisedFromRemote || !this.parts.isEmpty()) {
            ctx.drop("Already initialised");
            return;
        }
        this.hasInitialisedFromRemote = true;
        if (this.parts.size() != this.partsByUid.size()) {
            throw new InvalidInputDataException("Differing parts lists: \n" + String.valueOf(this.parts) + "\n vs " + String.valueOf(this.partsByUid));
        }
        int count = buffer.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            PartHolder holder = new PartHolder(this, buffer, ctx);
            this.parts.add(holder);
            PartHolder old = (PartHolder)this.partsByUid.put(holder.uniqueId, (Object)holder);
            if (old == null) continue;
            throw new InvalidInputDataException("Already contained a part with the UID " + old.uniqueId + "!\nDiffering parts lists: \n" + String.valueOf(this.parts) + "\n vs " + String.valueOf(this.partsByUid));
        }
        this.validate();
        this.recalculateShape();
        this.redrawIfChanged();
    }

    @Override
    public <T> void sendNetworkUpdateExcept(class_1657 except, T obj, NetIdTyped<T> netId) {
        this.blockEntity.sendNetworkUpdate(except, obj, netId);
    }

    @Override
    public <T> void sendNetworkUpdateExcept(class_1657 except, T obj, NetIdDataK<T> netId, NetIdDataK.IMsgDataWriterK<T> writer) {
        this.blockEntity.sendNetworkUpdate(except, obj, netId, writer);
    }

    @Override
    public MultipartEventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public boolean hasTicked() {
        return this.hasTicked;
    }

    @Override
    public MultipartPropertyContainer getProperties() {
        return this.properties;
    }

    void fromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        if (LibMultiPart.DEBUG) {
            this.log("fromNbt( " + String.valueOf(tag) + " ) {");
        }
        this.recalculateShape();
        if (tag.method_10545("cachedTransformation")) {
            this.cachedTransformation = MultipartBlock.TRANSFORMATION.method_11900(tag.method_10558("cachedTransformation")).orElse(class_4990.field_23292);
        }
        this.nextId = Long.MIN_VALUE;
        boolean areIdsValid = true;
        class_2499 allPartsTag = tag.method_10554("parts", (int)new class_2487().method_10711());
        for (int i = 0; i < allPartsTag.size(); ++i) {
            class_2487 partTag = allPartsTag.method_10602(i);
            PartHolder holder = new PartHolder(this, partTag, lookup);
            this.parts.add(holder);
            if (!areIdsValid) continue;
            this.nextId = Math.max(this.nextId, holder.uniqueId);
            PartHolder prev = (PartHolder)this.partsByUid.put(holder.uniqueId, (Object)holder);
            if (prev == null) continue;
            areIdsValid = false;
            this.partsByUid.clear();
        }
        if (this.parts.isEmpty()) {
            this.nextId = 0L;
            if (LibMultiPart.DEBUG) {
                this.log("  parts is empty => nextId set to 0");
            }
        } else if (areIdsValid) {
            ++this.nextId;
            if (LibMultiPart.DEBUG) {
                this.log("  parts are valid => nextId++ (nextId = " + this.nextId + ")");
            }
        } else {
            this.nextId = ((long)new Random().nextInt() & Integer.MAX_VALUE) << 6;
            if (LibMultiPart.DEBUG) {
                this.log("  parts are NOT valid => nextId set to rand (nextId = " + this.nextId + ")");
            }
            for (PartHolder holder : this.parts) {
                ++this.nextId;
                holder.uniqueId = holder.uniqueId;
                this.partsByUid.put(holder.uniqueId, (Object)holder);
            }
        }
        for (PartHolder holder : this.parts) {
            if (holder.unloadedRequiredParts == null) continue;
            Iterator<PosPartId> iterator = holder.unloadedRequiredParts.iterator();
            while (iterator.hasNext()) {
                PosPartId id = iterator.next();
                if (!id.posEquals(this.blockEntity.method_11016())) continue;
                PartHolder other = (PartHolder)this.partsByUid.get(id.uid);
                if (other == null) {
                    this.warn("Failed to resolve a part to part requirement! " + String.valueOf(id));
                } else {
                    holder.addRequiredPart0(other);
                }
                iterator.remove();
            }
        }
        if (LibMultiPart.DEBUG) {
            this.log("}");
        }
        if (this.validated) {
            this.initParts();
        }
    }

    class_2487 toNbt(class_7225.class_7874 lookup) {
        class_2487 tag = new class_2487();
        tag.method_10582("cachedTransformation", MultipartBlock.TRANSFORMATION.method_11846((Enum)this.cachedTransformation));
        class_2499 partsTag = new class_2499();
        for (PartHolder part : this.parts) {
            partsTag.add((Object)part.toNbt(lookup));
        }
        tag.method_10566("parts", (class_2520)partsTag);
        return tag;
    }

    void validate() {
        this.validated = true;
        this.initParts();
        this.eventBus.fireEvent(PartContainerState.VALIDATE);
    }

    private void initParts() {
        this.eventBus.clearListeners();
        for (PartHolder holder : this.parts) {
            holder.part.onAdded(this.eventBus);
        }
        this.updateTransform(this.initialTransformation);
    }

    void invalidate() {
        this.validated = false;
        this.eventBus.fireEvent(PartContainerState.INVALIDATE);
        this.delinkOtherBlockRequired();
    }

    void onChunkUnload() {
        this.eventBus.fireEvent(PartContainerState.CHUNK_UNLOAD);
        this.delinkOtherBlockRequired();
    }

    boolean isTransformInvalid(class_4990 transformation) {
        PartTransformCheckEvent event = new PartTransformCheckEvent(transformation);
        this.eventBus.fireEvent(event);
        return event.isInvalid();
    }

    void rotate(class_2470 rotation) {
        class_4990 transformation = rotation.method_26383();
        if (this.isTransformInvalid(transformation)) {
            return;
        }
        this.eventBus.fireEvent(PartPreTransformEvent.INSTANCE);
        this.callRotate(rotation);
        this.eventBus.fireEvent(PartTransformEvent.create(transformation));
        this.transformRequiredParts(transformation);
        this.eventBus.fireEvent(PartPostTransformEvent.INSTANCE);
        this.syncAndRedraw();
    }

    private void callRotate(class_2470 rotation) {
        for (PartHolder holder : this.parts) {
            holder.part.rotate(rotation);
        }
    }

    void mirror(class_2415 mirror) {
        class_4990 transformation = mirror.method_26380();
        if (this.isTransformInvalid(transformation)) {
            return;
        }
        this.eventBus.fireEvent(PartPreTransformEvent.INSTANCE);
        this.callMirror(mirror);
        this.eventBus.fireEvent(PartTransformEvent.create(transformation));
        this.transformRequiredParts(transformation);
        this.eventBus.fireEvent(PartPostTransformEvent.INSTANCE);
        this.syncAndRedraw();
    }

    private void callMirror(class_2415 mirror) {
        for (PartHolder holder : this.parts) {
            holder.part.mirror(mirror);
        }
    }

    void transform(class_4990 transformation) {
        if (this.isTransformInvalid(transformation)) {
            return;
        }
        this.eventBus.fireEvent(PartPreTransformEvent.INSTANCE);
        this.tryCallSimplifiedTransform(transformation);
        this.eventBus.fireEvent(PartTransformEvent.create(transformation));
        this.transformRequiredParts(transformation);
        this.eventBus.fireEvent(PartPostTransformEvent.INSTANCE);
        this.syncAndRedraw();
    }

    private void transformRequiredParts(class_4990 transformation) {
        for (PartHolder holder : this.parts) {
            holder.transformRequiredParts(transformation);
        }
    }

    private void tryCallSimplifiedTransform(class_4990 transformation) {
        class_2415 mirror;
        class_2470 rotation = DirectionTransformationUtil.getRotation(transformation);
        if (rotation != null) {
            this.callRotate(rotation);
        }
        if ((mirror = DirectionTransformationUtil.getMirror(transformation)) != null) {
            this.callMirror(mirror);
        }
    }

    void setCachedState(class_2680 state) {
        class_4990 stateTransform = (class_4990)state.method_11654(MultipartBlock.TRANSFORMATION);
        this.updateTransform(stateTransform);
    }

    private void updateTransform(class_4990 stateTransform) {
        if (!this.isClientWorld() && stateTransform != this.cachedTransformation) {
            class_4990 deltaTransform = DirectionTransformationUtil.getRelativeTransformation(this.cachedTransformation, stateTransform);
            this.cachedTransformation = stateTransform;
            this.transform(deltaTransform);
        }
    }

    private void syncAndRedraw() {
        for (PartHolder holder : this.parts) {
            holder.part.sendNetworkUpdate(holder.part, AbstractPart.NET_RENDER_DATA);
        }
        this.recalculateShapeSynced();
        this.redrawIfChanged();
    }

    private void delinkOtherBlockRequired() {
        for (PartHolder holder : this.parts) {
            boolean didRemove;
            PartHolder req;
            Iterator<PartHolder> iterator;
            if (holder.requiredParts != null) {
                iterator = holder.requiredParts.iterator();
                while (iterator.hasNext()) {
                    req = iterator.next();
                    if (req.getContainer() == this) continue;
                    if (holder.unloadedRequiredParts == null) {
                        holder.unloadedRequiredParts = PartHolder.identityHashSet();
                    }
                    holder.unloadedRequiredParts.add(new PosPartId(req));
                    iterator.remove();
                    assert (req.inverseRequiredParts != null);
                    if (req.unloadedInverseRequiredParts == null) {
                        req.unloadedInverseRequiredParts = PartHolder.identityHashSet();
                    }
                    req.unloadedInverseRequiredParts.add(new PosPartId(holder));
                    didRemove = req.inverseRequiredParts.remove(holder);
                    assert (didRemove);
                }
            }
            if (holder.inverseRequiredParts == null) continue;
            iterator = holder.inverseRequiredParts.iterator();
            while (iterator.hasNext()) {
                req = iterator.next();
                if (req.getContainer() == this) continue;
                if (holder.unloadedInverseRequiredParts == null) {
                    holder.unloadedInverseRequiredParts = PartHolder.identityHashSet();
                }
                holder.unloadedInverseRequiredParts.add(new PosPartId(req));
                iterator.remove();
                assert (req.requiredParts != null);
                if (req.unloadedRequiredParts == null) {
                    req.unloadedRequiredParts = PartHolder.identityHashSet();
                }
                req.unloadedRequiredParts.add(new PosPartId(holder));
                didRemove = req.requiredParts.remove(holder);
                assert (didRemove);
            }
        }
    }

    private void linkOtherBlockRequired() {
        if (LibMultiPart.DEBUG) {
            this.log("link_req() {");
        }
        HashMap<class_2338, PartContainer> others = new HashMap<class_2338, PartContainer>();
        class_1937 world = this.getMultipartWorld();
        for (PartHolder holder : this.parts) {
            AbstractPart otherPart;
            PartContainer other;
            Iterator<PosPartId> iterator;
            if (LibMultiPart.DEBUG) {
                this.log(" Holder " + holder.uniqueId + " " + String.valueOf(holder.part.getClass()));
            }
            if (holder.unloadedRequiredParts != null) {
                iterator = holder.unloadedRequiredParts.iterator();
                while (iterator.hasNext()) {
                    PosPartId req = iterator.next();
                    if (LibMultiPart.DEBUG) {
                        this.log("  Required " + String.valueOf(req));
                    }
                    if (!world.method_22340(req.pos)) {
                        if (!LibMultiPart.DEBUG) continue;
                        this.log("    -- not loaded.");
                        continue;
                    }
                    iterator.remove();
                    other = others.computeIfAbsent(req.pos, pos -> MultipartUtilImpl.get(world, pos));
                    if (other == null) {
                        if (!LibMultiPart.DEBUG) continue;
                        this.warn("    -- not a multipart container");
                        continue;
                    }
                    otherPart = other.getPart(req.uid);
                    if (otherPart == null) {
                        if (LibMultiPart.DEBUG) {
                            this.warn("    -- didn't find uid!");
                            continue;
                        }
                        this.warn("[PartContainer.linkOtherBlockRequired] Failed to find the required part " + req.uid + " in " + String.valueOf(other.parts) + "!");
                        continue;
                    }
                    holder.addRequiredPart(otherPart);
                }
            }
            if (holder.unloadedInverseRequiredParts == null) continue;
            iterator = holder.unloadedInverseRequiredParts.iterator();
            while (iterator.hasNext()) {
                PosPartId invreq = iterator.next();
                if (LibMultiPart.DEBUG) {
                    this.log("  InvReq " + String.valueOf(invreq));
                }
                if (!world.method_22340(invreq.pos)) {
                    if (!LibMultiPart.DEBUG) continue;
                    this.log("    -- not loaded.");
                    continue;
                }
                iterator.remove();
                other = others.computeIfAbsent(invreq.pos, pos -> MultipartUtilImpl.get(world, pos));
                if (other == null) {
                    if (!LibMultiPart.DEBUG) continue;
                    this.warn("    -- not a multipart container");
                    continue;
                }
                otherPart = other.getPart(invreq.uid);
                if (otherPart == null) {
                    if (LibMultiPart.DEBUG) {
                        this.warn("    -- didn't find uid!");
                        continue;
                    }
                    this.warn("[PartContainer.linkOtherBlockRequired] Failed to find the required part " + invreq.uid + " in " + String.valueOf(other.parts) + "!");
                    continue;
                }
                otherPart.holder.addRequiredPart(holder.part);
            }
        }
        if (LibMultiPart.DEBUG) {
            this.log("}");
        }
    }

    void onRemoved() {
        this.eventBus.fireEvent(PartContainerState.REMOVE);
    }

    void tick() {
        if (!this.isClientWorld() && this.parts.isEmpty()) {
            this.getMultipartWorld().method_8650(this.getMultipartPos(), false);
            return;
        }
        this.eventBus.fireEvent(PartTickEvent.INSTANCE);
        if (this.havePropertiesChanged) {
            this.havePropertiesChanged = false;
            class_2680 oldState = this.getMultipartWorld().method_8320(this.getMultipartPos());
            if (oldState.method_26204() != LibMultiPart.BLOCK) {
                return;
            }
            class_2680 state = (class_2680)oldState.method_11657((class_2769)MultipartBlock.EMITS_REDSTONE, (Comparable)this.properties.getValue(MultipartProperties.CAN_EMIT_REDSTONE));
            state = (class_2680)state.method_11657((class_2769)MultipartBlock.LUMINANCE, (Comparable)this.properties.getValue(MultipartProperties.LIGHT_VALUE));
            boolean allowWater = this.properties.getValue(MultipartProperties.CAN_BE_WATERLOGGED);
            if (!allowWater && ((Boolean)oldState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
            }
            if (state != oldState) {
                this.getMultipartWorld().method_8501(this.getMultipartPos(), state);
            } else {
                this.updateOwnNeighbours();
            }
        }
        if (!this.hasTicked) {
            this.hasTicked = true;
            this.linkOtherBlockRequired();
        }
    }

    void onListenerAdded(SimpleEventBus.SingleListener<?> single) {
    }

    void onListenerRemoved(SimpleEventBus.SingleListener<?> single) {
    }

    <T> void onPropertyChanged(MultipartProperty<T> property, T old, T current) {
        if (!this.hasTicked) {
            this.havePropertiesChanged = true;
            return;
        }
        if (property == MultipartProperties.CAN_EMIT_REDSTONE) {
            class_2680 state = this.getMultipartWorld().method_8320(this.getMultipartPos());
            state = (class_2680)state.method_11657((class_2769)MultipartBlock.EMITS_REDSTONE, (Comparable)((Boolean)current));
            this.getMultipartWorld().method_8501(this.getMultipartPos(), state);
            return;
        }
        if (property == MultipartProperties.LIGHT_VALUE) {
            class_2680 state = this.getMultipartWorld().method_8320(this.getMultipartPos());
            state = (class_2680)state.method_11657((class_2769)MultipartBlock.LUMINANCE, (Comparable)((Integer)current));
            this.getMultipartWorld().method_8501(this.getMultipartPos(), state);
            return;
        }
        if (property == MultipartProperties.CAN_BE_WATERLOGGED) {
            class_2680 state = this.getMultipartWorld().method_8320(this.getMultipartPos());
            boolean val = Boolean.TRUE.equals(current);
            boolean stateV = (Boolean)state.method_11654((class_2769)class_2741.field_12508);
            if (val || !stateV) {
                return;
            }
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.FALSE);
            this.getMultipartWorld().method_8501(this.getMultipartPos(), state);
            return;
        }
        if (property instanceof MultipartProperties.RedstonePowerProperty) {
            this.getMultipartWorld().method_8408(this.getMultipartPos(), (class_2248)LibMultiPart.BLOCK);
            if (property instanceof MultipartProperties.StrongRedstonePowerProperty) {
                for (class_2350 dir : class_2350.values()) {
                    this.getMultipartWorld().method_8408(this.getMultipartPos().method_10093(dir), (class_2248)LibMultiPart.BLOCK);
                }
            }
            return;
        }
    }

    void addAllAttributes(AttributeList<?> list) {
        list.offer((Object)this);
        for (PartHolder holder : this.parts) {
            holder.part.addAllAttributes(list);
        }
    }

    private void updateOwnNeighbours() {
        class_1937 world = this.getMultipartWorld();
        class_2338 pos = this.getMultipartPos();
        world.method_8408(pos, (class_2248)LibMultiPart.BLOCK);
        this.blockEntity.method_11010().method_30101((class_1936)world, pos, 3);
    }

    int getStrongRedstonePower(class_2350 direction) {
        int emitted = this.properties.getValue(MultipartProperties.getStrongRedstonePower(direction));
        if (emitted == 15) {
            return 15;
        }
        return this.getDynamicRedstone(direction, emitted, STRONG_EVENT_FACTORY);
    }

    int getWeakRedstonePower(class_2350 direction) {
        MultipartProperties.StrongRedstonePowerProperty strongProp = MultipartProperties.getStrongRedstonePower(direction);
        int strong = this.properties.getValue(strongProp);
        if (strong == 15) {
            return 15;
        }
        int emitted = Math.max(strong, this.properties.getValue(MultipartProperties.getWeakRedstonePower(direction)));
        if (emitted == 15) {
            return emitted;
        }
        return this.getDynamicRedstone(direction, emitted, WEAK_EVENT_FACTORY);
    }

    private int getDynamicRedstone(class_2350 direction, int emitted, PartRedstonePowerEvent.PartRedstonePowerEventFactory factory) {
        PartRedstonePowerEvent event = factory.create(emitted, direction);
        this.fireEvent(event);
        return EVENT_VALUE.apply(event);
    }

    static {
        NET_ADD_PART = NET_KEY.idData("add_part").toClientOnly().setReceiver(PartContainer::readAddPart);
        NET_REMOVE_PART = NET_KEY.idData("remove_part").toClientOnly().setReceiver(PartContainer::readRemovePart);
        NET_REMOVE_PARTS = NET_KEY.idData("remove_part_multi").toClientOnly().setReceiver(PartContainer::readRemoveParts);
        NET_ENSURE_EMPTY = NET_KEY.idSignal("ensure_empty").toClientOnly().withoutBuffering().setReceiver(PartContainer::readEnsureEmpty);
        NET_INITIAL_RENDER_DATA = NET_KEY.idData("initial_render_data").toClientOnly().setReadWrite(PartContainer::readInitialRenderData, PartContainer::writeInitialRenderData);
        NET_REDRAW = NET_KEY.idSignal("redraw").toClientOnly().setReceiver(PartContainer::receiveRedraw);
        NET_RECALCULATE_SHAPE = NET_KEY.idSignal("recalculate_shape").toClientOnly().setReceiver(PartContainer::receiveRecalculateShape);
        NET_KEY_PART = new ParentNetIdDuel<PartContainer, AbstractPart>(NET_KEY, "holder", AbstractPart.class){

            protected PartContainer extractParent(AbstractPart value) {
                return PartContainer.extractPartHolder((AbstractPart)value).container;
            }

            protected void writeContext0(NetByteBuf buffer, IMsgWriteCtx ctx, AbstractPart value) {
                PartHolder holder = PartContainer.extractPartHolder(value);
                int index = holder.container.parts.indexOf(holder);
                if (index < 0) {
                    throw new IllegalStateException("The part " + String.valueOf(value) + " doesn't have a valid index in it's container!");
                }
                buffer.method_52997(index);
            }

            protected AbstractPart readContext(NetByteBuf buffer, IMsgReadCtx ctx, PartContainer parentValue) throws InvalidInputDataException {
                List<PartHolder> parts;
                short index = buffer.readUnsignedByte();
                if (index >= (parts = parentValue.parts).size()) {
                    ctx.drop("Invalid part index!");
                    return null;
                }
                return parts.get((int)index).part;
            }
        };
        Class<PartRedstonePowerEvent> from = PartRedstonePowerEvent.class;
        Class<PartRedstonePowerEvent.PartRedstonePowerEventFactory> type = PartRedstonePowerEvent.PartRedstonePowerEventFactory.class;
        STRONG_EVENT_FACTORY = LmpReflection.getStaticApiField(from, "STRONG_FACTORY", type);
        WEAK_EVENT_FACTORY = LmpReflection.getStaticApiField(from, "WEAK_FACTORY", type);
        EVENT_VALUE = LmpReflection.getInstanceApiField(from, "value", Integer.class);
    }
}

