/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.PartLootParams;
import alexiil.mc.lib.multipart.impl.ItemDropCollector;
import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.impl.LmpReflection;
import alexiil.mc.lib.multipart.impl.MissingPartImpl;
import alexiil.mc.lib.multipart.impl.MultipartBlock;
import alexiil.mc.lib.multipart.impl.PartContainer;
import alexiil.mc.lib.multipart.impl.PosPartId;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4990;
import net.minecraft.class_7225;
import net.minecraft.class_8567;

public final class PartHolder
implements MultipartHolder {
    public final PartContainer container;
    public final AbstractPart part;
    long uniqueId = Long.MIN_VALUE;
    Set<PartHolder> requiredParts;
    Set<PartHolder> inverseRequiredParts;
    Set<PosPartId> unloadedRequiredParts;
    Set<PosPartId> unloadedInverseRequiredParts;
    private static final BiFunction<AbstractPart, Object[], Void> CALL_PLAY_BREAK_SOUND = LmpReflection.getInstanceApiMethod(AbstractPart.class, "callPlayBreakSound", Void.class, new Class[0]);

    PartHolder(PartContainer container, MultipartContainer.MultipartCreator creator) {
        this.container = container;
        this.part = creator.create(this);
    }

    PartHolder(PartContainer container, class_2487 tag, class_7225.class_7874 lookup) {
        this.container = container;
        String id = tag.method_10558("id");
        PartDefinition def = PartDefinition.PARTS.get(class_2960.method_12829((String)id));
        this.uniqueId = tag.method_10537("uid");
        class_2487 dataNbt = tag.method_10562("data");
        if (def == null) {
            this.part = new MissingPartImpl(this, id, dataNbt);
            LibMultiPart.LOGGER.warn("Unknown part with ID '" + id + "': it has been turned into an unknown part at " + String.valueOf(container.getMultipartPos()));
        } else {
            class_2520 invreqltag;
            class_2520 reqltag;
            this.part = def.readFromNbt(this, dataNbt, lookup);
            if (LibMultiPart.DEBUG) {
                LibMultiPart.LOGGER.info("  PartHolder.fromTag( " + this.uniqueId + ", " + String.valueOf(this.part.getClass()) + " ) {");
            }
            if ((reqltag = tag.method_10580("req")) instanceof class_2499) {
                class_2499 reql = (class_2499)reqltag;
                for (int i = 0; i < reql.size(); ++i) {
                    class_2487 posPartTag = reql.method_10602(i);
                    if (LibMultiPart.DEBUG) {
                        LibMultiPart.LOGGER.info("    Required ( tag = " + String.valueOf(posPartTag) + " )");
                    }
                    if (!PosPartId.isValid(posPartTag)) {
                        if (!LibMultiPart.DEBUG) continue;
                        LibMultiPart.LOGGER.info("      -- not valid!");
                        continue;
                    }
                    if (this.unloadedRequiredParts == null) {
                        this.unloadedRequiredParts = PartHolder.identityHashSet();
                    }
                    this.unloadedRequiredParts.add(new PosPartId(container, posPartTag));
                }
            }
            if ((invreqltag = tag.method_10580("invReq")) instanceof class_2499) {
                class_2499 invreql = (class_2499)invreqltag;
                for (int i = 0; i < invreql.size(); ++i) {
                    class_2487 posPartTag = invreql.method_10602(i);
                    if (LibMultiPart.DEBUG) {
                        LibMultiPart.LOGGER.info("    InvReq ( tag = " + String.valueOf(posPartTag) + " )");
                    }
                    if (!PosPartId.isValid(posPartTag)) {
                        if (!LibMultiPart.DEBUG) continue;
                        LibMultiPart.LOGGER.info("      -- not valid!");
                        continue;
                    }
                    if (this.unloadedInverseRequiredParts == null) {
                        this.unloadedInverseRequiredParts = PartHolder.identityHashSet();
                    }
                    this.unloadedInverseRequiredParts.add(new PosPartId(container, posPartTag));
                }
            }
        }
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("  }");
        }
    }

    class_2487 toNbt(class_7225.class_7874 lookup) {
        class_2487 nbt = new class_2487();
        nbt.method_10544("uid", this.uniqueId);
        Iterator<PosPartId> iterator = this.part;
        if (iterator instanceof MissingPartImpl) {
            MissingPartImpl missing = (MissingPartImpl)((Object)iterator);
            nbt.method_10582("id", missing.originalId);
            nbt.method_10566("data", (class_2520)missing.originalNbt);
        } else {
            nbt.method_10582("id", this.part.definition.identifier.toString());
            nbt.method_10566("data", (class_2520)this.part.toTag(lookup));
        }
        class_2499 reql = new class_2499();
        if (this.requiredParts != null) {
            for (PartHolder partHolder : this.requiredParts) {
                reql.add((Object)new PosPartId(partHolder).toTag(this.container));
            }
        }
        if (this.unloadedRequiredParts != null) {
            for (PosPartId posPartId : this.unloadedRequiredParts) {
                reql.add((Object)posPartId.toTag(this.container));
            }
        }
        if (!reql.isEmpty()) {
            nbt.method_10566("req", (class_2520)reql);
        }
        class_2499 invReql = new class_2499();
        if (this.inverseRequiredParts != null) {
            for (PartHolder partHolder : this.inverseRequiredParts) {
                invReql.add((Object)new PosPartId(partHolder).toTag(this.container));
            }
        }
        if (this.unloadedInverseRequiredParts != null) {
            for (PosPartId posPartId : this.unloadedInverseRequiredParts) {
                invReql.add((Object)posPartId.toTag(this.container));
            }
        }
        if (!invReql.isEmpty()) {
            nbt.method_10566("invReq", (class_2520)invReql);
        }
        return nbt;
    }

    PartHolder(PartContainer container, NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.uniqueId = buffer.readLong();
        this.container = container;
        class_2960 identifier = buffer.readIdentifierSafe();
        PartDefinition def = PartDefinition.PARTS.get(identifier);
        if (def == null) {
            throw new InvalidInputDataException("Unknown remote part \"" + String.valueOf(identifier) + "\"");
        }
        this.part = def.loadFromBuffer(this, buffer, ctx);
    }

    void writeCreation(NetByteBuf buffer, IMsgWriteCtx ctx) {
        buffer.method_52974(this.uniqueId);
        buffer.writeIdentifier(this.part.definition.identifier);
        this.part.writeCreationData(buffer, ctx);
    }

    static <T> ReferenceOpenHashSet<T> identityHashSet() {
        return new ReferenceOpenHashSet();
    }

    public String toString() {
        return "{PartHolder uid = " + this.uniqueId + ", part = " + String.valueOf(this.part) + "}";
    }

    @Override
    public MultipartContainer getContainer() {
        return this.container;
    }

    @Override
    public AbstractPart getPart() {
        return this.part;
    }

    @Override
    public void remove() {
        this.container.removePart(this.part);
    }

    @Override
    public void remove(MultipartHolder.PartRemoval ... options) {
        if (this.container.isClientWorld()) {
            throw new IllegalStateException("Cannot remove a part on the client!");
        }
        int flags = 0;
        block5: for (MultipartHolder.PartRemoval removal : options) {
            if ((flags & 1 << removal.ordinal()) != 0) continue;
            flags |= 1 << removal.ordinal();
            switch (removal) {
                case DROP_ITEMS: {
                    this.dropItems(null);
                    continue block5;
                }
                case BREAK_PARTICLES: {
                    this.part.sendNetworkUpdate(this.part, AbstractPart.NET_SPAWN_BREAK_PARTICLES);
                    continue block5;
                }
                case BREAK_SOUND: {
                    PartHolder.callPlayBreakSound(this.part);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unknown PartRemoval enum " + String.valueOf((Object)removal));
                }
            }
        }
        this.remove();
    }

    @Override
    public void dropItems(@Nullable class_1657 player) {
        class_8567 params = this.createLootContext(player);
        this.part.addDrops(MultipartBlock.createDropTarget(this.part), params);
    }

    @Override
    public class_2371<class_1799> collectDrops(class_1657 player) {
        class_8567 params = this.createLootContext(player);
        class_2371 drops = class_2371.method_10211();
        this.part.addDrops(new ItemDropCollector((class_2371<class_1799>)drops), params);
        return drops;
    }

    private class_8567 createLootContext(class_1657 player) {
        class_3218 sv = (class_3218)this.container.getMultipartWorld();
        class_8567.class_8568 ctxBuilder = new class_8567.class_8568(sv);
        ctxBuilder.method_51874(class_181.field_1224, (Object)this.container.blockEntity.method_11010());
        ctxBuilder.method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.container.getMultipartPos()));
        ctxBuilder.method_51874(class_181.field_1229, (Object)class_1799.field_8037);
        ctxBuilder.method_51877(class_181.field_1228, (Object)this.container.blockEntity);
        if (player != null) {
            ctxBuilder.method_51877(class_181.field_1226, (Object)player);
        }
        ctxBuilder.method_51874(PartLootParams.BROKEN_PART, (Object)new PartLootParams.BrokenSinglePart(this.part));
        ctxBuilder.method_51874(PartLootParams.ADDITIONAL_PARTS, (Object)new PartLootParams.BrokenSinglePart[0]);
        return ctxBuilder.method_51875(PartLootParams.PART_TYPE);
    }

    private static void callPlayBreakSound(AbstractPart part) {
        CALL_PLAY_BREAK_SOUND.apply(part, null);
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean isPresent() {
        boolean hasUid;
        boolean bl = hasUid = this.uniqueId != Long.MIN_VALUE;
        assert (this.container.parts.contains(this) == hasUid);
        return hasUid;
    }

    @Override
    public void addRequiredPart(AbstractPart other) {
        if (this.addRequiredPart0((PartHolder)other.holder)) {
            // empty if block
        }
    }

    @Override
    public void removeRequiredPart(AbstractPart other) {
        if (this.removeRequiredPart0((PartHolder)other.holder)) {
            // empty if block
        }
    }

    boolean addRequiredPart0(PartHolder req) {
        if (req == null || req == this) {
            return false;
        }
        assert (this.container.parts.contains(this));
        assert (req.container.parts.contains(req));
        if (this.unloadedRequiredParts != null) {
            this.unloadedRequiredParts.remove(new PosPartId(req));
            if (this.unloadedRequiredParts.isEmpty()) {
                this.unloadedRequiredParts = null;
            }
        }
        if (this.requiredParts == null) {
            this.requiredParts = PartHolder.identityHashSet();
        }
        if (this.requiredParts.add(req)) {
            if (req.unloadedInverseRequiredParts != null) {
                Iterator<PosPartId> iterator = req.unloadedInverseRequiredParts.iterator();
                while (iterator.hasNext()) {
                    PosPartId id = iterator.next();
                    if (!id.isFor(this)) continue;
                    iterator.remove();
                }
                if (req.unloadedInverseRequiredParts.isEmpty()) {
                    req.unloadedInverseRequiredParts = null;
                }
            }
            if (req.inverseRequiredParts == null) {
                req.inverseRequiredParts = PartHolder.identityHashSet();
            }
            boolean otherAdded = req.inverseRequiredParts.add(this);
            assert (otherAdded) : "We added but the other part didn't?";
            return true;
        }
        return false;
    }

    boolean removeRequiredPart0(PartHolder req) {
        if (req == null || req == this) {
            return false;
        }
        if (this.unloadedRequiredParts != null) {
            this.unloadedRequiredParts.remove(new PosPartId(req));
            if (this.unloadedRequiredParts.isEmpty()) {
                this.unloadedRequiredParts = null;
            }
        }
        if (this.requiredParts == null) {
            return false;
        }
        if (this.requiredParts.remove(req)) {
            assert (req.inverseRequiredParts != null);
            boolean didRemove = req.inverseRequiredParts.remove(this);
            assert (didRemove) : "We removed but the other part didn't?";
            if (req.inverseRequiredParts.isEmpty()) {
                req.inverseRequiredParts = null;
            }
            if (this.requiredParts.isEmpty()) {
                this.requiredParts = null;
            }
            return true;
        }
        return false;
    }

    public void clearRequiredParts() {
        this.unloadedRequiredParts = null;
        if (this.requiredParts == null) {
            return;
        }
        for (PartHolder holder : this.requiredParts.toArray(new PartHolder[0])) {
            this.removeRequiredPart(holder.part);
        }
        assert (this.requiredParts == null) : "Required Parts (" + String.valueOf(this.requiredParts) + ") wasn't fully cleared!";
    }

    void rotateRequiredParts(class_2470 rotation) {
        this.unloadedRequiredParts = this.rotate(this.unloadedRequiredParts, rotation);
        this.unloadedInverseRequiredParts = this.rotate(this.unloadedInverseRequiredParts, rotation);
    }

    private Set<PosPartId> rotate(Set<PosPartId> parts, class_2470 rotation) {
        if (parts == null) {
            return null;
        }
        ReferenceOpenHashSet to = PartHolder.identityHashSet();
        for (PosPartId pos : parts) {
            to.add((PosPartId)pos.rotate(this.container, rotation));
        }
        return to;
    }

    void mirrorRequiredParts(class_2415 mirror) {
        this.unloadedRequiredParts = this.mirror(this.unloadedRequiredParts, mirror);
        this.unloadedInverseRequiredParts = this.mirror(this.unloadedInverseRequiredParts, mirror);
    }

    private Set<PosPartId> mirror(Set<PosPartId> parts, class_2415 mirror) {
        if (parts == null) {
            return null;
        }
        ReferenceOpenHashSet to = PartHolder.identityHashSet();
        for (PosPartId pos : parts) {
            to.add((PosPartId)pos.mirror(this.container, mirror));
        }
        return to;
    }

    void transformRequiredParts(class_4990 transformation) {
        this.unloadedRequiredParts = this.transform(this.unloadedRequiredParts, transformation);
        this.unloadedInverseRequiredParts = this.transform(this.unloadedInverseRequiredParts, transformation);
    }

    private Set<PosPartId> transform(Set<PosPartId> parts, class_4990 transformation) {
        if (parts == null) {
            return null;
        }
        ReferenceOpenHashSet to = PartHolder.identityHashSet();
        for (PosPartId pos : parts) {
            to.add((PosPartId)pos.transform(this.container, transformation));
        }
        return to;
    }
}

