/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.impl.PartContainer;
import alexiil.mc.lib.multipart.impl.PartHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_4990;
import org.joml.Vector3f;

final class PosPartId {
    private static final Set<String> OLD_EXACT_TAG_NAMES = new HashSet<String>(Arrays.asList("x", "y", "z", "u"));
    private static final Set<String> NEW_OFFSET_TAG_NAMES = new HashSet<String>(Arrays.asList("a", "b", "c", "u"));
    final class_2338 pos;
    final long uid;

    PosPartId(class_2338 pos, long uid) {
        this.pos = pos.method_10062();
        this.uid = uid;
    }

    PosPartId(AbstractPart part) {
        this(part.holder);
    }

    PosPartId(MultipartHolder holder) {
        this(holder.getContainer().getMultipartPos(), holder.getUniqueId());
    }

    PosPartId(PartContainer from, class_2487 tag) {
        if (tag.method_10545("x")) {
            this.pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
        } else {
            class_2338 f = from.getMultipartPos();
            this.pos = new class_2338(tag.method_10550("a") + f.method_10263(), tag.method_10550("b") + f.method_10264(), tag.method_10550("c") + f.method_10260());
        }
        this.uid = tag.method_10537("u");
    }

    class_2487 toTag(PartContainer from) {
        class_2338 f = from.getMultipartPos();
        class_2487 tag = new class_2487();
        tag.method_10569("a", this.pos.method_10263() - f.method_10263());
        tag.method_10569("b", this.pos.method_10264() - f.method_10264());
        tag.method_10569("c", this.pos.method_10260() - f.method_10260());
        tag.method_10544("u", this.uid);
        return tag;
    }

    public static boolean isValid(class_2487 tag) {
        Set keys = tag.method_10541();
        return keys.size() == 4 && (keys.containsAll(OLD_EXACT_TAG_NAMES) || keys.containsAll(NEW_OFFSET_TAG_NAMES));
    }

    public String toString() {
        return "{ " + this.pos.method_10263() + ", " + this.pos.method_10264() + ", " + this.pos.method_10260() + " #" + this.uid + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PosPartId other = (PosPartId)obj;
        return this.uid == other.uid && this.pos.equals((Object)other.pos);
    }

    public int hashCode() {
        long lval = ((this.uid * 524287L + (long)this.pos.method_10263()) * 31L + (long)this.pos.method_10264()) * 31L + (long)this.pos.method_10260();
        return Long.hashCode(lval);
    }

    public boolean posEquals(class_2338 otherPos) {
        return this.pos.equals((Object)otherPos);
    }

    public boolean isFor(PartHolder req) {
        return this.uid == req.uniqueId && this.posEquals(req.container.getMultipartPos());
    }

    public PosPartId rotate(PartContainer from, class_2470 rotation) {
        if (rotation == class_2470.field_11467) {
            return this;
        }
        class_2338 f = from.getMultipartPos();
        return new PosPartId(this.pos.method_10059((class_2382)f).method_10070(rotation).method_10081((class_2382)f), this.uid);
    }

    public PosPartId mirror(PartContainer from, class_2415 mirror) {
        if (mirror == class_2415.field_11302) {
            return this;
        }
        class_2338 f = from.getMultipartPos();
        int x = this.pos.method_10263() - f.method_10263();
        int z = this.pos.method_10260() - f.method_10260();
        if (mirror == class_2415.field_11300) {
            z = -z;
        } else {
            assert (mirror == class_2415.field_11301);
            x = -x;
        }
        return new PosPartId(new class_2338(x + f.method_10263(), this.pos.method_10264(), z + f.method_10260()), this.uid);
    }

    public PosPartId transform(PartContainer from, class_4990 transformation) {
        if (transformation == class_4990.field_23292) {
            return this;
        }
        class_2338 f = from.getMultipartPos();
        Vector3f relPos = new Vector3f((float)(this.pos.method_10263() - f.method_10263()), (float)(this.pos.method_10264() - f.method_10264()), (float)(this.pos.method_10260() - f.method_10260()));
        transformation.method_35814().transform(relPos);
        class_2338 transformedPos = new class_2338(Math.round(relPos.x), Math.round(relPos.y), Math.round(relPos.z));
        return new PosPartId(transformedPos.method_10081((class_2382)f), this.uid);
    }
}

