/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.PartLootParams;
import alexiil.mc.lib.multipart.api.SubdividedPart;
import alexiil.mc.lib.multipart.impl.PartContainer;
import alexiil.mc.lib.multipart.impl.PartHolder;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_8567;

public final class TransientPartIdentifier {
    public final AbstractPart part;
    public final ExtraIdData extra;

    public TransientPartIdentifier(AbstractPart part) {
        this.part = part;
        PartHolder holder = (PartHolder)part.holder;
        Set<PartHolder> parts = PartContainer.getAllRemoved(holder);
        if (parts.size() <= 1) {
            this.extra = new IdAdditional(Collections.emptySet());
        } else {
            ReferenceOpenHashSet additional = new ReferenceOpenHashSet();
            for (PartHolder h : parts) {
                if (h.part == part) continue;
                additional.add(h.part);
            }
            this.extra = new IdAdditional((Set<AbstractPart>)additional);
        }
    }

    public <Sub> TransientPartIdentifier(SubdividedPart<Sub> part, Sub subpart) {
        this.part = (AbstractPart)((Object)part);
        this.extra = new IdSubPart<Sub>(part, subpart);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TransientPartIdentifier other = (TransientPartIdentifier)obj;
        return this.part == other.part && Objects.equals(this.extra, other.extra);
    }

    public int hashCode() {
        return Objects.hash(this.part, this.extra);
    }

    public String toString() {
        return "TransientPartIdentifier{ part = " + String.valueOf(this.part) + ", extra = " + String.valueOf(this.extra) + " }";
    }

    public void putLootContext(class_8567.class_8568 builder) {
        builder.method_51874(PartLootParams.BROKEN_PART, (Object)new PartLootParams.BrokenSinglePart(this.part));
        this.extra.putLootContext(builder);
    }

    public static final class IdAdditional
    extends ExtraIdData {
        public final Set<AbstractPart> additional;

        public IdAdditional(Set<AbstractPart> additional) {
            this.additional = additional;
        }

        @Override
        protected void putLootContext(class_8567.class_8568 builder) {
            PartLootParams.BrokenPart[] array = new PartLootParams.BrokenPart[this.additional.size()];
            int i = 0;
            for (AbstractPart part : this.additional) {
                array[i++] = new PartLootParams.BrokenSinglePart(part);
            }
            builder.method_51874(PartLootParams.ADDITIONAL_PARTS, (Object)array);
        }
    }

    public static abstract class ExtraIdData {
        ExtraIdData() {
        }

        protected abstract void putLootContext(class_8567.class_8568 var1);
    }

    public static final class IdSubPart<Sub>
    extends ExtraIdData {
        public final SubdividedPart<Sub> part;
        public final Sub subpart;

        public IdSubPart(SubdividedPart<Sub> part, Sub subpart) {
            this.part = part;
            this.subpart = subpart;
        }

        @Override
        protected void putLootContext(class_8567.class_8568 builder) {
            builder.method_51874(PartLootParams.BROKEN_PART, new PartLootParams.BrokenSubPart<Sub>(this.part, this.subpart));
            builder.method_51874(PartLootParams.ADDITIONAL_PARTS, (Object)new PartLootParams.BrokenPart[0]);
        }
    }
}

