/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.api;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.multipart.impl.LmpInternalOnly;
import alexiil.mc.lib.multipart.impl.PartContainer;
import alexiil.mc.lib.multipart.impl.SingleReplacementBlockView;
import alexiil.mc.lib.multipart.impl.client.SingleSpriteProvider;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.NetIdSignalK;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdSingle;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_7225;
import net.minecraft.class_727;
import net.minecraft.class_8567;
import net.minecraft.class_9062;

public abstract class AbstractPart {
    public static final ParentNetIdSingle<AbstractPart> NET_ID = PartContainer.NET_KEY_PART;
    public static final NetIdDataK<AbstractPart> NET_RENDER_DATA = NET_ID.idData("render_data").toClientOnly().setReadWrite(AbstractPart::readRenderData, AbstractPart::writeRenderData);
    public static final NetIdSignalK<AbstractPart> NET_SPAWN_BREAK_PARTICLES = NET_ID.idSignal("spawn_break_particles").toClientOnly().withoutBuffering().setReceiver(AbstractPart::spawnBreakParticles);
    public static final NetIdDataK<AbstractPart> NET_SPAWN_FALL_PARTICLES = NET_ID.idData("spawn_fall_particles").toClientOnly().setReceiver(AbstractPart::spawnFallParticles);
    public final PartDefinition definition;
    public final MultipartHolder holder;
    public final MultipartContainer container;

    public AbstractPart(PartDefinition definition, MultipartHolder holder) {
        this.definition = definition;
        this.holder = holder;
        this.container = holder.getContainer();
    }

    public class_2487 toTag(class_7225.class_7874 lookup) {
        return new class_2487();
    }

    public void writeCreationData(NetByteBuf buffer, IMsgWriteCtx ctx) {
    }

    public void writeRenderData(NetByteBuf buffer, IMsgWriteCtx ctx) {
    }

    public void readRenderData(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
    }

    public final <T> void sendNetworkUpdate(T obj, NetIdTyped<T> netId) {
        this.container.sendNetworkUpdate(obj, netId);
    }

    public final <T> void sendNetworkUpdate(T obj, NetIdDataK<T> netId, NetIdDataK.IMsgDataWriterK<T> writer) {
        this.container.sendNetworkUpdate(obj, netId, writer);
    }

    public final <T> void sendNetworkUpdateExcept(@Nullable class_1657 except, T obj, NetIdTyped<T> netId) {
        this.container.sendNetworkUpdateExcept(except, obj, netId);
    }

    public final <T> void sendNetworkUpdateExcept(@Nullable class_1657 except, T obj, NetIdDataK<T> netId, NetIdDataK.IMsgDataWriterK<T> writer) {
        this.container.sendNetworkUpdateExcept(except, obj, netId, writer);
    }

    public final void redrawIfChanged() {
        this.container.redrawIfChanged();
    }

    public final void recalculateShape() {
        this.container.recalculateShape();
    }

    public final void recalculateShapeSynced() {
        this.container.recalculateShapeSynced();
    }

    public void preConvertNativeMultipart() {
    }

    public void onAdded(MultipartEventBus bus) {
    }

    public void onRemoved() {
    }

    public void onPlacedBy(class_1657 player, class_1268 hand) {
    }

    public boolean onBreak(class_1657 player) {
        if (!this.container.isClientWorld()) {
            this.playBreakSound();
            this.sendNetworkUpdate((Object)this, (NetIdTyped)NET_SPAWN_BREAK_PARTICLES);
        }
        return true;
    }

    protected class_2680 getClosestBlockState() {
        return class_2246.field_10566.method_9564();
    }

    @Environment(value=EnvType.CLIENT)
    public void playHitSound(class_1657 player) {
        this.playHitSound(this.getClosestBlockState());
    }

    protected void playBreakSound() {
        this.playBreakSound(this.getClosestBlockState());
    }

    protected final void playBreakSound(class_2680 blockState) {
        class_1937 world = this.container.getMultipartWorld();
        class_2498 group = blockState.method_26231();
        world.method_8396(null, this.container.getMultipartPos(), group.method_10595(), class_3419.field_15245, (group.method_10597() + 1.0f) / 2.0f, group.method_10599() * 0.8f);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void playHitSound(class_2680 blockState) {
        class_2498 group = blockState.method_26231();
        class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(group.method_10596(), class_3419.field_15245, (group.method_10597() + 1.0f) / 8.0f, group.method_10599() * 0.8f, class_1113.method_43221(), this.container.getMultipartPos()));
    }

    private final void spawnBreakParticles(IMsgReadCtx ctx) throws InvalidInputDataException {
        ctx.assertClientSide();
        this.spawnBreakParticles();
    }

    @Deprecated
    @Environment(value=EnvType.CLIENT)
    public boolean spawnBreakingParticles(class_2350 side) {
        return this.spawnHitParticle(side);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean spawnHitParticle(class_2350 side) {
        this.spawnHitParticle(side, this.getClosestBlockState());
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnHitParticle(class_2350 side, class_2680 state) {
        this.spawnHitParticle(side, state, (class_1058)null);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnHitParticle(class_2350 side, class_2680 state, @Nullable class_2960 spriteId) {
        class_1058 sprite = spriteId == null ? null : AbstractPart.getBlockAtlas().apply(spriteId);
        this.spawnHitParticle(side, state, sprite);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnHitParticle(class_2350 side, class_2680 state, @Nullable class_1058 sprite) {
        this.spawnHitParticle(side, this.getOutlineShape().method_1107(), state, sprite);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnHitParticle(class_2350 side, class_238 box, class_2680 state, @Nullable class_1058 sprite) {
        class_1937 world = this.container.getMultipartWorld();
        class_2338 pos = this.container.getMultipartPos();
        class_702 manager = class_310.method_1551().field_1713;
        double x = (double)pos.method_10263() + box.field_1323 + AbstractPart.pos(world, side, class_2350.class_2351.field_11048, box.field_1320 - box.field_1323);
        double y = (double)pos.method_10264() + box.field_1322 + AbstractPart.pos(world, side, class_2350.class_2351.field_11052, box.field_1325 - box.field_1322);
        double z = (double)pos.method_10260() + box.field_1321 + AbstractPart.pos(world, side, class_2350.class_2351.field_11051, box.field_1324 - box.field_1321);
        class_727 particle = new class_727((class_638)world, x, y, z, 0.0, 0.0, 0.0, state, pos);
        particle.method_3075(0.2f);
        particle.method_3087(0.6f);
        if (sprite != null) {
            particle.method_18140((class_4002)new SingleSpriteProvider(sprite));
        }
        manager.method_3058((class_703)particle);
    }

    protected static final double pos(class_1937 world, class_2350 side, class_2350.class_2351 axis, double size) {
        if (side.method_10166() == axis) {
            if (side.method_10171() == class_2350.class_2352.field_11060) {
                return -0.1;
            }
            return size + 0.1;
        }
        if (size >= 0.5) {
            return 0.1 + (size - 0.2) * world.field_9229.method_43058();
        }
        double off = size / 8.0;
        return off + (size - 2.0 * off) * world.field_9229.method_43058();
    }

    @Environment(value=EnvType.CLIENT)
    private static Function<class_2960, class_1058> getBlockAtlas() {
        return class_310.method_1551().method_1549(class_1059.field_5275);
    }

    @Environment(value=EnvType.CLIENT)
    protected void spawnBreakParticles() {
        this.spawnBreakParticles(this.getClosestBlockState());
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnBreakParticles(class_2680 state) {
        this.spawnBreakParticles(state, (class_1058)null);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnBreakParticles(class_2680 state, @Nullable class_2960 spriteId) {
        class_1058 sprite = spriteId == null ? null : AbstractPart.getBlockAtlas().apply(spriteId);
        this.spawnBreakParticles(state, sprite);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnBreakParticles(class_2680 state, @Nullable class_1058 sprite) {
        class_1937 world = this.container.getMultipartWorld();
        class_2338 pos = this.container.getMultipartPos();
        class_702 manager = class_310.method_1551().field_1713;
        class_265 voxelShape = this.getOutlineShape();
        for (class_238 box : voxelShape.method_1090()) {
            double x0 = box.field_1323;
            double y0 = box.field_1322;
            double z0 = box.field_1321;
            double x1 = box.field_1320;
            double y1 = box.field_1325;
            double z1 = box.field_1324;
            double minX = Math.min(1.0, x1 - x0);
            double minY = Math.min(1.0, y1 - y0);
            double minZ = Math.min(1.0, z1 - z0);
            int maxX = Math.max(2, class_3532.method_15384((double)(minX / 0.25)));
            int maxY = Math.max(2, class_3532.method_15384((double)(minY / 0.25)));
            int maxZ = Math.max(2, class_3532.method_15384((double)(minZ / 0.25)));
            for (int x = 0; x < maxX; ++x) {
                for (int y = 0; y < maxY; ++y) {
                    for (int z = 0; z < maxZ; ++z) {
                        double vX = ((double)x + 0.5) / (double)maxX;
                        double vY = ((double)y + 0.5) / (double)maxY;
                        double vZ = ((double)z + 0.5) / (double)maxZ;
                        double pX = vX * minX + x0;
                        double pY = vY * minY + y0;
                        double pZ = vZ * minZ + z0;
                        class_727 particle = new class_727((class_638)world, (double)pos.method_10263() + pX, (double)pos.method_10264() + pY, (double)pos.method_10260() + pZ, vX - 0.5, vY - 0.5, vZ - 0.5, state, pos);
                        if (sprite != null) {
                            particle.method_18140((class_4002)new SingleSpriteProvider(sprite));
                        }
                        manager.method_3058((class_703)particle);
                    }
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean spawnSprintParticle(class_1297 sprintingEntity, class_5819 entityRandom) {
        this.spawnSprintParticle(sprintingEntity, entityRandom, this.getClosestBlockState());
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnSprintParticle(class_1297 sprintingEntity, class_5819 entityRandom, class_2680 state) {
        this.spawnSprintParticle(sprintingEntity, entityRandom, state, (class_1058)null);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnSprintParticle(class_1297 sprintingEntity, class_5819 entityRandom, class_2680 state, @Nullable class_2960 spriteId) {
        class_1058 sprite = spriteId == null ? null : AbstractPart.getBlockAtlas().apply(spriteId);
        this.spawnSprintParticle(sprintingEntity, entityRandom, state, sprite);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnSprintParticle(class_1297 sprintingEntity, class_5819 entityRandom, class_2680 state, @Nullable class_1058 sprite) {
        class_1937 world = this.container.getMultipartWorld();
        class_2338 blockPos = this.container.getMultipartPos();
        class_702 manager = class_310.method_1551().field_1713;
        class_243 velocity = sprintingEntity.method_18798();
        double width = sprintingEntity.method_17681();
        double x = sprintingEntity.method_23317() + (entityRandom.method_43058() - 0.5) * width;
        double y = sprintingEntity.method_23318() + 0.1;
        double z = sprintingEntity.method_23321() + (entityRandom.method_43058() - 0.5) * width;
        double dx = velocity.field_1352 * -4.0;
        double dy = 1.5;
        double dz = velocity.field_1350 * -4.0;
        class_727 particle = new class_727((class_638)world, x, y, z, dx, dy, dz, state, blockPos);
        if (sprite != null) {
            particle.method_18140((class_4002)new SingleSpriteProvider(sprite));
        }
        manager.method_3058((class_703)particle);
    }

    public boolean onSpawnFallParticles(class_1309 fallenEntity, class_5819 entityRandom) {
        float f = class_3532.method_15386((float)(fallenEntity.field_6017 - 3.0f));
        double d = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int count = (int)(150.0 * d);
        this.sendSpawnFallParticles(fallenEntity.method_19538(), count);
        return true;
    }

    protected final void sendSpawnFallParticles(class_243 pos, int count) {
        this.sendNetworkUpdate(this, NET_SPAWN_FALL_PARTICLES, (obj, buffer, ctx) -> {
            ctx.assertServerSide();
            buffer.method_52940(pos.field_1352);
            buffer.method_52940(pos.field_1351);
            buffer.method_52940(pos.field_1350);
            buffer.method_53002(count);
        });
    }

    private void spawnFallParticles(NetByteBuf buf, IMsgReadCtx ctx) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        int count = buf.readInt();
        this.spawnFallParticles(pos, count);
    }

    @Environment(value=EnvType.CLIENT)
    protected void spawnFallParticles(class_243 pos, int count) {
        this.spawnFallParticles(pos, count, this.getClosestBlockState());
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnFallParticles(class_243 pos, int count, class_2680 state) {
        this.spawnFallParticles(pos, count, state, (class_1058)null);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnFallParticles(class_243 pos, int count, class_2680 state, @Nullable class_2960 spriteId) {
        class_1058 sprite = spriteId == null ? null : AbstractPart.getBlockAtlas().apply(spriteId);
        this.spawnFallParticles(pos, count, state, sprite);
    }

    @Environment(value=EnvType.CLIENT)
    protected final void spawnFallParticles(class_243 pos, int count, class_2680 state, @Nullable class_1058 sprite) {
        class_1937 world = this.container.getMultipartWorld();
        class_2338 blockPos = this.container.getMultipartPos();
        class_5819 random = world.field_9229;
        class_702 manager = class_310.method_1551().field_1713;
        for (int i = 0; i < count; ++i) {
            double dx = random.method_43059() * 0.15;
            double dy = random.method_43059() * 0.15;
            double dz = random.method_43059() * 0.15;
            class_727 particle = new class_727((class_638)world, pos.method_10216(), pos.method_10214(), pos.method_10215(), dx, dy, dz, state, blockPos);
            if (sprite != null) {
                particle.method_18140((class_4002)new SingleSpriteProvider(sprite));
            }
            manager.method_3058((class_703)particle);
        }
    }

    protected final void addRequiredPart(AbstractPart required) {
        this.holder.addRequiredPart(required);
    }

    protected final void removeRequiredPart(AbstractPart required) {
        this.holder.removeRequiredPart(required);
    }

    public abstract class_265 getShape();

    public boolean canOverlapWith(AbstractPart other) {
        return false;
    }

    public class_265 getCollisionShape() {
        return this.getShape();
    }

    public class_265 getCullingShape() {
        return this.getCollisionShape();
    }

    public class_265 getOutlineShape() {
        return this.getCollisionShape();
    }

    public class_265 getSidesShape() {
        return this.getCollisionShape();
    }

    @Deprecated
    public class_265 getDynamicShape(float partialTicks) {
        return this.getOutlineShape();
    }

    public class_265 getDynamicShape(float partialTicks, class_243 hitVec) {
        return this.getDynamicShape(partialTicks);
    }

    public boolean isBlocking(class_2350 searchDirection) {
        return true;
    }

    public void addAllAttributes(AttributeList<?> list) {
        class_2350 searchDirection = list.getSearchDirection();
        if (searchDirection != null && this.isBlocking(searchDirection)) {
            list.obstruct(this.getShape());
        }
    }

    @Deprecated
    public class_1799 getPickStack() {
        return class_1799.field_8037;
    }

    public class_1799 getPickStack(@Nullable class_3965 hitResult) {
        return this.getPickStack();
    }

    public void addDrops(ItemDropTarget target, class_8567 params) {
        class_2371 list = class_2371.method_10211();
        this.addDrops((class_2371<class_1799>)list);
        if (!list.isEmpty()) {
            target.dropAll((Iterable<class_1799>)list);
        }
    }

    @Deprecated
    public void addDrops(class_2371<class_1799> to) {
        class_1799 pickStack = this.getPickStack(null);
        if (!pickStack.method_7960()) {
            to.add((Object)pickStack);
        }
    }

    public class_2561 getName(@Nullable class_3965 hitResult) {
        return this.getPickStack(hitResult).method_7964();
    }

    public void afterBreak(class_1657 player) {
        player.method_7322(0.005f);
    }

    public float calculateBreakingDelta(class_1657 player) {
        return this.calculateBreakingDelta(player, this.getClosestBlockState());
    }

    public final float calculateBreakingDelta(class_1657 player, class_2248 block) {
        return this.calculateBreakingDelta(player, block.method_9564());
    }

    public final float calculateBreakingDelta(class_1657 player, class_2680 state) {
        class_1937 world = this.container.getMultipartWorld();
        class_2338 thisPos = this.container.getMultipartPos();
        float hardness = state.method_26214((class_1922)new SingleReplacementBlockView((class_1922)world, thisPos, state), thisPos);
        return AbstractPart.calcBreakingDelta(player, state, hardness);
    }

    public static float calcBreakingDelta(class_1657 player, class_2680 state, float hardness) {
        if (hardness == -1.0f) {
            return 0.0f;
        }
        int mult = player.method_7305(state) ? 30 : 100;
        return player.method_7351(state) / hardness / (float)mult;
    }

    public class_1269 onUse(class_1657 player, class_3965 hit) {
        return class_1269.field_5811;
    }

    public class_9062 onUseWithItem(class_1799 stack, class_1657 player, class_1268 hand, class_3965 hit) {
        return class_9062.field_47731;
    }

    @Deprecated
    public void rotate(class_2470 rotation) {
    }

    @Deprecated
    public void mirror(class_2415 mirror) {
    }

    @Nullable
    public abstract PartModelKey getModelKey();

    @LmpInternalOnly
    private final void callPlayBreakSound() {
        this.playBreakSound();
    }

    public static interface ItemDropTarget {
        public void drop(class_1799 var1);

        default public void dropAll(Iterable<class_1799> iter) {
            for (class_1799 stack : iter) {
                this.drop(stack);
            }
        }

        public void drop(class_1799 var1, class_243 var2);

        public void drop(class_1799 var1, class_243 var2, class_243 var3);

        public boolean dropsAsEntity();
    }
}

