/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.api;

import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.Attributes;
import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.event.MultipartEvent;
import alexiil.mc.lib.multipart.api.property.MultipartPropertyContainer;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.NetIdTyped;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2874;

public interface MultipartContainer {
    public static final Attribute<MultipartContainer> ATTRIBUTE = Attributes.create(MultipartContainer.class);

    public class_1937 getMultipartWorld();

    public class_2338 getMultipartPos();

    public class_2586 getMultipartBlockEntity();

    public void markChunkDirty();

    default public class_2874 getDimension() {
        return this.getMultipartWorld().method_8597();
    }

    default public boolean isClientWorld() {
        return this.getMultipartWorld().field_9236;
    }

    public boolean canPlayerInteract(class_1657 var1);

    @Nullable
    public class_2586 getNeighbourBlockEntity(class_2350 var1);

    public List<AbstractPart> getAllParts();

    default public List<AbstractPart> getAllParts(Predicate<AbstractPart> filter) {
        ArrayList<AbstractPart> list = new ArrayList<AbstractPart>();
        for (AbstractPart part : this.getAllParts()) {
            if (!filter.test(part)) continue;
            list.add(part);
        }
        return list;
    }

    default public <P> List<P> getParts(Class<P> clazz) {
        ArrayList<P> list = new ArrayList<P>();
        for (AbstractPart part : this.getAllParts()) {
            if (!clazz.isInstance(part)) continue;
            list.add(clazz.cast(part));
        }
        return list;
    }

    default public <P> List<P> getParts(Class<P> clazz, Predicate<P> filter) {
        ArrayList<P> list = new ArrayList<P>();
        for (AbstractPart part : this.getAllParts()) {
            P typed;
            if (!clazz.isInstance(part) || !filter.test(typed = clazz.cast(part))) continue;
            list.add(typed);
        }
        return list;
    }

    @Nullable
    default public AbstractPart getFirstPart(Predicate<AbstractPart> filter) {
        List<AbstractPart> parts = this.getAllParts(filter);
        return parts.isEmpty() ? null : parts.get(0);
    }

    @Nullable
    default public <P> P getFirstPart(Class<P> clazz) {
        List<P> parts = this.getParts(clazz);
        return parts.isEmpty() ? null : (P)parts.get(0);
    }

    @Nullable
    default public <P> P getFirstPart(Class<P> clazz, Predicate<P> filter) {
        List<P> parts = this.getParts(clazz, filter);
        return parts.isEmpty() ? null : (P)parts.get(0);
    }

    @Nullable
    public AbstractPart getPart(class_243 var1);

    @Nullable
    public AbstractPart getPart(long var1);

    @Nullable
    public PartOffer offerNewPart(MultipartCreator var1, boolean var2);

    @Nullable
    default public PartOffer offerNewPart(MultipartCreator creator) {
        return this.offerNewPart(creator, true);
    }

    @Nullable
    default public MultipartHolder addNewPart(MultipartCreator creator, boolean respectEntityBBs) {
        PartOffer offer = this.offerNewPart(creator, respectEntityBBs);
        if (offer == null) {
            return null;
        }
        offer.apply();
        return offer.getHolder();
    }

    default public MultipartHolder addNewPart(MultipartCreator creator) {
        return this.addNewPart(creator, true);
    }

    default public boolean testNewPart(MultipartCreator creator, boolean respectEntityBBs) {
        return this.offerNewPart(creator, respectEntityBBs) != null;
    }

    default public boolean testNewPart(MultipartCreator creator) {
        return this.offerNewPart(creator, true) != null;
    }

    public boolean removePart(AbstractPart var1);

    public class_265 getCurrentShape();

    public class_265 getCollisionShape();

    public class_265 getOutlineShape();

    public void recalculateShape();

    public void recalculateShapeSynced();

    default public <T> void sendNetworkUpdate(T obj, NetIdTyped<T> netId) {
        this.sendNetworkUpdateExcept(null, obj, netId);
    }

    default public <T> void sendNetworkUpdate(T obj, NetIdDataK<T> netId, NetIdDataK.IMsgDataWriterK<T> writer) {
        this.sendNetworkUpdateExcept(null, obj, netId, writer);
    }

    public <T> void sendNetworkUpdateExcept(@Nullable class_1657 var1, T var2, NetIdTyped<T> var3);

    public <T> void sendNetworkUpdateExcept(@Nullable class_1657 var1, T var2, NetIdDataK<T> var3, NetIdDataK.IMsgDataWriterK<T> var4);

    public MultipartEventBus getEventBus();

    default public boolean fireEvent(MultipartEvent event) {
        return this.getEventBus().fireEvent(event);
    }

    public boolean hasTicked();

    public MultipartPropertyContainer getProperties();

    public void redrawIfChanged();

    @FunctionalInterface
    public static interface MultipartCreator {
        public AbstractPart create(MultipartHolder var1);
    }

    public static interface PartOffer {
        public MultipartHolder getHolder();

        public void apply();
    }
}

