/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.api;

import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.event.EventListener;
import alexiil.mc.lib.multipart.api.event.MultipartEvent;
import alexiil.mc.lib.multipart.api.event.MultipartEventExternalListener;
import java.util.List;

public interface MultipartEventBus {
    public MultipartContainer getContainer();

    public <E extends MultipartEvent> ListenerInfo<E> addListener(Object var1, Class<E> var2, EventListener<E> var3);

    default public <E extends MultipartEvent> ListenerInfo<E> addContextlessListener(Object key, Class<E> clazz, Runnable listener) {
        return this.addListener(key, clazz, new ContextlessListener(listener));
    }

    default public <E extends MultipartEvent> ListenerInfo<E> addRunOnceListener(Object key, Class<E> clazz, Runnable listener) {
        ListenerInfo[] ref;
        ListenerInfo<E> info = this.addContextlessListener(key, clazz, () -> {
            if (ref[0] != null) {
                listener.run();
                ref[0].remove();
                ref[0] = null;
            }
        });
        ref = new ListenerInfo[]{info};
        return info;
    }

    default public <E extends MultipartEvent> ListenerInfo<E> addExternalListener(Object key, Class<E> clazz, MultipartEventExternalListener<E> listener) {
        MultipartContainer container = this.getContainer();
        return this.addListener(key, clazz, new ExternalListener<E>(container, listener));
    }

    public boolean fireEvent(MultipartEvent var1);

    public void removeListeners(Object var1);

    public List<ListenerInfo<? extends MultipartEvent>> getListenersForKey(Object var1);

    default public boolean hasAnyListenersForKey(Object key) {
        return !this.getListenersForKey(key).isEmpty();
    }

    public <E extends MultipartEvent> List<? extends ListenerInfo<? extends E>> getListeners(Class<E> var1);

    public List<? extends ListenerInfo<?>> getAllListeners();

    default public boolean hasAnyListenersFor(Class<? extends MultipartEvent> clazz) {
        return !this.getListeners(clazz).isEmpty();
    }

    default public boolean hasAnyListeners() {
        return !this.getAllListeners().isEmpty();
    }

    public static final class ContextlessListener<E extends MultipartEvent>
    implements EventListener<E> {
        public final Runnable listener;

        public ContextlessListener(Runnable listener) {
            this.listener = listener;
        }

        @Override
        public void onEvent(E event) {
            this.listener.run();
        }

        public String toString() {
            return "{Runnable: " + String.valueOf(this.listener) + "}";
        }
    }

    public static interface ListenerInfo<E extends MultipartEvent> {
        public Object getKey();

        public Class<E> getListenerClass();

        public EventListener<E> getListener();

        public void remove();

        public boolean isPresent();
    }

    public static final class ExternalListener<E extends MultipartEvent>
    implements EventListener<E> {
        public final MultipartContainer container;
        public final MultipartEventExternalListener<E> listener;

        public ExternalListener(MultipartContainer container, MultipartEventExternalListener<E> listener) {
            this.container = container;
            this.listener = listener;
        }

        @Override
        public void onEvent(E event) {
            this.listener.onEvent(this.container, event);
        }

        public String toString() {
            return "{External: " + String.valueOf(this.listener) + "}";
        }
    }
}

