/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.impl.LmpInternalOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class LmpReflection {
    public static <T> T getStaticApiField(Class<?> from, String field, Class<T> fieldType) {
        try {
            LmpReflection.checkPackage(from);
            Field fld = from.getDeclaredField(field);
            if (fld.getAnnotation(LmpInternalOnly.class) == null) {
                throw new Error("Tried to access a non-internally exposed field! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")");
            }
            fld.setAccessible(true);
            LmpReflection.checkFieldType(from, field, fieldType, fld);
            if ((fld.getModifiers() & 8) == 0) {
                throw new Error("LMP field is not static when we expected it to be static! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")");
            }
            return fieldType.cast(fld.get(null));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new Error("LMP failed to access it's own field?! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")", e);
        }
    }

    public static <C, F> Function<C, F> getInstanceApiField(Class<C> from, String field, Class<F> fieldType) {
        try {
            LmpReflection.checkPackage(from);
            Field fld = from.getDeclaredField(field);
            if (fld.getAnnotation(LmpInternalOnly.class) == null) {
                throw new Error("Tried to access a non-internally exposed field! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")");
            }
            fld.setAccessible(true);
            LmpReflection.checkFieldType(from, field, fieldType, fld);
            if ((fld.getModifiers() & 8) != 0) {
                throw new Error("LMP field is static when we expected it not to be! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")");
            }
            return instance -> {
                try {
                    return fieldType.cast(fld.get(instance));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new Error("LMP failed to access it's own field?! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")", e);
                }
            };
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new Error("LMP failed to access it's own field?! (" + String.valueOf(from) + " ." + field + " of " + String.valueOf(fieldType) + ")", e);
        }
    }

    private static void checkFieldType(Class<?> from, String field, Class<?> expectedType, Field fld) throws Error {
        Class<Object> foundType = fld.getType();
        if (foundType.isPrimitive() && !expectedType.isPrimitive()) {
            if (foundType == Character.TYPE) {
                foundType = Character.class;
            } else if (foundType == Boolean.TYPE) {
                foundType = Boolean.class;
            } else if (foundType == Byte.TYPE) {
                foundType = Byte.class;
            } else if (foundType == Short.TYPE) {
                foundType = Short.class;
            } else if (foundType == Integer.TYPE) {
                foundType = Integer.class;
            } else if (foundType == Long.TYPE) {
                foundType = Long.class;
            } else if (foundType == Float.TYPE) {
                foundType = Float.class;
            } else if (foundType == Double.TYPE) {
                foundType = Double.class;
            }
        }
        if (foundType != expectedType) {
            throw new Error("LMP field type is different! (" + String.valueOf(from) + " ." + field + ": expecting " + String.valueOf(expectedType) + ", but got " + String.valueOf(foundType) + ")");
        }
    }

    public static <C> Function<Object[], C> getApiConstructor(Class<C> from, Class<?> ... argTypes) {
        return LmpReflection.getThrowingApiConstructor(from, RuntimeException.class, argTypes)::call;
    }

    public static <C, T extends Throwable> ThrowingFunction<Object[], C, T> getThrowingApiConstructor(Class<C> from, Class<T> exceptionType, Class<?> ... argTypes) {
        try {
            LmpReflection.checkPackage(from);
            Constructor ctor = from.getDeclaredConstructor(argTypes);
            if (ctor.getAnnotation(LmpInternalOnly.class) == null) {
                throw new Error("Tried to access a non-internally exposed constructor! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")");
            }
            if (exceptionType != null && Throwable.class == exceptionType) {
                throw new Error("Don't catch all throwables -_-");
            }
            for (Class<?> ex : ctor.getExceptionTypes()) {
                if (Error.class.isAssignableFrom(ex) || RuntimeException.class.isAssignableFrom(ex)) continue;
                if (exceptionType == null) {
                    throw new Error("Tried to access a constructor that throws " + String.valueOf(ex) + " without declaring a way to catch it!");
                }
                if (exceptionType.isAssignableFrom(ex)) continue;
                throw new Error("Tried to access a constructor that throws " + String.valueOf(ex) + " but we only catch " + String.valueOf(exceptionType));
            }
            ctor.setAccessible(true);
            return args -> {
                try {
                    return ctor.newInstance(args);
                }
                catch (InvocationTargetException e) {
                    throw LmpReflection.rethrowException(exceptionType, e);
                }
                catch (IllegalArgumentException e) {
                    throw new Error("LMP passed the wrong types to it's own constructor?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + " passed " + Arrays.toString(args) + ")", e);
                }
                catch (ReflectiveOperationException e) {
                    throw new Error("LMP failed to access it's own constructor?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")", e);
                }
            };
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new Error("LMP failed to access it's own constructor?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")", e);
        }
    }

    public static <C, R> Function<Object[], R> getStaticApiMethod(Class<C> from, String methodName, Class<R> returnType, Class<?> ... argTypes) {
        return LmpReflection.getStaticThrowingApiMethod(from, methodName, returnType, RuntimeException.class, argTypes)::call;
    }

    public static <C, R, T extends Throwable> ThrowingFunction<Object[], R, T> getStaticThrowingApiMethod(Class<C> from, String methodName, Class<R> returnType, Class<T> exceptionType, Class<?> ... argTypes) {
        try {
            LmpReflection.checkPackage(from);
            Method method = from.getDeclaredMethod(methodName, argTypes);
            if (method.getAnnotation(LmpInternalOnly.class) == null) {
                throw new Error("Tried to access a non-internally exposed method! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")");
            }
            if ((method.getModifiers() & 8) == 0) {
                throw new Error("LMP method is not static when we expected it to be! (" + String.valueOf(from) + " ." + String.valueOf(method) + ")");
            }
            if (exceptionType != null && Throwable.class == exceptionType) {
                throw new Error("Don't catch all throwables -_-");
            }
            for (Class<?> ex : method.getExceptionTypes()) {
                if (Error.class.isAssignableFrom(ex) || RuntimeException.class.isAssignableFrom(ex)) continue;
                if (exceptionType == null) {
                    throw new Error("Tried to access a method that throws " + String.valueOf(ex) + " without declaring a way to catch it!");
                }
                if (exceptionType.isAssignableFrom(ex)) continue;
                throw new Error("Tried to access a method that throws " + String.valueOf(ex) + " but we only catch " + String.valueOf(exceptionType));
            }
            method.setAccessible(true);
            return args -> {
                try {
                    Object ret = method.invoke(null, args);
                    if (ret == null) {
                        return null;
                    }
                    if (returnType.isInstance(ret)) {
                        return returnType.cast(ret);
                    }
                    throw new Error("The method returned value was not of the right class!");
                }
                catch (InvocationTargetException e) {
                    throw LmpReflection.rethrowException(exceptionType, e);
                }
                catch (IllegalArgumentException e) {
                    throw new Error("LMP passed the wrong types to it's own method?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + " passed " + Arrays.toString(args) + ")", e);
                }
                catch (ReflectiveOperationException e) {
                    throw new Error("LMP failed to access it's own method?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")", e);
                }
            };
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new Error("LMP failed to access it's own method?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")", e);
        }
    }

    public static <C, R> BiFunction<C, Object[], R> getInstanceApiMethod(Class<C> from, String methodName, Class<R> returnType, Class<?> ... argTypes) {
        return LmpReflection.getInstanceThrowingApiMethod(from, methodName, returnType, RuntimeException.class, argTypes)::call;
    }

    public static <C, R, T extends Throwable> ThrowingBiFunction<C, Object[], R, T> getInstanceThrowingApiMethod(Class<C> from, String methodName, Class<R> returnType, Class<T> exceptionType, Class<?> ... argTypes) {
        try {
            LmpReflection.checkPackage(from);
            Method method = from.getDeclaredMethod(methodName, argTypes);
            if (method.getAnnotation(LmpInternalOnly.class) == null) {
                throw new Error("Tried to access a non-internally exposed method! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")");
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new Error("LMP method is static when we expected it not to be! (" + String.valueOf(from) + " ." + String.valueOf(method) + ")");
            }
            if (exceptionType != null && Throwable.class == exceptionType) {
                throw new Error("Don't catch all throwables -_-");
            }
            for (Class<?> ex : method.getExceptionTypes()) {
                if (Error.class.isAssignableFrom(ex) || RuntimeException.class.isAssignableFrom(ex)) continue;
                if (exceptionType == null) {
                    throw new Error("Tried to access a method that throws " + String.valueOf(ex) + " without declaring a way to catch it!");
                }
                if (exceptionType.isAssignableFrom(ex)) continue;
                throw new Error("Tried to access a method that throws " + String.valueOf(ex) + " but we only catch " + String.valueOf(exceptionType));
            }
            method.setAccessible(true);
            return (instance, args) -> {
                try {
                    Object ret = method.invoke(instance, args);
                    if (ret == null) {
                        return null;
                    }
                    if (returnType.isInstance(ret)) {
                        return returnType.cast(ret);
                    }
                    throw new Error("The method returned value was not of the right class!");
                }
                catch (InvocationTargetException e) {
                    throw LmpReflection.rethrowException(exceptionType, e);
                }
                catch (IllegalArgumentException e) {
                    throw new Error("LMP passed the wrong types to it's own method?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + " passed " + Arrays.toString(args) + ")", e);
                }
                catch (ReflectiveOperationException e) {
                    throw new Error("LMP failed to access it's own method?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")", e);
                }
            };
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new Error("LMP failed to access it's own method?! (" + String.valueOf(from) + " of " + Arrays.toString(argTypes) + ")", e);
        }
    }

    private static <T extends Throwable> T rethrowException(Class<T> exceptionType, InvocationTargetException e) throws T {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)cause;
            throw re;
        }
        if (cause instanceof Error) {
            Error er = (Error)cause;
            throw er;
        }
        if (exceptionType == null) {
            throw new Error("No exception type was declared, but a checked exception was thrown!", cause);
        }
        if (exceptionType.isInstance(cause)) {
            throw (Throwable)exceptionType.cast(cause);
        }
        throw new Error("An exception type was declared, but a checked exception of a different type was thrown!", cause);
    }

    private static void checkPackage(Class<?> from) {
        if (from.isArray() || from.isPrimitive()) {
            throw new Error("These methods only work with LMP classes - not arrays or primitives");
        }
        if (!from.getPackageName().startsWith("alexiil.mc.lib.multipart.api")) {
            throw new Error("Tried to retieve something from outside of LMP's API! (" + String.valueOf(from) + ")");
        }
    }

    public static interface ThrowingFunction<I, O, T extends Throwable> {
        public O call(I var1) throws T;
    }

    public static interface ThrowingBiFunction<A, B, O, T extends Throwable> {
        public O call(A var1, B var2) throws T;
    }
}

