/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.PartLootParams;
import alexiil.mc.lib.multipart.api.SubdividedPart;
import alexiil.mc.lib.multipart.api.event.PartEventEntityCollide;
import alexiil.mc.lib.multipart.api.event.PartPrecipitationTickEvent;
import alexiil.mc.lib.multipart.api.event.PartRandomDisplayTickEvent;
import alexiil.mc.lib.multipart.api.event.PartRandomTickEvent;
import alexiil.mc.lib.multipart.api.event.PartScheduledTickEvent;
import alexiil.mc.lib.multipart.api.property.MultipartProperties;
import alexiil.mc.lib.multipart.impl.ItemDropCollector;
import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.impl.MultipartBlockEntity;
import alexiil.mc.lib.multipart.impl.PartHolder;
import alexiil.mc.lib.multipart.impl.TransientPartIdentifier;
import alexiil.mc.lib.multipart.impl.client.PartModelData;
import alexiil.mc.lib.multipart.mixin.api.IBlockCustomParticles;
import alexiil.mc.lib.multipart.mixin.api.IBlockDynamicCull;
import alexiil.mc.lib.multipart.mixin.api.IBlockMultipart;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_4990;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class MultipartBlock
extends class_2248
implements class_2343,
IBlockMultipart<TransientPartIdentifier>,
class_3737,
IBlockDynamicCull,
IBlockCustomParticles {
    public static final class_2758 LUMINANCE = class_2758.method_11867((String)"luminance", (int)0, (int)15);
    public static final class_2746 EMITS_REDSTONE = class_2746.method_11825((String)"emits_redstone");
    public static final class_2754<class_4990> TRANSFORMATION = class_2754.method_11850((String)"transformation", class_4990.class);

    public MultipartBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LUMINANCE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)EMITS_REDSTONE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).method_11657(TRANSFORMATION, (Comparable)class_4990.field_23292));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LUMINANCE, EMITS_REDSTONE, class_2741.field_12508, TRANSFORMATION});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MultipartBlockEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return type == LibMultiPart.BLOCK_ENTITY ? (w, p, s, be) -> ((MultipartBlockEntity)be).tick() : null;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(TRANSFORMATION, (Comparable)((class_4990)state.method_11654(TRANSFORMATION)).method_26385(rotation.method_26383()));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(TRANSFORMATION, (Comparable)((class_4990)state.method_11654(TRANSFORMATION)).method_26385(mirror.method_26380()));
    }

    public class_265 method_9549(class_2680 state, class_1922 view, class_2338 pos, class_3726 ctx) {
        RenderAttachedBlockView renderView;
        Object data;
        if (view instanceof RenderAttachedBlockView && (data = (renderView = (RenderAttachedBlockView)view).getBlockEntityRenderAttachment(pos)) instanceof PartModelData) {
            PartModelData partData = (PartModelData)data;
            return partData.collisionShape;
        }
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)class_25862;
            return container.container.getCollisionShape();
        }
        return class_259.method_1073();
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ctx) {
        RenderAttachedBlockView renderView;
        Object data;
        if (view instanceof RenderAttachedBlockView && (data = (renderView = (RenderAttachedBlockView)view).getBlockEntityRenderAttachment(pos)) instanceof PartModelData) {
            PartModelData partData = (PartModelData)data;
            return partData.outlineShape;
        }
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)class_25862;
            return container.container.getOutlineShape();
        }
        return class_259.method_1073();
    }

    public class_265 method_9571(class_2680 state, class_1922 view, class_2338 pos) {
        RenderAttachedBlockView renderView;
        Object data;
        if (view instanceof RenderAttachedBlockView && (data = (renderView = (RenderAttachedBlockView)view).getBlockEntityRenderAttachment(pos)) instanceof PartModelData) {
            PartModelData partData = (PartModelData)data;
            return partData.cullingShape;
        }
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)class_25862;
            return container.container.getCullingShape();
        }
        return super.method_9571(state, view, pos);
    }

    public class_265 method_25959(class_2680 state, class_1922 view, class_2338 pos) {
        RenderAttachedBlockView renderView;
        Object data;
        if (view instanceof RenderAttachedBlockView && (data = (renderView = (RenderAttachedBlockView)view).getBlockEntityRenderAttachment(pos)) instanceof PartModelData) {
            PartModelData partData = (PartModelData)data;
            return partData.sidesShape;
        }
        class_2586 class_25862 = view.method_8321(pos);
        if (class_25862 instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)class_25862;
            return container.container.getSidesShape();
        }
        return super.method_25959(state, view, pos);
    }

    @Override
    public boolean hasDynamicCull(class_2680 state) {
        return true;
    }

    public void method_9536(class_2680 oldState, class_1937 world, class_2338 pos, class_2680 newState, boolean bool) {
        class_2586 be;
        if (newState.method_26204() != this && (be = world.method_8321(pos)) instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.onRemoved();
        }
        super.method_9536(oldState, world, pos, newState, bool);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 thisPos, class_2248 otherBlock, class_2338 otherPos, boolean unknownBoolean) {
        super.method_9612(state, world, thisPos, otherBlock, otherPos, unknownBoolean);
        class_2586 be = world.method_8321(thisPos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.onNeighbourUpdate(otherPos);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.onNeighbourStateUpdate(direction, neighborPos, neighborState);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1269 handled = class_1269.field_5811;
        TransientPartIdentifier target = this.getMultipartTarget(state, (class_1922)world, pos, hit.method_17784());
        if (target != null) {
            handled = target.part.onUse(player, hit);
        }
        if (handled == class_1269.field_5811) {
            handled = super.method_55766(state, world, pos, player, hit);
        }
        return handled;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_9062 result = class_9062.field_47731;
        TransientPartIdentifier target = this.getMultipartTarget(state, (class_1922)world, pos, hit.method_17784());
        if (target != null) {
            result = target.part.onUseWithItem(stack, player, hand, hit);
        }
        if (result == class_9062.field_47731) {
            result = super.method_55765(stack, state, world, pos, player, hand, hit);
        }
        return result;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.container.fireEvent(new PartEventEntityCollide(entity));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_4538 view, class_2338 pos, class_2680 state) {
        TransientPartIdentifier target;
        class_310 mc = class_310.method_1551();
        class_239 hit = mc.field_1765;
        if (view != null && view == mc.field_1687 && hit != null && hit.method_17783() == class_239.class_240.field_1332 && (target = this.getMultipartTarget(state, (class_1922)view, pos, hit.method_17784())) != null) {
            return target.part.getPickStack((class_3965)hit);
        }
        return class_1799.field_8037;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.container.fireEvent(PartRandomTickEvent.INSTANCE);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.container.fireEvent(PartScheduledTickEvent.INSTANCE);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.container.fireEvent(PartRandomDisplayTickEvent.INSTANCE);
        }
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity container = (MultipartBlockEntity)be;
            container.container.fireEvent(new PartPrecipitationTickEvent(precipitation));
        }
    }

    public boolean method_9506(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)EMITS_REDSTONE);
    }

    public int method_9603(class_2680 state, class_1922 view, class_2338 pos, class_2350 oppositeFace) {
        class_2586 be = view.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity multiBE = (MultipartBlockEntity)be;
            return multiBE.container.getStrongRedstonePower(oppositeFace.method_10153());
        }
        return 0;
    }

    public int method_9524(class_2680 state, class_1922 view, class_2338 pos, class_2350 oppositeFace) {
        class_2586 be = view.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity multiBE = (MultipartBlockEntity)be;
            return multiBE.container.getWeakRedstonePower(oppositeFace.method_10153());
        }
        return 0;
    }

    public boolean method_10310(@Nullable class_1657 player, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        return MultipartBlock.testFluid(world, pos, fluid);
    }

    private static boolean testFluid(class_1922 world, class_2338 pos, class_3611 fluid) {
        if (fluid != class_3612.field_15910) {
            return false;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            return ((MultipartBlockEntity)be).container.properties.getValue(MultipartProperties.CAN_BE_WATERLOGGED);
        }
        return true;
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluid) {
        if (!MultipartBlock.testFluid((class_1922)world, pos, fluid.method_15772())) {
            return false;
        }
        return super.method_10311(world, pos, state, fluid);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean spawnBreakingParticles(class_1937 world, class_2338 pos, class_2680 state, class_2350 side, class_243 hitVec) {
        TransientPartIdentifier target = this.getMultipartTarget(state, (class_1922)world, pos, hitVec);
        if (target != null) {
            if (target.extra instanceof TransientPartIdentifier.IdSubPart) {
                if (MultipartBlock.spawnSubBreakingParticles(hitVec, side, (TransientPartIdentifier.IdSubPart)target.extra)) {
                    return true;
                }
            } else if (target.extra instanceof TransientPartIdentifier.IdAdditional) {
                for (AbstractPart extra : ((TransientPartIdentifier.IdAdditional)target.extra).additional) {
                    extra.spawnHitParticle(side);
                }
            }
            return target.part.spawnHitParticle(side);
        }
        return false;
    }

    private static <Sub> boolean spawnSubBreakingParticles(class_243 hitVec, class_2350 side, TransientPartIdentifier.IdSubPart<Sub> extra) {
        return extra.part.spawnBreakingParticles(hitVec, extra.subpart, side);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean spawnSprintingParticles(class_1937 world, class_2338 pos, class_2680 state, class_1297 sprintingEntity, class_5819 entityRandom) {
        TransientPartIdentifier colliding = this.getMultipartColliding(state, (class_1922)world, pos, sprintingEntity.method_5829(), 0.2);
        if (colliding != null) {
            return colliding.part.spawnSprintParticle(sprintingEntity, entityRandom);
        }
        return true;
    }

    @Override
    public boolean spawnFallParticles(class_3218 world, class_2338 pos, class_2680 state, class_1309 fallenEntity, class_5819 entityRandom) {
        TransientPartIdentifier colliding = this.getMultipartColliding(state, (class_1922)world, pos, fallenEntity.method_5829(), 0.2);
        if (colliding != null) {
            return colliding.part.onSpawnFallParticles(fallenEntity, entityRandom);
        }
        return true;
    }

    @Override
    public Class<TransientPartIdentifier> getKeyClass() {
        return TransientPartIdentifier.class;
    }

    @Override
    public void onBlockBreakStart(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, TransientPartIdentifier subpart) {
        this.method_9606(state, world, pos, player);
    }

    @Override
    public float calcBlockBreakingDelta(class_2680 state, class_1657 player, class_1922 view, class_2338 pos, TransientPartIdentifier subpart) {
        return subpart.part.calculateBreakingDelta(player);
    }

    @Override
    public void onBreak(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, TransientPartIdentifier subpart) {
        if (subpart.extra instanceof TransientPartIdentifier.IdSubPart) {
            if (MultipartBlock.onSubpartBreak(player, (TransientPartIdentifier.IdSubPart)subpart.extra)) {
                return;
            }
        } else if (subpart.extra instanceof TransientPartIdentifier.IdAdditional) {
            for (AbstractPart part : ((TransientPartIdentifier.IdAdditional)subpart.extra).additional) {
                part.onBreak(player);
            }
        }
        if (!subpart.part.onBreak(player)) {
            this.method_9576(world, pos, state, player);
        }
    }

    private static <Sub> boolean onSubpartBreak(class_1657 player, TransientPartIdentifier.IdSubPart<Sub> extra) {
        return extra.part.onSubpartBreak(player, extra.subpart);
    }

    @Override
    public boolean clearBlockState(class_1937 world, class_2338 pos, TransientPartIdentifier subpart) {
        if (subpart.extra instanceof TransientPartIdentifier.IdSubPart) {
            return MultipartBlock.clearSubPart((TransientPartIdentifier.IdSubPart)subpart.extra);
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity multi = (MultipartBlockEntity)be;
            return multi.container.removePart(subpart.part);
        }
        return world.method_8650(pos, false);
    }

    private static <Sub> boolean clearSubPart(TransientPartIdentifier.IdSubPart<Sub> extra) {
        return extra.part.clearSubpart(extra.subpart);
    }

    @Override
    public void onBroken(class_1936 world, class_2338 pos, class_2680 state, TransientPartIdentifier subpart) {
        this.method_9585(world, pos, state);
    }

    @Override
    public void afterBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 stack, TransientPartIdentifier subpart) {
        if (subpart.extra instanceof TransientPartIdentifier.IdSubPart) {
            MultipartBlock.afterSubpartBreak(player, stack, (TransientPartIdentifier.IdSubPart)subpart.extra);
        } else if (world instanceof class_3218) {
            class_3218 sv = (class_3218)world;
            class_8567.class_8568 ctxBuilder = new class_8567.class_8568(sv);
            ctxBuilder.method_51874(class_181.field_1224, (Object)state);
            ctxBuilder.method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos));
            ctxBuilder.method_51874(class_181.field_1229, (Object)stack);
            ctxBuilder.method_51877(class_181.field_1226, (Object)player);
            ctxBuilder.method_51877(class_181.field_1228, (Object)blockEntity);
            subpart.putLootContext(ctxBuilder);
            class_8567 context = ctxBuilder.method_51875(PartLootParams.PART_TYPE);
            subpart.part.afterBreak(player);
            subpart.part.addDrops(MultipartBlock.createDropTarget(subpart.part), context);
            for (AbstractPart part : ((TransientPartIdentifier.IdAdditional)subpart.extra).additional) {
                part.afterBreak(player);
                part.addDrops(MultipartBlock.createDropTarget(part), context);
            }
        } else {
            subpart.part.afterBreak(player);
            for (AbstractPart part : ((TransientPartIdentifier.IdAdditional)subpart.extra).additional) {
                part.afterBreak(player);
            }
        }
    }

    private static <Sub> void afterSubpartBreak(class_1657 player, class_1799 tool, TransientPartIdentifier.IdSubPart<Sub> extra) {
        extra.part.afterSubpartBreak(player, tool, extra.subpart);
    }

    static AbstractPart.ItemDropTarget createDropTarget(final AbstractPart part) {
        return new AbstractPart.ItemDropTarget(){
            final boolean canDrop;
            class_243 center;
            {
                this.canDrop = part.holder.getContainer().getMultipartWorld().method_8450().method_8355(class_1928.field_19392);
                this.center = null;
            }

            @Override
            public boolean dropsAsEntity() {
                return true;
            }

            @Override
            public void drop(class_1799 stack) {
                if (!this.canDrop) {
                    return;
                }
                if (this.center == null) {
                    this.center = part.getOutlineShape().method_1107().method_1005();
                    this.center = this.center.method_1019(class_243.method_24954((class_2382)part.holder.getContainer().getMultipartPos()));
                }
                this.drop(stack, this.center);
            }

            @Override
            public void drop(class_1799 stack, class_243 pos) {
                if (!this.canDrop) {
                    return;
                }
                class_1937 world = part.holder.getContainer().getMultipartWorld();
                while (!stack.method_7960()) {
                    class_1799 split = stack.method_7971(world.field_9229.method_43048(21) + 10);
                    class_1542 ent = new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, split);
                    ent.method_6988();
                    ent.method_18800(world.field_9229.method_43059() * 0.05, world.field_9229.method_43059() * 0.05 + 0.2, world.field_9229.method_43059() * 0.05);
                    world.method_8649((class_1297)ent);
                }
            }

            @Override
            public void drop(class_1799 stack, class_243 pos, class_243 velocity) {
                if (!this.canDrop) {
                    return;
                }
                class_1937 world = part.holder.getContainer().getMultipartWorld();
                class_1542 ent = new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, stack);
                ent.method_18799(velocity);
                ent.method_6988();
                world.method_8649((class_1297)ent);
            }
        };
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2371 drops = class_2371.method_10211();
        builder.method_51874(class_181.field_1224, (Object)state);
        class_2586 be = (class_2586)builder.method_51876(class_181.field_1228);
        class_8567 parameterSet = builder.method_51875(class_173.field_1172);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity mpbe = (MultipartBlockEntity)be;
            ItemDropCollector target = new ItemDropCollector((class_2371<class_1799>)drops);
            for (PartHolder holder : mpbe.container.parts) {
                holder.part.addDrops(target, parameterSet);
            }
        }
        return drops;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean playHitSound(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, TransientPartIdentifier subpart) {
        if (subpart.extra instanceof TransientPartIdentifier.IdSubPart) {
            MultipartBlock.playSubpartHitSound(player, (TransientPartIdentifier.IdSubPart)subpart.extra);
        } else {
            subpart.part.playHitSound(player);
        }
        return true;
    }

    private static <T> void playSubpartHitSound(class_1657 player, TransientPartIdentifier.IdSubPart<T> subpart) {
        subpart.part.playHitSound(player, subpart.subpart);
    }

    @Override
    @Deprecated
    public TransientPartIdentifier getTargetedMultipart(class_2680 state, class_1937 world, class_2338 pos, class_243 vec) {
        return this.getMultipartTarget(state, (class_1922)world, pos, vec);
    }

    @Override
    public TransientPartIdentifier getMultipartTarget(class_2680 state, class_1922 view, class_2338 pos, class_243 vec) {
        class_2586 be = view.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity multi = (MultipartBlockEntity)be;
            vec = vec.method_1020(class_243.method_24954((class_2382)pos));
            for (PartHolder holder : multi.container.parts) {
                TransientPartIdentifier id;
                AbstractPart part = holder.getPart();
                if (part instanceof SubdividedPart && (id = MultipartBlock.getTargetSubPart((SubdividedPart)((Object)part), vec)) != null) {
                    return id;
                }
                if (!MultipartBlock.doesContain(part, vec)) continue;
                return new TransientPartIdentifier(part);
            }
        }
        return null;
    }

    static boolean doesContain(AbstractPart part, class_243 vec) {
        class_265 shape = part.getOutlineShape();
        for (class_238 box : shape.method_1090()) {
            if (!box.method_1014(0.01).method_1006(vec)) continue;
            return true;
        }
        return false;
    }

    @javax.annotation.Nullable
    private static <Sub> TransientPartIdentifier getTargetSubPart(SubdividedPart<Sub> part, class_243 vec) {
        Sub subpart = part.getTargetedSubpart(vec);
        if (subpart != null) {
            return new TransientPartIdentifier(part, subpart);
        }
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public TransientPartIdentifier getMultipartColliding(class_2680 state, class_1922 view, class_2338 pos, class_238 toCollideWith, double clearance) {
        class_2586 be = view.method_8321(pos);
        if (be instanceof MultipartBlockEntity) {
            MultipartBlockEntity multi = (MultipartBlockEntity)be;
            toCollideWith = toCollideWith.method_997(class_243.method_24954((class_2382)pos).method_22882()).method_1014(clearance);
            for (PartHolder holder : multi.container.parts) {
                AbstractPart part = holder.getPart();
                if (!MultipartBlock.isCollidingWith(part, toCollideWith)) continue;
                return new TransientPartIdentifier(part);
            }
        }
        return null;
    }

    static boolean isCollidingWith(AbstractPart part, class_238 toCollideWith) {
        class_265 shape = part.getCollisionShape();
        for (class_238 box : shape.method_1090()) {
            if (!box.method_994(toCollideWith)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public class_265 getPartOutlineShape(class_2680 state, class_1937 world, class_2338 pos, class_243 hitVec) {
        return this.getPartOutline(state, (class_1922)world, pos, hitVec);
    }

    @Override
    public class_265 getPartOutline(class_2680 state, class_1922 world, class_2338 pos, class_243 hitVec) {
        class_265 sub;
        TransientPartIdentifier target = this.getMultipartTarget(state, world, pos, hitVec);
        if (target == null) {
            return class_259.method_1073();
        }
        float partialTicks = LibMultiPart.partialTickGetter.getAsFloat();
        if (target.extra instanceof TransientPartIdentifier.IdSubPart && (sub = MultipartBlock.getSubpartShape((TransientPartIdentifier.IdSubPart)target.extra, hitVec, partialTicks)) != null) {
            return sub;
        }
        return target.part.getDynamicShape(partialTicks, hitVec);
    }

    @javax.annotation.Nullable
    private static <S> class_265 getSubpartShape(TransientPartIdentifier.IdSubPart<S> sub, class_243 vec, float partialTicks) {
        return sub.part.getSubpartDynamicShape(vec, sub.subpart, partialTicks);
    }
}

