/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.AttributeProviderBlockEntity;
import alexiil.mc.lib.attributes.mixin.api.UnloadableBlockEntity;
import alexiil.mc.lib.multipart.api.event.NeighbourStateUpdateEvent;
import alexiil.mc.lib.multipart.api.event.NeighbourUpdateEvent;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.impl.MultipartBlock;
import alexiil.mc.lib.multipart.impl.PartContainer;
import alexiil.mc.lib.multipart.impl.PartHolder;
import alexiil.mc.lib.multipart.impl.client.PartModelData;
import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.impl.ActiveMinecraftConnection;
import alexiil.mc.lib.net.impl.BlockEntityInitialData;
import alexiil.mc.lib.net.impl.CoreMinecraftNetUtil;
import alexiil.mc.lib.net.impl.McNetworkStack;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4990;
import net.minecraft.class_7225;

public class MultipartBlockEntity
extends class_2586
implements UnloadableBlockEntity,
RenderAttachmentBlockEntity,
BlockEntityInitialData,
AttributeProviderBlockEntity {
    static final ParentNetIdSingle<MultipartBlockEntity> NET_KEY = McNetworkStack.BLOCK_ENTITY.subType(MultipartBlockEntity.class, "libmultipart:container");
    PartContainer container;

    public static void init() {
        PartContainer.init();
    }

    public MultipartBlockEntity(class_2338 pos, class_2680 state) {
        super(LibMultiPart.BLOCK_ENTITY, pos, state);
        this.container = new PartContainer(this, state.method_27852((class_2248)LibMultiPart.BLOCK) ? (class_4990)state.method_11654(MultipartBlock.TRANSFORMATION) : class_4990.field_23292);
    }

    MultipartBlockEntity(PartContainer from, class_2338 pos, class_2680 state) {
        super(LibMultiPart.BLOCK_ENTITY, pos, state);
        this.container = from;
        this.container.blockEntity = this;
    }

    public boolean method_61176(class_2680 state) {
        return true;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        if (nbt.method_10545("container")) {
            this.container.fromNbt(nbt.method_10562("container"), lookup);
        }
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10566("container", (class_2520)this.container.toNbt(lookup));
    }

    public void sendInitialData(class_3222 to) {
        PartContainer.NET_INITIAL_RENDER_DATA.send((ActiveConnection)CoreMinecraftNetUtil.getConnection((class_1657)to), (Object)this.container);
    }

    public void applyRotation(class_2470 rotation) {
        if (rotation != class_2470.field_11467) {
            this.container.rotate(rotation);
        }
    }

    public void applyMirror(class_2415 mirror) {
        if (mirror != class_2415.field_11302) {
            this.container.mirror(mirror);
        }
    }

    public void applyTransformation(class_4990 transformation) {
        if (transformation != class_4990.field_23292) {
            this.container.transform(transformation);
        }
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.container.setCachedState(state);
    }

    @Nonnull
    class_1937 world() {
        class_1937 w = this.field_11863;
        if (w != null) {
            return w;
        }
        throw new IllegalStateException("This doesn't have a world!");
    }

    public void method_10996() {
        super.method_10996();
        this.container.validate();
    }

    public void method_11012() {
        super.method_11012();
        this.container.invalidate();
    }

    public void onChunkUnload() {
        this.container.onChunkUnload();
    }

    public void onRemoved() {
        this.container.onRemoved();
    }

    public PartContainer getContainer() {
        return this.container;
    }

    public final boolean isServerWorld() {
        return this.field_11863 instanceof class_3218;
    }

    public final boolean isClientWorld() {
        return LibMultiPart.isWorldClientPredicate.test(this.field_11863);
    }

    public boolean canPlayerInteract(class_1657 player) {
        if (this.field_11863 == null || this.world().method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) < 64.0;
    }

    public static final ActiveMinecraftConnection getPlayerConnection(class_1657 player) {
        return CoreMinecraftNetUtil.getConnection((class_1657)player);
    }

    public final ActiveMinecraftConnection getClientConnection() {
        if (!this.world().field_9236) {
            throw new IllegalArgumentException("We can't send data from the server to itself!");
        }
        return CoreMinecraftNetUtil.getClientConnection();
    }

    public final Collection<class_3222> getPlayersWatching() {
        return BlockEntityInitialData.getPlayersWatching((class_2586)this);
    }

    final <T> void sendNetworkUpdate(@Nullable class_1657 except, T obj, NetIdTyped<T> netId) {
        if (this.isClientWorld()) {
            netId.send((ActiveConnection)this.getClientConnection(), obj);
        } else if (this.isServerWorld()) {
            for (class_1657 class_16572 : this.getPlayersWatching()) {
                ActiveMinecraftConnection connection;
                if (class_16572 == except || (connection = MultipartBlockEntity.getPlayerConnection(class_16572)) == null) continue;
                netId.send((ActiveConnection)connection, obj);
            }
        }
    }

    final <T> void sendNetworkUpdate(@Nullable class_1657 except, T obj, NetIdDataK<T> netId, NetIdDataK.IMsgDataWriterK<T> writer) {
        if (this.isClientWorld()) {
            netId.send((ActiveConnection)this.getClientConnection(), obj, writer);
        } else if (this.isServerWorld()) {
            for (class_1657 class_16572 : this.getPlayersWatching()) {
                ActiveMinecraftConnection connection;
                if (class_16572 == except || (connection = MultipartBlockEntity.getPlayerConnection(class_16572)) == null) continue;
                netId.send((ActiveConnection)connection, obj, writer);
            }
        }
    }

    public PartModelData getRenderAttachmentData() {
        ImmutableList built;
        ImmutableList.Builder list = ImmutableList.builder();
        for (PartHolder holder : this.container.parts) {
            PartModelKey key = holder.part.getModelKey();
            if (key == null) continue;
            list.add((Object)key);
        }
        this.container.partModelKeys = built = list.build();
        return new PartModelData(this.container.getCullingShape(), this.container.getCollisionShape(), this.container.getOutlineShape(), this.container.getSidesShape(), (ImmutableList<PartModelKey>)built);
    }

    public void tick() {
        this.container.tick();
    }

    public void addAllAttributes(AttributeList<?> list) {
        this.container.addAllAttributes(list);
    }

    public void onNeighbourUpdate(class_2338 otherPos) {
        this.container.fireEvent(new NeighbourUpdateEvent(otherPos));
    }

    public void onNeighbourStateUpdate(class_2350 direction, class_2338 neighborPos, class_2680 neighborState) {
        this.container.fireEvent(new NeighbourStateUpdateEvent(direction, neighborPos, neighborState));
    }
}

