/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.event.EventListener;
import alexiil.mc.lib.multipart.api.event.MultipartEvent;
import alexiil.mc.lib.multipart.api.event.PartListenerAdded;
import alexiil.mc.lib.multipart.api.event.PartListenerRemoved;
import alexiil.mc.lib.multipart.impl.PartContainer;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class SimpleEventBus
implements MultipartEventBus {
    private static final SingleListener<?>[] EMPTY_LISTENER_ARRAY = new SingleListener[0];
    private final PartContainer container;
    private final List<SingleListener<?>> listeners = new ArrayList();
    private SingleListener<?>[] packedListeners = EMPTY_LISTENER_ARRAY;
    private int eventCallLevel = 0;
    private boolean didListenersChange = false;
    private final List<SingleListener<?>> listenersChanged = new ArrayList();
    private final BooleanList listenerChangedToAdd = new BooleanArrayList();

    public SimpleEventBus(PartContainer container) {
        this.container = container;
    }

    @Override
    public MultipartContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fireEvent(MultipartEvent event) {
        boolean anyHandled = false;
        assert (this.eventCallLevel >= 0);
        try {
            ++this.eventCallLevel;
            for (SingleListener<?> listener : this.packedListeners) {
                anyHandled |= listener.onEvent(event);
            }
        }
        finally {
            --this.eventCallLevel;
        }
        assert (this.eventCallLevel >= 0) : "Event call level was negative? (" + this.eventCallLevel + ")";
        if (this.eventCallLevel > 0) {
            return anyHandled;
        }
        while (this.didListenersChange) {
            assert (this.eventCallLevel == 0) : "Event call level was non-zero? (" + this.eventCallLevel + ")";
            this.packedListeners = this.listeners.toArray(new SingleListener[0]);
            SingleListener[] changed = this.listenersChanged.toArray(new SingleListener[0]);
            boolean[] changedToAdd = this.listenerChangedToAdd.toBooleanArray();
            this.listenersChanged.clear();
            this.listenerChangedToAdd.clear();
            this.didListenersChange = false;
            for (int i = 0; i < changed.length; ++i) {
                SingleListener single = changed[i];
                if (changedToAdd[i]) {
                    this.fireListenerAddEvent(single);
                    continue;
                }
                this.fireListenerRemoveEvent(single);
            }
        }
        return anyHandled;
    }

    @Override
    public <E extends MultipartEvent> MultipartEventBus.ListenerInfo<E> addListener(Object key, Class<E> clazz, EventListener<E> listener) {
        SingleListener<E> single = new SingleListener<E>(key, clazz, listener);
        this.listeners.add(single);
        if (this.eventCallLevel > 0) {
            this.listenersChanged.add(single);
            this.listenerChangedToAdd.add(true);
            this.didListenersChange = true;
        } else {
            this.fireListenerAddEvent(single);
        }
        this.packedListeners = this.listeners.toArray(new SingleListener[0]);
        return single;
    }

    protected <E extends MultipartEvent> void fireListenerAddEvent(SingleListener<E> single) {
        this.container.onListenerAdded(single);
        this.fireEvent(new PartListenerAdded(single.key, single.clazz, single.listener));
    }

    protected <E extends MultipartEvent> void fireListenerRemoveEvent(SingleListener<E> single) {
        this.container.onListenerRemoved(single);
        this.fireEvent(new PartListenerRemoved(single.key, single.clazz, single.listener));
    }

    void clearListeners() {
        ListIterator<SingleListener<?>> iter = this.listeners.listIterator(this.listeners.size());
        boolean removedAny = false;
        while (iter.hasPrevious()) {
            SingleListener<?> single = iter.previous();
            iter.remove();
            removedAny = true;
            this.onRemoveListener(single);
        }
        if (removedAny) {
            this.packedListeners = this.listeners.toArray(new SingleListener[0]);
        }
    }

    @Override
    public void removeListeners(Object key) {
        ListIterator<SingleListener<?>> iter = this.listeners.listIterator(this.listeners.size());
        boolean removedAny = false;
        while (iter.hasPrevious()) {
            SingleListener<?> single = iter.previous();
            if (single.key != key) continue;
            iter.remove();
            removedAny = true;
            this.onRemoveListener(single);
        }
        if (removedAny) {
            this.packedListeners = this.listeners.toArray(new SingleListener[0]);
        }
    }

    private void onRemoveListener(SingleListener<?> single) {
        single.isPresent = false;
        if (this.eventCallLevel > 0) {
            this.listenersChanged.add(single);
            this.listenerChangedToAdd.add(false);
            this.didListenersChange = true;
        } else {
            this.fireListenerRemoveEvent(single);
        }
    }

    @Override
    public boolean hasAnyListeners() {
        return !this.listeners.isEmpty();
    }

    public List<MultipartEventBus.ListenerInfo<?>> getListenersForKey(Object key) {
        ArrayList list = new ArrayList();
        for (SingleListener<?> single : this.listeners) {
            if (single.key != key) continue;
            list.add(single);
        }
        return list;
    }

    @Override
    public boolean hasAnyListenersForKey(Object key) {
        for (SingleListener<?> single : this.listeners) {
            if (single.key != key) continue;
            return true;
        }
        return false;
    }

    public <E extends MultipartEvent> List<MultipartEventBus.ListenerInfo<? extends E>> getListeners(Class<E> clazz) {
        ArrayList list = new ArrayList();
        for (SingleListener<?> single : this.listeners) {
            if (!single.clazz.isAssignableFrom(clazz)) continue;
            list.add(single);
        }
        return list;
    }

    @Override
    public List<? extends MultipartEventBus.ListenerInfo<?>> getAllListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    class SingleListener<E extends MultipartEvent>
    implements MultipartEventBus.ListenerInfo<E> {
        final Object key;
        final Class<E> clazz;
        final EventListener<E> listener;
        boolean isPresent = true;

        public SingleListener(Object key, Class<E> clazz, EventListener<E> listener) {
            this.key = key;
            this.clazz = clazz;
            this.listener = listener;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Class<E> getListenerClass() {
            return this.clazz;
        }

        @Override
        public EventListener<E> getListener() {
            return this.listener;
        }

        @Override
        public void remove() {
            SimpleEventBus.this.listeners.remove(this);
            SimpleEventBus.this.onRemoveListener(this);
            SimpleEventBus.this.packedListeners = SimpleEventBus.this.listeners.toArray(new SingleListener[0]);
        }

        boolean onEvent(MultipartEvent event) {
            if (this.clazz.isInstance(event)) {
                this.listener.onEvent((MultipartEvent)this.clazz.cast(event));
                return true;
            }
            return false;
        }

        @Override
        public boolean isPresent() {
            return this.isPresent;
        }
    }
}

