/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.impl;

import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.property.MultipartProperty;
import alexiil.mc.lib.multipart.api.property.MultipartPropertyContainer;
import alexiil.mc.lib.multipart.api.property.PartPropertyChangedEvent;
import alexiil.mc.lib.multipart.impl.PartContainer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class SimplePropertyContainer
implements MultipartPropertyContainer {
    public final PartContainer container;
    private final Map<MultipartProperty<?>, InternalContainer<?>> properties = new IdentityHashMap();

    public SimplePropertyContainer(PartContainer container) {
        this.container = container;
    }

    @Override
    public MultipartContainer getContainer() {
        return this.container;
    }

    @Override
    public <T> T getValue(MultipartProperty<T> property) {
        InternalContainer<?> ic = this.properties.get(property);
        if (ic == null) {
            return property.defaultValue;
        }
        return property.clazz.cast(ic.combinedValue);
    }

    @Override
    public <T> void setValue(Object key, MultipartProperty<T> property, T value) {
        InternalContainer<Object> ic;
        if (value == null) {
            value = property.defaultValue;
        }
        if ((ic = this.properties.get(property)) == null) {
            if (Objects.equals(value, property.defaultValue)) {
                return;
            }
            ic = new InternalContainer<T>(property);
            this.properties.put(property, ic);
        }
        ic.setUnknownValue(key, value);
        if (value == null && ic.values.isEmpty()) {
            InternalContainer<?> removed = this.properties.remove(key);
            assert (removed == ic);
        }
    }

    @Override
    public <T> void clearValue(Object key, MultipartProperty<T> property) {
        this.setValue(key, property, property.defaultValue);
    }

    @Override
    public void clearValues(Object key) {
        Iterator<InternalContainer<?>> iter = this.properties.values().iterator();
        while (iter.hasNext()) {
            InternalContainer<?> ic = iter.next();
            ic.setValue(key, null);
            if (!ic.values.isEmpty()) continue;
            iter.remove();
        }
    }

    private class InternalContainer<T> {
        final MultipartProperty<T> property;
        final Map<Object, T> values = new IdentityHashMap<Object, T>();
        T combinedValue;

        InternalContainer(MultipartProperty<T> property) {
            this.property = property;
            this.combinedValue = property.defaultValue;
        }

        void setUnknownValue(Object key, Object value) {
            this.setValue(key, this.property.clazz.cast(value));
        }

        void setValue(Object key, T value) {
            T old;
            if (value == null) {
                value = this.property.defaultValue;
            }
            if ((old = Objects.equals(value, this.property.defaultValue) ? this.values.remove(key) : this.values.put(key, value)) == null) {
                old = this.property.defaultValue;
            }
            if (Objects.equals(old, value)) {
                return;
            }
            T oldCombined = this.combinedValue;
            ArrayList<T> list = new ArrayList<T>();
            list.addAll(this.values.values());
            this.combinedValue = list.isEmpty() ? this.property.defaultValue : (list.size() == 1 ? list.get(0) : this.property.combine(list));
            if (Objects.equals(oldCombined, this.combinedValue)) {
                return;
            }
            SimplePropertyContainer.this.container.onPropertyChanged(this.property, oldCombined, this.combinedValue);
            SimplePropertyContainer.this.container.fireEvent(new PartPropertyChangedEvent<T>(this.property, oldCombined, this.combinedValue));
        }
    }
}

