/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.mixin.impl;

import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.mixin.api.IBlockMultipart;
import alexiil.mc.lib.multipart.mixin.api.IClientPlayerInteractionManagerMixin;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public class ClientPlayerInteractionManagerMixin
implements IClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    class_310 field_3712;
    @Shadow
    class_2338 field_3714;
    @Shadow
    private float field_3713;
    @Shadow
    private float field_3715;
    @Unique
    Object partKey;

    @Override
    public class_2338 libmultipart_getCurrentBreakPosition() {
        return this.field_3714;
    }

    @Override
    public Object libmultipart_getPartKey() {
        return this.partKey;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;onBlockBreakStart(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;)V"), method={"method_41930"})
    void onBlockBreakStart(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        class_2248 block;
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] onBlockBreakStart( " + String.valueOf(pos) + " " + String.valueOf(state) + " )");
        }
        if ((block = state.method_26204()) instanceof IBlockMultipart) {
            IBlockMultipart blockMulti = (IBlockMultipart)block;
            this.onBlockBreakStart0(state, world, pos, player, blockMulti);
        } else {
            state.method_26179(world, pos, player);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;calcBlockBreakingDelta(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)F"), method={"method_41930"})
    float calcBlockBreakingDeltaAttack(class_2680 state, class_1657 pl, class_1922 view, class_2338 pos) {
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] calcBlockBreakingDelta( " + String.valueOf(pos) + " " + String.valueOf(state) + " )");
        }
        if (state.method_26204() instanceof IBlockMultipart) {
            IBlockMultipart block = (IBlockMultipart)state.method_26204();
            return this.calcBlockBreakingDelta0(block, state, pl, view, pos, false);
        }
        return state.method_26165(pl, view, pos);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;calcBlockBreakingDelta(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)F"), method={"updateBlockBreakingProgress(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;)Z"})
    float calcBlockBreakingDeltaUpdate(class_2680 state, class_1657 pl, class_1922 view, class_2338 pos) {
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] calcBlockBreakingDelta( " + String.valueOf(pos) + " " + String.valueOf(state) + " )");
        }
        if (state.method_26204() instanceof IBlockMultipart) {
            IBlockMultipart block = (IBlockMultipart)state.method_26204();
            return this.calcBlockBreakingDelta0(block, state, pl, view, pos, true);
        }
        return state.method_26165(pl, view, pos);
    }

    private <T> float calcBlockBreakingDelta0(IBlockMultipart<T> block, class_2680 state, class_1657 pl, class_1922 view, class_2338 pos, boolean playHitSound) {
        if (this.partKey == null) {
            return state.method_26165(pl, view, pos);
        }
        if (!block.getKeyClass().isInstance(this.partKey)) {
            if (LibMultiPart.DEBUG) {
                LibMultiPart.LOGGER.info("[player-interaction] calcBlockBreakingDelta0(): Wrong key " + String.valueOf(this.partKey.getClass()) + ", expected " + String.valueOf(block.getKeyClass()));
            }
            return state.method_26165(pl, view, pos);
        }
        T key = block.getKeyClass().cast(this.partKey);
        float delta = block.calcBlockBreakingDelta(state, pl, view, pos, key);
        if (playHitSound) {
            boolean reallyPlay;
            boolean bl = reallyPlay = this.field_3713 % 4.0f == 0.0f || this.field_3713 == 4.1f;
            if (reallyPlay && block.playHitSound(pl.method_37908(), pos, state, pl, key)) {
                this.field_3713 = 0.1f;
            }
        }
        return delta;
    }

    private <T> void onBlockBreakStart0(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, IBlockMultipart<T> blockMulti) {
        class_239 hit = class_310.method_1551().field_1765;
        T key = blockMulti.getTargetedMultipart(state, world, pos, hit.method_17784());
        this.partKey = key;
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] onBlockBreakStart0(): hit = " + String.valueOf(hit));
            LibMultiPart.LOGGER.info("[player-interaction] onBlockBreakStart0(): key = " + String.valueOf(key));
        }
        blockMulti.onBlockBreakStart(state, world, pos, player, key);
    }

    @Inject(method={"breakBlock(Lnet/minecraft/util/math/BlockPos;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/block/BlockState;")}, cancellable=true)
    void breakBlock(class_2338 pos, CallbackInfoReturnable<Boolean> ci) {
        IBlockMultipart blockMulti;
        Boolean ret;
        class_638 world = this.field_3712.field_1687;
        class_2680 state = world.method_8320(pos);
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] breakBlock( " + String.valueOf(pos) + " " + String.valueOf(state) + " )");
        }
        if (state.method_26204() instanceof IBlockMultipart && (ret = this.breakBlock0(pos, blockMulti = (IBlockMultipart)state.method_26204())) != null) {
            ci.setReturnValue((Object)ret);
            return;
        }
    }

    private <T> Boolean breakBlock0(class_2338 pos, IBlockMultipart<T> blockMulti) {
        class_239 hit = class_310.method_1551().field_1765;
        class_638 world = this.field_3712.field_1687;
        class_2680 state = world.method_8320(pos);
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] breakBlock0(): hit = " + String.valueOf(hit));
        }
        T target = blockMulti.getTargetedMultipart(state, (class_1937)world, pos, hit.method_17784());
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] breakBlock0(): target = " + String.valueOf(target));
        }
        T previous = this.partKey == null ? target : (blockMulti.getKeyClass().isInstance(this.partKey) ? blockMulti.getKeyClass().cast(this.partKey) : target);
        if (LibMultiPart.DEBUG) {
            LibMultiPart.LOGGER.info("[player-interaction] breakBlock0(): previous = " + String.valueOf(previous));
        }
        this.partKey = null;
        if (target == null || !Objects.equals(previous, target)) {
            if (LibMultiPart.DEBUG) {
                LibMultiPart.LOGGER.info("[player-interaction] breakBlock0(): Different subpart keys: previous = " + String.valueOf(previous) + ", current = " + String.valueOf(target));
            }
            this.field_3714 = new class_2338(this.field_3714.method_10263(), -1, this.field_3714.method_10260());
            return Boolean.FALSE;
        }
        blockMulti.onBreak((class_1937)world, pos, state, (class_1657)this.field_3712.field_1724, target);
        if (blockMulti.clearBlockState((class_1937)world, pos, target)) {
            blockMulti.onBroken((class_1936)world, pos, state, target);
            this.field_3714 = new class_2338(this.field_3714.method_10263(), -1, this.field_3714.method_10260());
            return Boolean.TRUE;
        }
        this.field_3714 = new class_2338(this.field_3714.method_10263(), -1, this.field_3714.method_10260());
        return Boolean.FALSE;
    }
}

