/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.mixin.impl;

import alexiil.mc.lib.multipart.impl.LibMultiPart;
import alexiil.mc.lib.multipart.mixin.api.IBlockMultipart;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    class_3218 field_14007;
    @Shadow
    class_3222 field_14008;
    @Shadow
    boolean field_14003;
    @Shadow
    boolean field_20328;
    @Unique
    Object multipartKey;
    @Unique
    class_243 sentHitVec;

    private void log(String text) {
        LibMultiPart.LOGGER.info("[player-interaction] '" + this.field_14008.method_7334().getName() + "' " + text);
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerPlayerInteractionManager;update()V"}, at={@At(value="RETURN")})
    void update(CallbackInfo ci) {
        if (!this.field_14003 && this.multipartKey != null) {
            if (LibMultiPart.DEBUG) {
                this.log("update(): Cleared multipartKey");
            }
            this.multipartKey = null;
        }
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerPlayerInteractionManager;processBlockBreakingAction(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/network/packet/c2s/play/PlayerActionC2SPacket$Action;Lnet/minecraft/util/math/Direction;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;onBlockBreakStart(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;)V"))
    void onBlockBreakStart(class_2680 state, class_1937 w, class_2338 pos, class_1657 pl) {
        if (LibMultiPart.DEBUG) {
            this.log("onBlockBreakStart( " + String.valueOf(pos) + " " + String.valueOf(state) + " )");
        }
        if (state.method_26204() instanceof IBlockMultipart) {
            IBlockMultipart block = (IBlockMultipart)state.method_26204();
            this.onBlockBreakStart0(state, w, pos, pl, block);
        } else {
            state.method_26179(w, pos, pl);
        }
    }

    private <T> void onBlockBreakStart0(class_2680 state, class_1937 w, class_2338 pos, class_1657 pl, IBlockMultipart<T> block) {
        class_243 vec = this.sentHitVec;
        if (vec == null) {
            if (LibMultiPart.DEBUG) {
                this.log("onBlockBreakStart0(): vec was null!");
            }
            class_265 shape = state.method_26218((class_1922)w, pos);
            class_3965 rayTrace = shape.method_1092(pl.method_5836(1.0f), pl.method_5836(1.0f).method_1019(pl.method_5828(1.0f).method_1021(10.0)), pos);
            if (LibMultiPart.DEBUG) {
                this.log("onBlockBreakStart(): rayTrace = " + String.valueOf(rayTrace));
            }
            if (rayTrace == null) {
                this.multipartKey = null;
                this.field_14003 = false;
                this.field_20328 = false;
                return;
            }
            vec = rayTrace.method_17784();
        }
        if (LibMultiPart.DEBUG) {
            this.log("onBlockBreakStart(): vec = " + String.valueOf(vec));
        }
        T bestKey = block.getTargetedMultipart(state, w, pos, vec);
        if (LibMultiPart.DEBUG) {
            this.log("onBlockBreakStart(): bestKey = " + String.valueOf(bestKey));
        }
        if (bestKey == null) {
            this.multipartKey = null;
        } else {
            this.multipartKey = bestKey;
            block.onBlockBreakStart(state, w, pos, pl, bestKey);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;calcBlockBreakingDelta(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)F"), method={"*"})
    float calcBlockBreakingDelta(class_2680 state, class_1657 pl, class_1922 view, class_2338 pos) {
        if (LibMultiPart.DEBUG) {
            this.log("calcBlockBreakingDelta( " + String.valueOf(pos) + " " + String.valueOf(state) + " )");
        }
        if (state.method_26204() instanceof IBlockMultipart) {
            IBlockMultipart block = (IBlockMultipart)state.method_26204();
            return this.calcBlockBreakingDelta0(block, state, pl, view, pos);
        }
        return state.method_26165(pl, view, pos);
    }

    private <T> float calcBlockBreakingDelta0(IBlockMultipart<T> block, class_2680 state, class_1657 pl, class_1922 view, class_2338 pos) {
        if (this.multipartKey == null) {
            this.onBlockBreakStart(state, (class_1937)this.field_14007, pos, (class_1657)this.field_14008);
        }
        if (this.multipartKey == null) {
            return state.method_26165(pl, view, pos);
        }
        if (!block.getKeyClass().isInstance(this.multipartKey)) {
            if (LibMultiPart.DEBUG) {
                this.log("calcBlockBreakingDelta0(): Wrong key " + String.valueOf(this.multipartKey.getClass()) + ", expected " + String.valueOf(block.getKeyClass()));
            }
            return state.method_26165(pl, view, pos);
        }
        T key = block.getKeyClass().cast(this.multipartKey);
        return block.calcBlockBreakingDelta(state, pl, view, pos, key);
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerPlayerInteractionManager;tryBreakBlock(Lnet/minecraft/util/math/BlockPos;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/block/BlockState;")}, cancellable=true)
    void destroyBlock(class_2338 pos, CallbackInfoReturnable<Boolean> ci) {
        class_2248 block;
        if (LibMultiPart.DEBUG) {
            this.log("destroyBlock( " + String.valueOf(pos) + " )");
        }
        class_2680 state = this.field_14007.method_8320(pos);
        if (LibMultiPart.DEBUG) {
            this.log("destroyBlock(): multipartKey = " + String.valueOf(this.multipartKey));
        }
        if (this.multipartKey == null) {
            this.onBlockBreakStart(state, (class_1937)this.field_14007, pos, (class_1657)this.field_14008);
        }
        if ((block = state.method_26204()) instanceof IBlockMultipart) {
            if (LibMultiPart.DEBUG) {
                this.log("destroyBlock(): multipartKey = " + String.valueOf(this.multipartKey));
            }
            boolean ret = this.destroyBlock0(pos, state, (IBlockMultipart)block);
            ci.setReturnValue((Object)ret);
        }
    }

    private <T> boolean destroyBlock0(class_2338 pos, class_2680 state, IBlockMultipart<T> block) {
        if (this.multipartKey == null) {
            return false;
        }
        if (!block.getKeyClass().isInstance(this.multipartKey)) {
            if (LibMultiPart.DEBUG) {
                this.log("destroyBlock0(): Wrong key " + String.valueOf(this.multipartKey.getClass()) + ", expected " + String.valueOf(block.getKeyClass()));
            }
            return false;
        }
        T key = block.getKeyClass().cast(this.multipartKey);
        class_2586 be = this.field_14007.method_8321(pos);
        block.onBreak((class_1937)this.field_14007, pos, state, (class_1657)this.field_14008, key);
        if (block.clearBlockState((class_1937)this.field_14007, pos, key)) {
            if (LibMultiPart.DEBUG) {
                this.log("destroyBlock0(): IBlockMultipart.clearBlockState() -> true");
            }
            block.onBroken((class_1936)this.field_14007, pos, state, key);
            if (!this.field_14008.method_7337()) {
                class_1799 stack = this.field_14008.method_6047();
                stack.method_7952((class_1937)this.field_14007, state, pos, (class_1657)this.field_14008);
                block.afterBreak((class_1937)this.field_14007, (class_1657)this.field_14008, pos, state, be, stack, key);
            }
            return true;
        }
        if (LibMultiPart.DEBUG) {
            this.log("destroyBlock0(): IBlockMultipart.clearBlockState() -> false");
        }
        return false;
    }
}

