/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.multipart.compat.waila;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartUtil;
import alexiil.mc.lib.multipart.impl.MultipartBlock;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class LibMultiPartPlugin
implements IWailaPlugin,
IBlockComponentProvider {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)this, TooltipPosition.HEAD, MultipartBlock.class);
        registrar.addComponent((IBlockComponentProvider)this, TooltipPosition.TAIL, MultipartBlock.class);
    }

    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        AbstractPart part = LibMultiPartPlugin.getSelectedPart(accessor);
        if (part == null) {
            return;
        }
        class_3965 hitResult = accessor.getBlockHitResult();
        String name = part.getName(hitResult).getString();
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.blockName((Object)name));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName((Object)part.definition.identifier));
        }
    }

    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        AbstractPart selectedPart;
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME) && (selectedPart = LibMultiPartPlugin.getSelectedPart(accessor)) != null) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName((Object)IModInfo.get((class_2960)selectedPart.definition.identifier).getName()));
        }
    }

    @Nullable
    private static AbstractPart getSelectedPart(IBlockAccessor accessor) {
        class_2338 pos = accessor.getPosition();
        MultipartContainer container = MultipartUtil.get((class_1937)accessor.getWorld(), (class_2338)pos);
        if (container == null) {
            return null;
        }
        class_3965 hitResult = accessor.getBlockHitResult();
        if (hitResult == null) {
            return null;
        }
        class_243 vec = hitResult.method_17784().method_1020(class_243.method_24954((class_2382)pos));
        return container.getFirstPart(part -> LibMultiPartPlugin.doesContain(part, vec));
    }

    private static boolean doesContain(AbstractPart part, class_243 vec) {
        class_265 shape = part.getOutlineShape();
        for (class_238 box : shape.method_1090()) {
            if (!box.method_1014(0.01).method_1006(vec)) continue;
            return true;
        }
        return false;
    }
}

