/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdBase;
import alexiil.mc.lib.net.ParentNetId;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;

public abstract class BufferedConnection
extends ActiveConnection {
    private static final int MIN_BANDWIDTH = 8000;
    public static final boolean ENABLE_QUEUE = true;
    final int defaultDropDelay;
    private int ourMaxBandwidth = 8000;
    private int theirMaxBandwidth = 8000;
    private int actualMaxBandwidth = 8000;
    private final Queue<BufferedPacketInfo> packetQueue = new ArrayDeque<BufferedPacketInfo>();
    private int queueLength = 0;

    public BufferedConnection(ParentNetId rootId, int defaultDropDelay) {
        super(rootId);
        this.defaultDropDelay = defaultDropDelay;
    }

    public void setMaxBandwidth(int to) {
        if (to < 8000) {
            to = 8000;
        }
        this.ourMaxBandwidth = to;
        NetByteBuf data = NetByteBuf.buffer(6);
        data.writeVarUnsignedInt(1);
        data.method_52998(to / 8000);
        this.sendRawData0(data);
        data.release();
    }

    @Override
    protected final void sendPacket(NetByteBuf data, int packetId, @Nullable NetIdBase netId, int priority) {
        int rb = data.readableBytes();
        if (this.queueLength + rb > this.maximumPacketSize()) {
            this.flushQueue();
        }
        if (rb > this.maximumPacketSize()) {
            this.sendRawData0(data);
        } else {
            this.packetQueue.add(new BufferedPacketInfo(data, priority));
            this.queueLength += rb;
            data.method_52938();
            if (netId != null && (netId.getFinalFlags() & 8) != 0) {
                this.flushQueue();
            }
        }
    }

    protected int maximumPacketSize() {
        return 65526;
    }

    public void tick() {
        this.sendTickPacket();
        this.flushQueue();
    }

    protected void sendTickPacket() {
    }

    @Override
    public void flushQueue() {
        if (!this.hasPackets()) {
            return;
        }
        if (this.packetQueue.size() == 1) {
            NetByteBuf data = this.packetQueue.remove().data;
            this.sendRawData0(data);
            data.release();
        } else {
            BufferedPacketInfo bpi;
            NetByteBuf combined = NetByteBuf.buffer(this.queueLength);
            while ((bpi = this.packetQueue.poll()) != null) {
                combined.method_52975((ByteBuf)bpi.data);
                bpi.data.release();
            }
            this.sendRawData0(combined);
            combined.release();
        }
        this.queueLength = 0;
    }

    protected final boolean hasPackets() {
        return !this.packetQueue.isEmpty();
    }

    @Override
    public void onReceiveRawData(NetByteBuf data) throws InvalidInputDataException {
        while (data.readableBytes() > 0) {
            InternalMsgUtil.onReceive(this, data);
        }
    }

    protected abstract void sendRawData0(NetByteBuf var1);

    void updateTheirMaxBandwidth(int theirs) {
        this.theirMaxBandwidth = Math.max(theirs *= 8000, 8000);
        this.actualMaxBandwidth = Math.min(this.theirMaxBandwidth, this.ourMaxBandwidth);
    }

    static class BufferedPacketInfo {
        final NetByteBuf data;
        final int priority;

        public BufferedPacketInfo(NetByteBuf data, int priority) {
            this.data = data;
            this.priority = priority;
        }
    }
}

