/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.InvalidInputDataException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.class_151;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class NetByteBuf
extends class_2540 {
    public static final NetByteBuf EMPTY_BUFFER = new NetByteBuf(Unpooled.EMPTY_BUFFER);
    public static final int MIN_VAR_S_INT_1_BYTE = -64;
    public static final int MAX_VAR_S_INT_1_BYTE = 63;
    public static final int MIN_VAR_S_INT_2_BYTES = -8192;
    public static final int MAX_VAR_S_INT_2_BYTES = 8191;
    public static final int MIN_VAR_S_INT_3_BYTES = -1048576;
    public static final int MAX_VAR_S_INT_3_BYTES = 1048575;
    public static final int MIN_VAR_S_INT_4_BYTES = -134217728;
    public static final int MAX_VAR_S_INT_4_BYTES = 0x7FFFFFF;
    public static final int MIN_VAR_U_INT_SMALL = 0;
    public static final int MAX_VAR_U_INT_1_BYTE = 128;
    public static final int MAX_VAR_U_INT_2_BYTES = 16384;
    public static final int MAX_VAR_U_INT_3_BYTES = 0x200000;
    public static final int MAX_VAR_U_INT_4_BYTES = 0x10000000;
    public final boolean passthrough;
    private int readPartialOffset = 8;
    private int readPartialCache;
    private int readPartialOffsetMark = 8;
    private int readPartialCacheMark;
    private int writePartialIndex = -1;
    private int writePartialOffset;
    private int writePartialCache;

    public static NetByteBuf buffer() {
        return NetByteBuf.asNetByteBuf(Unpooled.buffer());
    }

    public static NetByteBuf buffer(int initialCapacity) {
        return NetByteBuf.asNetByteBuf(Unpooled.buffer((int)initialCapacity));
    }

    public static NetByteBuf buffer(boolean passthrough) {
        return NetByteBuf.asNetByteBuf(Unpooled.buffer(), passthrough);
    }

    public static NetByteBuf buffer(int initialCapacity, boolean passthrough) {
        return NetByteBuf.asNetByteBuf(Unpooled.buffer((int)initialCapacity), passthrough);
    }

    public NetByteBuf(ByteBuf wrapped) {
        this(wrapped, false);
    }

    public NetByteBuf(ByteBuf wrapped, boolean passthrough) {
        super(wrapped);
        this.passthrough = passthrough;
    }

    public static NetByteBuf asNetByteBuf(ByteBuf buf) {
        return NetByteBuf.asNetByteBuf(buf, false);
    }

    public static NetByteBuf asPassthroughNetByteBuf(ByteBuf buf) {
        return NetByteBuf.asNetByteBuf(buf, true);
    }

    public static NetByteBuf asNetByteBuf(ByteBuf buf, boolean passthrough) {
        if (buf instanceof NetByteBuf) {
            NetByteBuf netBuf = (NetByteBuf)buf;
            if (netBuf.passthrough == passthrough) {
                return netBuf;
            }
        }
        return new NetByteBuf(buf, passthrough);
    }

    public int getBitWriterIndex() {
        return this.writePartialOffset;
    }

    public int getBitReaderIndex() {
        return this.readPartialOffset;
    }

    public NetByteBuf copy() {
        return NetByteBuf.asNetByteBuf(super.copy(), this.passthrough);
    }

    public NetByteBuf readBytes(int length) {
        return NetByteBuf.asNetByteBuf(super.readBytes(length), this.passthrough);
    }

    public NetByteBuf clear() {
        super.method_52931();
        this.readPartialOffset = 8;
        this.readPartialCache = 0;
        this.writePartialIndex = -1;
        this.writePartialOffset = 0;
        this.writePartialCache = 0;
        return this;
    }

    public NetByteBuf markReaderIndex() {
        super.method_52932();
        this.readPartialOffsetMark = this.readPartialOffset;
        this.readPartialCacheMark = this.readPartialCache;
        return this;
    }

    public NetByteBuf resetReaderIndex() {
        super.method_52933();
        this.readPartialOffset = this.readPartialOffsetMark;
        this.readPartialCache = this.readPartialCacheMark;
        return this;
    }

    public SavedReaderIndex saveReaderIndex() {
        return new SavedReaderIndex(this);
    }

    public NetByteBuf resetReaderIndex(SavedReaderIndex index) {
        this.method_52988(index.readerIndex);
        this.readPartialOffset = index.readPartialOffset;
        this.readPartialCache = index.readPartialCache;
        return this;
    }

    void writePartialBitsBegin() {
        if (this.writePartialIndex == -1 || this.writePartialOffset == 8) {
            this.writePartialIndex = this.writerIndex();
            this.writePartialOffset = 0;
            this.writePartialCache = 0;
            this.method_52997(0);
        }
    }

    void readPartialBitsBegin() {
        if (this.readPartialOffset == 8) {
            this.readPartialOffset = 0;
            this.readPartialCache = this.readUnsignedByte();
        }
    }

    public NetByteBuf writeBoolean(boolean flag) {
        if (this.passthrough) {
            super.method_52964(flag);
            return this;
        }
        this.writePartialBitsBegin();
        int toWrite = (flag ? 1 : 0) << this.writePartialOffset;
        this.writePartialCache |= toWrite;
        ++this.writePartialOffset;
        this.method_52966(this.writePartialIndex, this.writePartialCache);
        return this;
    }

    public boolean readBoolean() {
        if (this.passthrough) {
            return super.readBoolean();
        }
        this.readPartialBitsBegin();
        int offset = 1 << this.readPartialOffset++;
        return (this.readPartialCache & offset) == offset;
    }

    public NetByteBuf writeFixedBits(int value, int length) throws IllegalArgumentException {
        if (length <= 0) {
            throw new IllegalArgumentException("Tried to write too few bits! (" + length + ")");
        }
        if (length > 32) {
            throw new IllegalArgumentException("Tried to write more bits than are in an integer! (" + length + ")");
        }
        this.writePartialBitsBegin();
        if (this.writePartialOffset > 0) {
            int availableBits = 8 - this.writePartialOffset;
            if (availableBits >= length) {
                int mask = (1 << length) - 1;
                int bitsToWrite = value & mask;
                this.writePartialCache |= bitsToWrite << this.writePartialOffset;
                this.method_52966(this.writePartialIndex, this.writePartialCache);
                this.writePartialOffset += length;
                return this;
            }
            int mask = (1 << availableBits) - 1;
            int shift = length - availableBits;
            int bitsToWrite = value >>> shift & mask;
            this.writePartialCache |= bitsToWrite << this.writePartialOffset;
            this.method_52966(this.writePartialIndex, this.writePartialCache);
            this.writePartialCache = 0;
            this.writePartialOffset = 8;
            length -= availableBits;
        }
        while (length >= 8) {
            this.writePartialBitsBegin();
            int byteToWrite = value >>> length - 8 & 0xFF;
            this.method_52966(this.writePartialIndex, byteToWrite);
            this.writePartialCache = 0;
            this.writePartialOffset = 8;
            length -= 8;
        }
        if (length > 0) {
            this.writePartialBitsBegin();
            int mask = (1 << length) - 1;
            this.writePartialCache = value & mask;
            this.method_52966(this.writePartialIndex, this.writePartialCache);
            this.writePartialOffset = length;
        }
        return this;
    }

    public int readFixedBits(int length) throws IllegalArgumentException {
        if (length <= 0) {
            throw new IllegalArgumentException("Tried to read too few bits! (" + length + ")");
        }
        if (length > 32) {
            throw new IllegalArgumentException("Tried to read more bits than are in an integer! (" + length + ")");
        }
        this.readPartialBitsBegin();
        int value = 0;
        if (this.readPartialOffset > 0) {
            int bitsRead;
            int availableBits = 8 - this.readPartialOffset;
            if (availableBits >= length) {
                int mask = (1 << length) - 1;
                value = this.readPartialCache >>> this.readPartialOffset & mask;
                this.readPartialOffset += length;
                return value;
            }
            value = bitsRead = this.readPartialCache >>> this.readPartialOffset;
            this.readPartialCache = 0;
            this.readPartialOffset = 8;
            length -= availableBits;
        }
        while (length >= 8) {
            this.readPartialBitsBegin();
            length -= 8;
            value <<= 8;
            value |= this.readPartialCache;
            this.readPartialOffset = 8;
        }
        if (length > 0) {
            this.readPartialBitsBegin();
            int mask = (1 << length) - 1;
            value <<= length;
            value |= this.readPartialCache & mask;
            this.readPartialOffset = length;
        }
        return value;
    }

    public NetByteBuf writeEnumConstant(Enum<?> value) {
        if (this.passthrough) {
            super.method_10817(value);
            return this;
        }
        Enum[] possible = (Enum[])value.getDeclaringClass().getEnumConstants();
        if (possible == null) {
            throw new IllegalArgumentException("Not an enum " + String.valueOf(value.getClass()));
        }
        if (possible.length == 0) {
            throw new IllegalArgumentException("Tried to write an enum value without any values! How did you do this?");
        }
        if (possible.length == 1) {
            return this;
        }
        this.writeFixedBits(value.ordinal(), class_3532.method_15342((int)possible.length));
        return this;
    }

    public <E extends Enum<E>> E method_10818(Class<E> enumClass) {
        if (this.passthrough) {
            return (E)super.method_10818(enumClass);
        }
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException("Not an enum " + String.valueOf(enumClass));
        }
        if (enums.length == 0) {
            throw new IllegalArgumentException("Tried to read an enum value without any values! How did you do this?");
        }
        if (enums.length == 1) {
            return (E)enums[0];
        }
        int length = class_3532.method_15342((int)enums.length);
        int index = this.readFixedBits(length);
        return (E)enums[index];
    }

    public NetByteBuf writeBlockPos(class_2338 pos) {
        if (this.passthrough) {
            super.method_10807(pos);
            return this;
        }
        this.writeVarInt(pos.method_10263());
        this.writeVarInt(pos.method_10264());
        this.writeVarInt(pos.method_10260());
        return this;
    }

    public class_2338 method_10811() {
        if (this.passthrough) {
            return super.method_10811();
        }
        return new class_2338(this.method_10816(), this.method_10816(), this.method_10816());
    }

    public NetByteBuf writeVarInt(int ival) {
        int sign;
        if (this.passthrough) {
            super.method_10804(ival);
            return this;
        }
        if (ival < 0) {
            ival ^= 0xFFFFFFFF;
            sign = 1;
        } else {
            sign = 0;
        }
        while ((ival & 0xFFFFFFC0) != 0) {
            this.method_52997(0x80 | ival & 0x7F);
            ival >>>= 7;
        }
        this.method_52997(sign << 6 | ival);
        return this;
    }

    public int method_10816() {
        if (this.passthrough) {
            return super.method_10816();
        }
        int count = 0;
        int ival = 0;
        do {
            short read;
            if (((read = this.readUnsignedByte()) & 0x80) == 0) {
                ival |= (read & 0x3F) << count++ * 7;
                if ((read & 0x40) == 0) {
                    return ival;
                }
                return ~ival;
            }
            ival |= (read & 0x7F) << count++ * 7;
        } while (count < 5);
        return ival;
    }

    public NetByteBuf writeVarUnsignedInt(int ival) {
        super.method_10804(ival);
        return this;
    }

    public int readVarUnsignedInt() {
        return super.method_10816();
    }

    public NetByteBuf writeVarLong(long lval) {
        int sign;
        if (this.passthrough) {
            super.method_10791(lval);
            return this;
        }
        if (lval < 0L) {
            lval ^= 0xFFFFFFFFFFFFFFFFL;
            sign = 1;
        } else {
            sign = 0;
        }
        while ((lval & 0xFFFFFFFFFFFFFFC0L) != 0L) {
            this.method_52997((int)(0x80L | lval & 0x7FL));
            lval >>>= 7;
        }
        this.method_52997((int)((long)(sign << 6) | lval));
        return this;
    }

    public long method_10792() {
        if (this.passthrough) {
            return super.method_10792();
        }
        int count = 0;
        long lval = 0L;
        do {
            long read;
            if (((read = (long)this.readUnsignedByte()) & 0x80L) == 0L) {
                lval |= (read & 0x3FL) << count++ * 7;
                if ((read & 0x40L) == 0L) {
                    return lval;
                }
                return lval ^ 0xFFFFFFFFFFFFFFFFL;
            }
            lval |= (read & 0x7FL) << count++ * 7;
        } while (count < 10);
        return lval;
    }

    public NetByteBuf writeVarUnsignedLong(long lval) {
        super.method_10791(lval);
        return this;
    }

    public long readVarUnsignedLong() {
        return super.method_10792();
    }

    public NetByteBuf writeIdentifier(class_2960 id) {
        super.method_10812(id);
        return this;
    }

    @Deprecated
    public class_2960 method_10810() {
        return super.method_10810();
    }

    public class_2960 readIdentifierSafe() throws InvalidInputDataException {
        try {
            return super.method_10810();
        }
        catch (class_151 iee) {
            throw new InvalidInputDataException("Invalid Identifier", iee);
        }
    }

    @Nullable
    public class_2960 readIdentifierOrNull() {
        try {
            return super.method_10810();
        }
        catch (class_151 iee) {
            return null;
        }
    }

    public String method_19772() {
        return this.method_10800(Short.MAX_VALUE);
    }

    public boolean isRecordingMarkers() {
        return false;
    }

    public void writeMarker(String id) {
    }

    public void readMarker(String id) throws InvalidInputDataException {
    }

    public static final class SavedReaderIndex {
        public final int readerIndex;
        final int readPartialOffset;
        final int readPartialCache;

        SavedReaderIndex(NetByteBuf buffer) {
            this.readerIndex = buffer.readerIndex();
            this.readPartialOffset = buffer.readPartialOffset;
            this.readPartialCache = buffer.readPartialCache;
        }
    }
}

