/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.EnumNetSide;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.ParentNetIdBase;
import alexiil.mc.lib.net.TreeNetIdBase;
import alexiil.mc.lib.net.impl.ActiveMinecraftConnection;

public abstract class NetIdBase
extends TreeNetIdBase {
    static final int PACKET_SIZE_FLAG = 3;
    static final int FLAG_FIXED_SIZE = 0;
    static final int FLAG_TINY_PACKET = 1;
    static final int FLAG_NORMAL_PACKET = 2;
    static final int FLAG_LARGE_PACKET = 3;
    static final int FLAG_NOT_BUFFERED = 8;
    static final int FLAGS_SIDED = 48;
    static final int FLAG_SIDED_RECV_ON_CLIENT = 16;
    static final int FLAG_SIDED_RECV_ON_SERVER = 32;
    public static final int MAXIMUM_PRIORITY = 0;
    static final int FLAG_IS_PARENT = 4;
    public static final int DEFAULT_FLAGS = 2;
    private int flags = this.hasFixedLength() ? 0 : 2;
    private boolean flagsUsed = false;
    private int defaultPriority = 0;
    private int maximumDropDelay = 0;

    NetIdBase(ParentNetIdBase parent, String name, int length) {
        super(parent, name, length);
    }

    public final void setTinySize() {
        if (!this.hasFixedLength()) {
            this.changeFlag(this.flags & 0xFFFFFFFC | 1);
        }
    }

    public abstract NetIdBase withTinySize();

    public final void setNormalSize() {
        if (!this.hasFixedLength()) {
            this.changeFlag(this.flags & 0xFFFFFFFC | 2);
        }
    }

    public abstract NetIdBase withNormalSize();

    public final void setLargeSize() {
        if (!this.hasFixedLength()) {
            this.changeFlag(this.flags & 0xFFFFFFFC | 3);
        }
    }

    public abstract NetIdBase withLargeSize();

    public final void notBuffered() {
        this.flags |= 8;
    }

    public final void buffered() {
        this.flags &= 0xFFFFFFF7;
    }

    public final void setBuffered(boolean isBuffered) {
        if (isBuffered) {
            this.buffered();
        } else {
            this.notBuffered();
        }
    }

    public abstract NetIdBase withoutBuffering();

    protected final void _toClientOnly() {
        this.changeFlag(this.flags & 0xFFFFFFCF | 0x10);
    }

    protected final void _toServerOnly() {
        this.changeFlag(this.flags & 0xFFFFFFCF | 0x20);
    }

    protected final void _toEitherSide() {
        this.changeFlag(this.flags & 0xFFFFFFCF);
    }

    public abstract NetIdBase toClientOnly();

    public abstract NetIdBase toServerOnly();

    public abstract NetIdBase toEitherSide();

    public void setMaximumDropDelay(int dropDelay) {
        this.maximumDropDelay = Math.min(0, dropDelay);
    }

    protected final void changeFlag(int newFlags) {
        if (this.flagsUsed) {
            throw new IllegalStateException("You cannot modify the flags of this NetId as it has already been used!");
        }
        this.flags = newFlags;
    }

    @Override
    final int getFinalFlags() {
        this.flagsUsed = true;
        return this.flags;
    }

    int getDefaultPriority() {
        return this.defaultPriority;
    }

    int getMaximumDropDelay() {
        return this.maximumDropDelay;
    }

    final void validateSendingSide(IMsgWriteCtx ctx) {
        this.validateSendingSide(ctx.getConnection());
    }

    final void validateSendingSide(ActiveConnection connection) {
        int single = this.flags & 0x30;
        if (single == 0) {
            return;
        }
        if (!(connection instanceof ActiveMinecraftConnection)) {
            throw new IllegalStateException("You can only send " + String.valueOf(this) + " through a minecraft connection! (Was given " + String.valueOf(connection) + ")");
        }
        ActiveMinecraftConnection a = (ActiveMinecraftConnection)connection;
        if (single == 16) {
            if (a.getNetSide() == EnumNetSide.CLIENT) {
                throw new IllegalStateException("Cannot write " + String.valueOf(this) + " on the client!");
            }
        } else if (single == 32 && a.getNetSide() == EnumNetSide.SERVER) {
            throw new IllegalStateException("Cannot write " + String.valueOf(this) + " on the server!");
        }
    }

    abstract boolean receive(CheckingNetByteBuf var1, IMsgReadCtx var2) throws InvalidInputDataException;
}

