/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.MessageContext;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdSeparate;
import alexiil.mc.lib.net.ParentNetId;

public final class NetIdData
extends NetIdSeparate {
    private IMsgDataReceiver receiver = (buffer, ctx) -> {
        throw new InvalidInputDataException("No receiver set!");
    };
    private IMsgDataWriter writer;

    public NetIdData(ParentNetId parent, String name, int length) {
        super(parent, name, length);
    }

    public NetIdData setReceiver(IMsgDataReceiver receiver) {
        this.receiver = receiver;
        return this;
    }

    public NetIdData setReadWrite(IMsgDataReceiver receiver, IMsgDataWriter writer) {
        this.receiver = receiver;
        this.writer = writer;
        return this;
    }

    @Override
    boolean receive(CheckingNetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.receiver.receive(buffer, ctx);
        return true;
    }

    public void send(ActiveConnection connection) {
        this.send(connection, this.writer);
    }

    public void send(ActiveConnection connection, IMsgDataWriter writer) {
        MessageContext.Write ctx = new MessageContext.Write(connection, this);
        this.validateSendingSide(ctx);
        NetByteBuf buffer = this.hasFixedLength() ? connection.allocBuffer(this.totalLength) : connection.allocBuffer();
        CheckingNetByteBuf checkingBuffer = null;
        if (connection.sendTypes) {
            checkingBuffer = new CheckingNetByteBuf(buffer, NetByteBuf.buffer());
        }
        writer.write(checkingBuffer == null ? buffer : checkingBuffer, ctx);
        if (buffer.readableBytes() > 0) {
            if (checkingBuffer != null) {
                InternalMsgUtil.sendNextTypes(connection, checkingBuffer.typeBuffer, checkingBuffer.getCountWrite());
            }
            if (LibNetworkStack.CONFIG_RECORD_STACKTRACES && connection.sendStacktraces) {
                InternalMsgUtil.sendNextStacktrace(connection, new Throwable().fillInStackTrace());
            }
            InternalMsgUtil.send(connection, this, this.path, buffer);
        }
        buffer.release();
    }

    @Override
    public NetIdData withoutBuffering() {
        this.notBuffered();
        return this;
    }

    @Override
    public NetIdData withTinySize() {
        this.setTinySize();
        return this;
    }

    @Override
    public NetIdData withNormalSize() {
        this.setNormalSize();
        return this;
    }

    @Override
    public NetIdData withLargeSize() {
        this.setLargeSize();
        return this;
    }

    @Override
    public NetIdData toClientOnly() {
        this._toClientOnly();
        return this;
    }

    @Override
    public NetIdData toServerOnly() {
        this._toServerOnly();
        return this;
    }

    @Override
    public NetIdData toEitherSide() {
        this._toEitherSide();
        return this;
    }

    @FunctionalInterface
    public static interface IMsgDataReceiver {
        public void receive(NetByteBuf var1, IMsgReadCtx var2) throws InvalidInputDataException;
    }

    @FunctionalInterface
    public static interface IMsgDataWriter {
        public void write(NetByteBuf var1, IMsgWriteCtx var2);
    }
}

