/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdSeparate;
import alexiil.mc.lib.net.ParentNetId;

public final class NetIdSignal
extends NetIdSeparate {
    private IMsgSignalReceiver receiver;

    public NetIdSignal(ParentNetId parent, String name) {
        super(parent, name, 0);
    }

    public NetIdSignal setReceiver(IMsgSignalReceiver receiver) {
        this.receiver = receiver;
        return this;
    }

    public void send(ActiveConnection connection) {
        this.validateSendingSide(connection);
        if (LibNetworkStack.CONFIG_RECORD_STACKTRACES && connection.sendStacktraces) {
            InternalMsgUtil.sendNextStacktrace(connection, new Throwable().fillInStackTrace());
        }
        InternalMsgUtil.send(connection, this, this.path, NetByteBuf.EMPTY_BUFFER);
    }

    @Override
    boolean receive(CheckingNetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        if (this.receiver != null) {
            this.receiver.handle(ctx);
        }
        return true;
    }

    @Override
    public NetIdSignal withoutBuffering() {
        this.notBuffered();
        return this;
    }

    @Override
    public NetIdSignal withTinySize() {
        this.setTinySize();
        return this;
    }

    @Override
    public NetIdSignal withNormalSize() {
        this.setNormalSize();
        return this;
    }

    @Override
    public NetIdSignal withLargeSize() {
        this.setLargeSize();
        return this;
    }

    @Override
    public NetIdSignal toClientOnly() {
        this._toClientOnly();
        return this;
    }

    @Override
    public NetIdSignal toServerOnly() {
        this._toServerOnly();
        return this;
    }

    @Override
    public NetIdSignal toEitherSide() {
        this._toEitherSide();
        return this;
    }

    @FunctionalInterface
    public static interface IMsgSignalReceiver {
        public void handle(IMsgReadCtx var1) throws InvalidInputDataException;
    }
}

