/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.CheckingNetByteBuf;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.InternalMsgUtil;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.MessageContext;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.ArrayList;

public final class NetIdSignalK<T>
extends NetIdTyped<T> {
    private IMsgSignalReceiverK<T> receiver;

    public NetIdSignalK(ParentNetIdSingle<T> parent, String name) {
        super(parent, name, 0);
    }

    public NetIdSignalK<T> setReceiver(IMsgSignalReceiverK<T> receiver) {
        this.receiver = receiver;
        return this;
    }

    @Override
    protected void receive(NetByteBuf buffer, IMsgReadCtx ctx, T obj) throws InvalidInputDataException {
        if (this.receiver != null) {
            this.receiver.handle(obj, ctx);
        }
    }

    @Override
    public NetIdSignalK<T> withoutBuffering() {
        this.notBuffered();
        return this;
    }

    @Override
    public NetIdSignalK<T> withTinySize() {
        this.setTinySize();
        return this;
    }

    @Override
    public NetIdSignalK<T> withNormalSize() {
        this.setNormalSize();
        return this;
    }

    @Override
    public NetIdSignalK<T> withLargeSize() {
        this.setLargeSize();
        return this;
    }

    @Override
    public NetIdSignalK<T> toClientOnly() {
        this._toClientOnly();
        return this;
    }

    @Override
    public NetIdSignalK<T> toServerOnly() {
        this._toServerOnly();
        return this;
    }

    @Override
    public NetIdSignalK<T> toEitherSide() {
        this._toEitherSide();
        return this;
    }

    @Override
    public void send(ActiveConnection connection, T obj) {
        NetIdPath resolvedPath;
        MessageContext.Write ctx = new MessageContext.Write(connection, this);
        this.validateSendingSide(ctx);
        NetByteBuf buffer = this.hasFixedLength() ? NetByteBuf.buffer(this.totalLength) : NetByteBuf.buffer();
        NetByteBuf bufferTypes = connection.sendTypes ? NetByteBuf.buffer() : null;
        CheckingNetByteBuf checkingBuffer = new CheckingNetByteBuf(buffer, bufferTypes);
        if (this.parent.pathContainsDynamicParent) {
            ArrayList<TreeNetIdBase> nPath = new ArrayList<TreeNetIdBase>();
            this.parent.writeDynamicContext(checkingBuffer, ctx, obj, nPath);
            nPath.add(this);
            resolvedPath = new NetIdPath(nPath);
        } else {
            this.parent.writeContextCall(checkingBuffer, ctx, obj);
            resolvedPath = this.path;
        }
        if (checkingBuffer.hasTypeData()) {
            int thisId = InternalMsgUtil.getWriteId(connection, this, resolvedPath);
            checkingBuffer.writeMarkerId(thisId);
        }
        if (bufferTypes != null) {
            InternalMsgUtil.sendNextTypes(connection, bufferTypes, checkingBuffer.getCountWrite());
        }
        if (LibNetworkStack.CONFIG_RECORD_STACKTRACES && connection.sendStacktraces) {
            InternalMsgUtil.createAndSendDebugThrowable(connection, ctx);
        }
        InternalMsgUtil.send(connection, this, resolvedPath, buffer);
        buffer.release();
    }

    @FunctionalInterface
    public static interface IMsgSignalReceiverK<T> {
        public void handle(T var1, IMsgReadCtx var2) throws InvalidInputDataException;
    }
}

