/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.MsgUtil;
import alexiil.mc.lib.net.NetByteBuf;
import java.util.function.Function;

public abstract class NetKeyMapper<T> {
    public static final int LENGTH_DYNAMIC = -1;
    public final Class<T> clazz;
    public final int length;

    public NetKeyMapper(Class<T> clazz, int length) {
        this.clazz = clazz;
        this.length = length;
    }

    public NetKeyMapper(Class<T> clazz) {
        this(clazz, -1);
    }

    public abstract T read(NetByteBuf var1, IMsgReadCtx var2) throws InvalidInputDataException;

    public abstract void write(NetByteBuf var1, IMsgWriteCtx var2, T var3);

    public static class OfEnum<E extends Enum<E>>
    extends NetKeyMapper<E> {
        public OfEnum(Class<E> clazz) {
            super(clazz, 4);
        }

        @Override
        public E read(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
            return buffer.method_10818(this.clazz);
        }

        @Override
        public void write(NetByteBuf buffer, IMsgWriteCtx ctx, E value) {
            buffer.writeEnumConstant((Enum<?>)value);
        }
    }

    public static class ToString<T>
    extends NetKeyMapper<T> {
        private final Function<T, String> toStringMapper;
        private final Function<String, T> fromStringMapper;

        public ToString(Class<T> clazz, Function<T, String> toString, Function<String, T> fromString) {
            super(clazz);
            this.toStringMapper = toString;
            this.fromStringMapper = fromString;
        }

        @Override
        public T read(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
            String s = MsgUtil.readUTF(buffer);
            T read = this.fromStringMapper.apply(s);
            if (read == null) {
                throw new InvalidInputDataException("Cannot read the string value '" + String.valueOf(read) + "' as " + String.valueOf(this.clazz));
            }
            return read;
        }

        @Override
        public void write(NetByteBuf buffer, IMsgWriteCtx ctx, T value) {
            MsgUtil.writeUTF(buffer, this.toStringMapper.apply(value));
        }
    }
}

