/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetObjectCache;
import alexiil.mc.lib.net.NetObjectCacheBase;
import alexiil.mc.lib.net.impl.IdentityHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2960;

public class NetObjectCacheSimple<T>
extends NetObjectCacheBase<T> {
    public NetObjectCacheSimple(Hash.Strategy<T> equality, NetObjectCache.IEntrySerialiser<T> serialiser) {
        super(equality, serialiser);
    }

    public NetObjectCacheSimple(final Map<String, T> map, final Function<T, String> reverse) {
        super(IdentityHashStrategy.getInstance(), new NetObjectCache.IEntrySerialiser<T>(){

            @Override
            public void write(T obj, ActiveConnection connection, NetByteBuf buffer) {
                buffer.method_10814((String)reverse.apply(obj));
            }

            @Override
            public T read(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
                String str = buffer.method_19772();
                Object obj = map.get(str);
                if (obj == null) {
                    throw new InvalidInputDataException("Unknown object '" + str + "'");
                }
                return obj;
            }
        });
    }

    public static <T> NetObjectCacheSimple<T> createMappedIdentifier(final Map<class_2960, T> map, final Function<T, class_2960> reverse) {
        return new NetObjectCacheSimple(IdentityHashStrategy.getInstance(), new NetObjectCache.IEntrySerialiser<T>(){

            @Override
            public void write(T obj, ActiveConnection connection, NetByteBuf buffer) {
                buffer.writeIdentifier((class_2960)reverse.apply(obj));
            }

            @Override
            public T read(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
                class_2960 id = buffer.readIdentifierSafe();
                Object obj = map.get(id);
                if (obj == null) {
                    throw new InvalidInputDataException("Unknown object '" + String.valueOf(id) + "'");
                }
                return obj;
            }
        });
    }

    public static <T> NetObjectCacheSimple<T> createPartiallyMappedIdentifier(final Map<class_2960, T> map, final Function<T, class_2960> reverse) {
        return new NetObjectCacheSimple(IdentityHashStrategy.getInstance(), new NetObjectCache.IEntrySerialiser<T>(){

            @Override
            public void write(T obj, ActiveConnection connection, NetByteBuf buffer) {
                buffer.writeIdentifier((class_2960)reverse.apply(obj));
            }

            @Override
            public T read(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
                class_2960 id = buffer.readIdentifierSafe();
                Object obj = map.get(id);
                if (obj == null) {
                    throw new InvalidInputDataException("Unknown object '" + String.valueOf(id) + "'");
                }
                return obj;
            }
        });
    }

    public static NetObjectCacheSimple<class_2960> createIdentifierSet(final Set<class_2960> set) {
        return new NetObjectCacheSimple<class_2960>(IdentityHashStrategy.getInstance(), new NetObjectCache.IEntrySerialiser<class_2960>(){

            @Override
            public void write(class_2960 obj, ActiveConnection connection, NetByteBuf buffer) {
                buffer.writeIdentifier(obj);
            }

            @Override
            public class_2960 read(ActiveConnection connection, NetByteBuf buffer) throws InvalidInputDataException {
                class_2960 id = buffer.readIdentifierSafe();
                if (!set.contains(id)) {
                    throw new InvalidInputDataException("Unknown object '" + String.valueOf(id) + "'");
                }
                return id;
            }
        });
    }

    public void write(T obj, NetByteBuf buffer, IMsgWriteCtx ctx) {
        NetObjectCacheBase.Data cacheData = ctx.getConnection().getCacheData(this);
        int id = cacheData.objToId.getInt(obj);
        if (id == -1) {
            buffer.writeBoolean(true);
            int newId = cacheData.objToId.size();
            cacheData.objToId.put(obj, newId);
            buffer.writeVarUnsignedInt(newId);
            this.serialiser.write(obj, ctx.getConnection(), buffer);
        } else {
            buffer.writeBoolean(false);
            buffer.writeVarUnsignedInt(id);
        }
    }

    public T read(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        NetObjectCacheBase.Data cacheData = ctx.getConnection().getCacheData(this);
        boolean isNew = buffer.readBoolean();
        int id = buffer.readVarUnsignedInt();
        if (isNew) {
            Object obj = this.serialiser.read(ctx.getConnection(), buffer);
            cacheData.idToObj.put(id, obj);
            return obj;
        }
        Object obj = cacheData.idToObj.get(id);
        if (obj == null) {
            throw new InvalidInputDataException("Unknown ID " + id);
        }
        return (T)obj;
    }
}

