/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.NetIdData;
import alexiil.mc.lib.net.NetIdSeparate;
import alexiil.mc.lib.net.NetIdSignal;
import alexiil.mc.lib.net.ParentNetIdBase;
import alexiil.mc.lib.net.TreeNetIdBase;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ParentNetId
extends ParentNetIdBase {
    private final Map<String, NetIdSeparate> leafChildren = new HashMap<String, NetIdSeparate>();
    private final Map<String, ParentNetIdBase> branchChildren = new HashMap<String, ParentNetIdBase>();

    public ParentNetId(@Nullable ParentNetId parent, String name) {
        super(parent, name, 0);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    void addChild(NetIdSeparate netId) {
        if (this.leafChildren.containsKey(netId.name) || this.branchChildren.containsKey(netId.name)) {
            throw new IllegalStateException("There is already a child with the name " + netId.name + "!");
        }
        this.leafChildren.put(netId.name, netId);
    }

    void addChild(ParentNetIdBase netId) {
        if (this.leafChildren.containsKey(netId.name) || this.branchChildren.containsKey(netId.name)) {
            throw new IllegalStateException("There is already a child with the name " + netId.name + "!");
        }
        this.branchChildren.put(netId.name, netId);
    }

    @Override
    TreeNetIdBase getChild(String childName) {
        NetIdSeparate leaf = this.leafChildren.get(childName);
        return leaf != null ? leaf : (TreeNetIdBase)this.branchChildren.get(childName);
    }

    public NetIdData idData(String name) {
        return new NetIdData(this, name, -1);
    }

    public NetIdData idData(String name, int dataLength) {
        return new NetIdData(this, name, dataLength);
    }

    public NetIdSignal idSignal(String name) {
        return new NetIdSignal(this, name);
    }

    public ParentNetId child(String childName) {
        return new ParentNetId(this, childName);
    }
}

