/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net;

import alexiil.mc.lib.net.DynamicNetId;
import alexiil.mc.lib.net.NetIdBase;
import alexiil.mc.lib.net.NetIdPath;
import alexiil.mc.lib.net.ParentNetIdBase;

public abstract class TreeNetIdBase {
    public static final int DYNAMIC_LENGTH = -1;
    static final int PARENT_LENGTH = -2;
    static final int MAXIMUM_PACKET_LENGTH = 0x1000000;
    public final String name;
    public final String fullName;
    public final int length;
    public final int totalLength;
    public final ParentNetIdBase parent;
    final boolean pathContainsDynamicParent;
    final NetIdPath path;

    public TreeNetIdBase(ParentNetIdBase parent, String name, int thisLength) {
        this.parent = parent;
        this.name = name;
        this.fullName = parent == null ? name : parent.fullName + "." + name;
        this.length = thisLength;
        this.totalLength = thisLength == -1 ? -1 : (parent == null ? thisLength : (parent.totalLength == -1 ? -1 : thisLength + parent.totalLength));
        if (this.totalLength != -1) {
            if (this.totalLength > 0x1000000) {
                throw new IllegalArgumentException("The length (" + this.totalLength + ") exceeded the maximum packet length (16777216)");
            }
            if (this.totalLength < 0) {
                throw new IllegalArgumentException("The length (" + this.totalLength + ") has likely overflowed, exceeded the maximum packet length (16777216)");
            }
        }
        if (parent == null) {
            this.path = new NetIdPath(this);
            this.pathContainsDynamicParent = this instanceof DynamicNetId;
        } else {
            this.path = parent.path.withChild(this);
            this.pathContainsDynamicParent = parent.pathContainsDynamicParent || this instanceof DynamicNetId;
        }
    }

    public final String toString() {
        return this.getPrintableName() + " '" + this.fullName + "'";
    }

    protected String getPrintableName() {
        return this.getRealClassName();
    }

    protected final String getRealClassName() {
        Class<?> cls = this.getClass();
        while (cls.isAnonymousClass()) {
            cls = cls.getSuperclass();
        }
        return cls.getSimpleName();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean hasFixedLength() {
        return this.totalLength != -1;
    }

    final int getLengthForPacketAlloc() {
        return this instanceof NetIdBase ? this.totalLength : -2;
    }

    abstract int getFinalFlags();
}

