/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net.impl;

import alexiil.mc.lib.net.EnumNetSide;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.impl.ActiveMinecraftConnection;
import alexiil.mc.lib.net.impl.CompactDataPacketToServer;
import alexiil.mc.lib.net.impl.NormalPacketPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8710;

public class ActiveClientConnection
extends ActiveMinecraftConnection {
    private static final int DATAPOINT_SATURATION_COUNT = 30;
    public final class_634 netHandler;
    private long currentServerTick = Long.MIN_VALUE;
    private long prevServerTick;
    private long currentServerSendTime;
    private long prevServerSendTime;
    private long currentServerReceiveTime;
    private long prevServerReceiveTime;
    private double averageSendTimeDelta;
    private double averageReceiveTimeDelta;
    private int datapointCount;
    private long lastClientMs = Long.MIN_VALUE;
    private long smoothedServerTickValue = Long.MIN_VALUE;
    private double smoothedServerTickDelta = 0.0;

    public ActiveClientConnection(class_634 netHandler) {
        this.netHandler = netHandler;
    }

    @Override
    protected class_2596<?> toNormalPacket(NetByteBuf data) {
        byte[] bytes = new byte[data.readableBytes()];
        data.method_52979(bytes);
        return ClientPlayNetworking.createC2SPacket((class_8710)new NormalPacketPayload(bytes));
    }

    @Override
    protected class_2596<?> toCompactPacket(int receiverId, NetByteBuf data) {
        byte[] bytes = new byte[data.readableBytes()];
        data.method_52979(bytes);
        return new CompactDataPacketToServer(receiverId, bytes);
    }

    @Override
    protected void sendPacket(class_2596<?> packet) {
        this.netHandler.method_52787(packet);
    }

    @Override
    public EnumNetSide getNetSide() {
        return EnumNetSide.CLIENT;
    }

    @Override
    public class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    public String toString() {
        String hex = Integer.toHexString(System.identityHashCode(this));
        String prefix = class_310.method_1551().method_1562() == this.netHandler ? "The" : "Other";
        return "{" + prefix + " ActiveClientConnection@" + hex + "}";
    }

    void receiveServerTick(long tick, long sendTime) {
        if (this.lastClientMs == Long.MIN_VALUE) {
            this.lastClientMs = class_156.method_658();
        }
        this.prevServerTick = this.currentServerTick;
        this.prevServerSendTime = this.currentServerSendTime;
        this.prevServerReceiveTime = this.currentServerReceiveTime;
        this.currentServerTick = tick;
        this.currentServerSendTime = sendTime;
        this.currentServerReceiveTime = this.lastClientMs;
        if (this.datapointCount < 1) {
            this.datapointCount = 1;
            this.smoothedServerTickValue = tick;
            this.smoothedServerTickDelta = 0.0;
            return;
        }
        if (this.datapointCount == 1) {
            ++this.datapointCount;
            this.averageSendTimeDelta = this.currentServerSendTime - this.prevServerSendTime;
            this.averageReceiveTimeDelta = this.currentServerReceiveTime - this.prevServerReceiveTime;
            return;
        }
        if (this.datapointCount < 30) {
            ++this.datapointCount;
        }
        double divisor = 30.0;
        this.averageSendTimeDelta = (this.averageSendTimeDelta * (double)this.datapointCount + (double)this.currentServerSendTime - (double)this.prevServerSendTime) / divisor;
        this.averageReceiveTimeDelta = (this.averageReceiveTimeDelta * (double)this.datapointCount + (double)this.currentServerReceiveTime - (double)this.prevServerReceiveTime) / divisor;
    }

    public void onIncrementMinecraftTickCounter(long milliseconds) {
        if (this.datapointCount <= 0) {
            this.lastClientMs = milliseconds;
            return;
        }
        if (this.datapointCount == 1) {
            this.lastClientMs = milliseconds;
            return;
        }
        this.smoothedServerTickValue = this.currentServerTick;
        this.smoothedServerTickDelta = 0.0;
    }

    public long getAbsoluteServerTick() {
        return this.currentServerTick;
    }

    public long getSmoothedServerTickValue() {
        return this.smoothedServerTickValue;
    }

    public double getSmoothedServerTickDelta() {
        return this.smoothedServerTickDelta;
    }
}

