/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net.impl;

import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.impl.ActiveClientConnection;
import alexiil.mc.lib.net.impl.ActiveMinecraftConnection;
import alexiil.mc.lib.net.impl.ActiveServerConnection;
import alexiil.mc.lib.net.impl.CompactDataPacketToClient;
import alexiil.mc.lib.net.impl.CompactDataPacketToServer;
import alexiil.mc.lib.net.impl.NormalPacketPayload;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2602;
import net.minecraft.class_2792;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_9129;
import net.minecraft.class_9145;
import net.minecraft.class_9147;

public class CoreMinecraftNetUtil {
    private static final boolean DEBUG = LibNetworkStack.DEBUG;
    static int serverExpectedId;
    static int clientExpectedId;
    private static ActiveClientConnection currentClientConnection;
    private static final Map<class_3244, ActiveServerConnection> serverConnections;

    public static List<ActiveMinecraftConnection> getNearbyActiveConnections(class_2586 be, int distance) {
        ArrayList<ActiveMinecraftConnection> list = new ArrayList<ActiveMinecraftConnection>();
        class_1937 w = be.method_10997();
        if (w == null) {
            return list;
        }
        if (w.field_9236) {
            if (currentClientConnection == null) {
                return list;
            }
            double distanceSq = distance * distance;
            double x = (double)be.method_11016().method_10263() + 0.5;
            double y = (double)be.method_11016().method_10264() + 0.5;
            double z = (double)be.method_11016().method_10260() + 0.5;
            if (currentClientConnection.getPlayer().method_5649(x, y, z) < distanceSq) {
                list.add(currentClientConnection);
            }
        } else {
            Collection players = PlayerLookup.around((class_3218)((class_3218)w), (class_2382)be.method_11016(), (double)distance);
            for (class_3222 player : players) {
                ActiveServerConnection con = CoreMinecraftNetUtil.getServerConnection(player.field_13987);
                if (con == null) continue;
                list.add(con);
            }
        }
        return list;
    }

    public static List<ActiveMinecraftConnection> getPlayersWatching(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            throw new IllegalArgumentException("getPlayersWatching must be given a ServerWorld instance.");
        }
        Collection players = PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)pos);
        ArrayList<ActiveMinecraftConnection> list = new ArrayList<ActiveMinecraftConnection>();
        for (class_3222 player : players) {
            ActiveMinecraftConnection connection = CoreMinecraftNetUtil.getConnection((class_1657)player);
            if (connection == null) continue;
            list.add(connection);
        }
        return list;
    }

    public static ActiveMinecraftConnection getConnection(class_1657 player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (player instanceof class_3222) {
            return CoreMinecraftNetUtil.getServerConnection(((class_3222)player).field_13987);
        }
        if (player.method_37908().field_9236) {
            class_746 clientPlayer = class_310.method_1551().field_1724;
            if (clientPlayer == null) {
                throw new IllegalStateException("Cannot create a connection for " + String.valueOf(player) + " because they cannot be the client player (null)!");
            }
            if (currentClientConnection == null && player == clientPlayer) {
                return CoreMinecraftNetUtil.getOrCreateClientConnection(clientPlayer.field_3944);
            }
            if (currentClientConnection != null && currentClientConnection.getPlayer() == player) {
                return currentClientConnection;
            }
            throw new IllegalArgumentException("Unknown PlayerEntity " + String.valueOf(player.getClass()));
        }
        throw new IllegalArgumentException("Unknown PlayerEntity " + String.valueOf(player.getClass()));
    }

    public static void load() {
        if (LibNetworkStack.DEBUG) {
            LibNetworkStack.LOGGER.info("Loading CoreMinecraftNetUtil...");
        }
        PayloadTypeRegistry.playC2S().register(NormalPacketPayload.ID, NormalPacketPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(NormalPacketPayload.ID, NormalPacketPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(NormalPacketPayload.ID, (payload, context) -> {
            ActiveServerConnection connection = CoreMinecraftNetUtil.getServerConnection(context.player().field_13987);
            if (connection == null) {
                return;
            }
            NetByteBuf b = NetByteBuf.asNetByteBuf(Unpooled.wrappedBuffer((byte[])payload.payload()));
            try {
                connection.onReceiveRawData(b);
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
                context.responseSender().disconnect(class_2561.method_30163((String)("LibNetworkStack: read error (see server logs for more details)\n" + String.valueOf(e))));
            }
            finally {
                b.release();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> CoreMinecraftNetUtil.onServerTick());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> CoreMinecraftNetUtil.onServerStop());
    }

    public static void addToServerPackets(class_9147<class_2792, class_9129> builder) {
        if (LibNetworkStack.DEBUG) {
            LibNetworkStack.LOGGER.info("Adding CompactDataPacketToServer...");
        }
        builder.method_56454(CompactDataPacketToServer.TYPE, CompactDataPacketToServer.CODEC);
    }

    public static void addToClientPackets(class_9147<class_2602, class_9129> builder) {
        if (LibNetworkStack.DEBUG) {
            LibNetworkStack.LOGGER.info("Adding CompactDataPacketToClient...");
        }
        builder.method_56454(CompactDataPacketToClient.TYPE, CompactDataPacketToClient.CODEC);
    }

    public static void setExpectedIds(Object2IntMap<class_9145<?>> packetTypeIds) {
        if (packetTypeIds.containsKey(CompactDataPacketToClient.TYPE)) {
            if (LibNetworkStack.DEBUG) {
                LibNetworkStack.LOGGER.info("Extracting CompactDataPacketToClient id...");
            }
            clientExpectedId = packetTypeIds.getInt(CompactDataPacketToClient.TYPE);
        }
        if (packetTypeIds.containsKey(CompactDataPacketToServer.TYPE)) {
            if (LibNetworkStack.DEBUG) {
                LibNetworkStack.LOGGER.info("Extracting CompactDataPacketToServer id...");
            }
            serverExpectedId = packetTypeIds.getInt(CompactDataPacketToServer.TYPE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void loadClient() {
        ClientPlayNetworking.registerGlobalReceiver(NormalPacketPayload.ID, (payload, context) -> {
            ActiveClientConnection connection = CoreMinecraftNetUtil.getOrCreateClientConnection(context.player().field_3944);
            NetByteBuf b = NetByteBuf.asNetByteBuf(Unpooled.wrappedBuffer((byte[])payload.payload()));
            try {
                connection.onReceiveRawData(b);
                b.release();
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
                context.responseSender().disconnect(class_2561.method_30163((String)"LibNetworkStack: read error (see logs for details)"));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> CoreMinecraftNetUtil.onClientTick());
    }

    @Environment(value=EnvType.CLIENT)
    static void onClientReceivePacket(class_2602 listener, NetByteBuf buffer) {
        if (!(listener instanceof class_634)) {
            return;
        }
        class_634 ctx = (class_634)listener;
        ActiveClientConnection connection = CoreMinecraftNetUtil.getOrCreateClientConnection(ctx);
        NetByteBuf b = buffer.copy();
        class_310.method_1551().execute(() -> {
            try {
                connection.onReceiveRawData(b);
                b.release();
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
                ctx.method_48296().method_10747(class_2561.method_30163((String)"LibNetworkStack: read error (see logs for details)"));
            }
        });
    }

    public static ActiveClientConnection getClientConnection() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            throw new IllegalStateException("The client is not currently connected to any server!");
        }
        return CoreMinecraftNetUtil.getOrCreateClientConnection(player.field_3944);
    }

    @Nullable
    public static ActiveClientConnection getCurrentClientConnection() {
        return currentClientConnection;
    }

    private static ActiveClientConnection getOrCreateClientConnection(class_634 ctx) {
        ActiveClientConnection connection = currentClientConnection;
        if (connection == null || connection.netHandler != ctx) {
            connection = new ActiveClientConnection(ctx);
            connection.postConstruct();
            currentClientConnection = connection;
        }
        return connection;
    }

    static void onServerReceivePacket(class_2792 listener, NetByteBuf buffer) {
        if (!(listener instanceof class_3244)) {
            return;
        }
        class_3244 ctx = (class_3244)listener;
        ActiveServerConnection connection = CoreMinecraftNetUtil.getServerConnection(ctx);
        if (connection == null) {
            return;
        }
        NetByteBuf b = buffer.copy();
        ctx.field_14140.field_13995.execute(() -> {
            try {
                connection.onReceiveRawData(b);
                b.release();
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
                ctx.method_52396(class_2561.method_30163((String)("LibNetworkStack: read error (see server logs for more details)\n" + String.valueOf(e))));
            }
        });
    }

    private static ActiveServerConnection getServerConnection(class_3244 netHandler) {
        return serverConnections.computeIfAbsent(netHandler, c -> {
            if (!netHandler.method_48106()) {
                LibNetworkStack.LOGGER.warn("Disallowed server connection for " + String.valueOf(netHandler.field_14140) + " because it's channel is not open!");
                return null;
            }
            if (DEBUG) {
                LibNetworkStack.LOGGER.info("Creating new server connection for " + String.valueOf(netHandler.field_14140));
            }
            ActiveServerConnection connection = new ActiveServerConnection(netHandler);
            connection.postConstruct();
            return connection;
        });
    }

    private static void onClientTick() {
        if (currentClientConnection != null) {
            if (!CoreMinecraftNetUtil.currentClientConnection.netHandler.method_48296().method_10758()) {
                if (DEBUG) {
                    LibNetworkStack.LOGGER.info("Removed current client connection " + String.valueOf(currentClientConnection) + " as it's channel is no longer open.");
                }
                currentClientConnection = null;
                return;
            }
            currentClientConnection.tick();
        }
    }

    private static void onServerTick() {
        Iterator<ActiveServerConnection> iterator = serverConnections.values().iterator();
        while (iterator.hasNext()) {
            ActiveServerConnection connection = iterator.next();
            if (!connection.netHandler.method_48106()) {
                iterator.remove();
                if (!DEBUG) continue;
                LibNetworkStack.LOGGER.info("Removed server connection " + String.valueOf(connection) + " as it's channel is no longer open.");
                continue;
            }
            connection.tick();
        }
    }

    private static void onServerStop() {
        int count = serverConnections.size();
        serverConnections.clear();
        if (DEBUG) {
            LibNetworkStack.LOGGER.info("Removed " + count + " server connections as the server has stopped.");
        }
    }

    static {
        serverConnections = new HashMap<class_3244, ActiveServerConnection>();
    }
}

