/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.client.model;

import alexiil.mc.mod.pipes.client.model.MutableQuad;
import alexiil.mc.mod.pipes.util.SpriteUtil;
import alexiil.mc.mod.pipes.util.VecUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class ModelUtil {
    private static final double FACE_INSET = 0.001;

    public static class_1087 getModel(class_2960 modelLocation) {
        return class_310.method_1551().method_1554().getModel(modelLocation);
    }

    public static class_1087 getMissingModel() {
        return class_310.method_1551().method_1554().method_4744();
    }

    public static class_1087 getItemModel(class_1799 stack) {
        return class_310.method_1551().method_1480().method_4012().method_3308(stack);
    }

    public static class_1087 getBlockModel(class_2680 state) {
        return class_310.method_1551().method_1554().method_4743().method_3335(state);
    }

    public static List<class_777> getQuads(class_2680 state, int seed) {
        return ModelUtil.getQuads(ModelUtil.getBlockModel(state), state, seed);
    }

    public static List<class_777> getQuads(class_1087 model, class_2680 state, int seed) {
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<class_777> quads = new ArrayList<class_777>();
        quads.addAll(model.method_4707(state, null, class_5819.method_43049((long)seed)));
        for (class_2350 dir : class_2350.values()) {
            quads.addAll(model.method_4707(state, dir, class_5819.method_43049((long)seed)));
        }
        return quads;
    }

    public static MutableQuad createFace(class_2350 face, class_243 a, class_243 b, class_243 c, class_243 d, UvFaceData uvs) {
        MutableQuad quad = new MutableQuad(-1, face);
        if (uvs == null) {
            uvs = UvFaceData.DEFAULT;
        }
        if (face == null || ModelUtil.shouldInvertForRender(face)) {
            quad.vertex_0.positionv(a).texf(uvs.minU, uvs.minV);
            quad.vertex_1.positionv(b).texf(uvs.minU, uvs.maxV);
            quad.vertex_2.positionv(c).texf(uvs.maxU, uvs.maxV);
            quad.vertex_3.positionv(d).texf(uvs.maxU, uvs.minV);
        } else {
            quad.vertex_3.positionv(a).texf(uvs.minU, uvs.minV);
            quad.vertex_2.positionv(b).texf(uvs.minU, uvs.maxV);
            quad.vertex_1.positionv(c).texf(uvs.maxU, uvs.maxV);
            quad.vertex_0.positionv(d).texf(uvs.maxU, uvs.minV);
        }
        return quad;
    }

    public static <T extends class_243> MutableQuad createFace(class_2350 face, T[] points, UvFaceData uvs) {
        return ModelUtil.createFace(face, points[0], points[1], points[2], points[3], uvs);
    }

    public static MutableQuad createFace(class_2350 face, class_243 center, class_243 radius, UvFaceData uvs) {
        class_243[] points = ModelUtil.getPointsForFace(face, center, radius);
        return ModelUtil.createFace((class_2350)face, (class_243[])points, (UvFaceData)uvs).normalf(face.method_10148(), face.method_10164(), face.method_10165());
    }

    public static MutableQuad createInverseFace(class_2350 face, class_243 center, class_243 radius, UvFaceData uvs) {
        return ModelUtil.createFace(face, center, radius, uvs).copyAndInvertNormal();
    }

    public static MutableQuad[] createDoubleFace(class_2350 face, class_243 center, class_243 radius, UvFaceData uvs) {
        MutableQuad norm = ModelUtil.createFace(face, center, radius, uvs);
        return new MutableQuad[]{norm, norm.copyAndInvertNormal()};
    }

    public static List<MutableQuad> createModel(class_265 shape, class_1058 sprite, int insetSides) {
        ArrayList<MutableQuad> list = new ArrayList<MutableQuad>();
        UvFaceData uvs = new UvFaceData();
        for (class_238 box : shape.method_1090()) {
            class_243 center = box.method_1005();
            class_243 radius = new class_243(box.field_1320 - box.field_1323, box.field_1325 - box.field_1322, box.field_1324 - box.field_1321).method_1021(0.5);
            for (class_2350 dir : class_2350.values()) {
                double dirRadius = dir.method_10166().method_10172(radius.field_1352, radius.field_1351, radius.field_1350);
                double dirCenter = dir.method_10166().method_10172(center.field_1352, center.field_1351, center.field_1350);
                double faceOffset = dirCenter + dirRadius * (double)dir.method_10171().method_10181();
                class_243 insetRadius = (1 << dir.method_10146() & insetSides) != 0 && (class_3532.method_20390((double)faceOffset, (double)0.0) || class_3532.method_20390((double)faceOffset, (double)1.0)) ? VecUtil.replaceValue(radius, dir.method_10166(), dirRadius - 0.001) : radius;
                ModelUtil.mapBoxToUvs(box, dir, uvs);
                uvs.inSprite(sprite);
                list.add(ModelUtil.createFace(dir, center, insetRadius, uvs));
            }
        }
        return list;
    }

    public static void mapBoxToUvs(class_238 box, class_2350 side, UvFaceData uvs) {
        switch (side) {
            case field_11039: {
                uvs.minU = (float)box.field_1321;
                uvs.maxU = (float)box.field_1324;
                uvs.minV = 1.0f - (float)box.field_1325;
                uvs.maxV = 1.0f - (float)box.field_1322;
                break;
            }
            case field_11034: {
                uvs.minU = 1.0f - (float)box.field_1321;
                uvs.maxU = 1.0f - (float)box.field_1324;
                uvs.minV = 1.0f - (float)box.field_1325;
                uvs.maxV = 1.0f - (float)box.field_1322;
                break;
            }
            case field_11033: {
                uvs.minU = (float)box.field_1323;
                uvs.maxU = (float)box.field_1320;
                uvs.minV = 1.0f - (float)box.field_1324;
                uvs.maxV = 1.0f - (float)box.field_1321;
                break;
            }
            case field_11036: {
                uvs.minU = (float)box.field_1323;
                uvs.maxU = (float)box.field_1320;
                uvs.minV = (float)box.field_1324;
                uvs.maxV = (float)box.field_1321;
                break;
            }
            case field_11043: {
                uvs.minU = 1.0f - (float)box.field_1323;
                uvs.maxU = 1.0f - (float)box.field_1320;
                uvs.minV = 1.0f - (float)box.field_1325;
                uvs.maxV = 1.0f - (float)box.field_1322;
                break;
            }
            case field_11035: {
                uvs.minU = (float)box.field_1323;
                uvs.maxU = (float)box.field_1320;
                uvs.minV = 1.0f - (float)box.field_1325;
                uvs.maxV = 1.0f - (float)box.field_1322;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Direction " + String.valueOf(side));
            }
        }
    }

    public static class_243[] getPointsForFace(class_2350 face, class_243 center, class_243 radius) {
        class_243 faceAdd = new class_243((double)face.method_10148() * radius.field_1352, (double)face.method_10164() * radius.field_1351, (double)face.method_10165() * radius.field_1350);
        class_243 centerOfFace = center.method_1019(faceAdd);
        class_243 faceRadius = face.method_10171() == class_2350.class_2352.field_11056 ? radius.method_1020(faceAdd) : radius.method_1019(faceAdd);
        return ModelUtil.getPoints(centerOfFace, faceRadius);
    }

    public static class_243[] getPoints(class_243 centerFace, class_243 faceRadius) {
        return new class_243[]{centerFace.method_1019(ModelUtil.addOrNegate(faceRadius, false, false)), centerFace.method_1019(ModelUtil.addOrNegate(faceRadius, false, true)), centerFace.method_1019(ModelUtil.addOrNegate(faceRadius, true, true)), centerFace.method_1019(ModelUtil.addOrNegate(faceRadius, true, false))};
    }

    public static class_243 addOrNegate(class_243 coord, boolean u, boolean v) {
        boolean zisv = coord.field_1352 != 0.0 && coord.field_1351 == 0.0;
        double x = coord.field_1352 * (double)(u ? 1 : -1);
        double y = coord.field_1351 * (double)(v ? -1 : 1);
        double z = coord.field_1350 * (double)(zisv ? (v ? -1 : 1) : (u ? 1 : -1));
        return new class_243(x, y, z);
    }

    public static boolean shouldInvertForRender(class_2350 face) {
        boolean flip;
        boolean bl = flip = face.method_10171() == class_2350.class_2352.field_11060;
        return face.method_10166() == class_2350.class_2351.field_11051 ? !flip : flip;
    }

    public static class_2350 faceForRender(class_2350 face) {
        return ModelUtil.shouldInvertForRender(face) ? face.method_10153() : face;
    }

    public static class UvFaceData {
        private static final UvFaceData DEFAULT = new UvFaceData(0.0f, 0.0f, 1.0f, 1.0f);
        public float minU;
        public float maxU;
        public float minV;
        public float maxV;

        public UvFaceData() {
        }

        public UvFaceData(UvFaceData from) {
            this.minU = from.minU;
            this.maxU = from.maxU;
            this.minV = from.minV;
            this.maxV = from.maxV;
        }

        public static UvFaceData from16(double minU, double minV, double maxU, double maxV) {
            return new UvFaceData(minU / 16.0, minV / 16.0, maxU / 16.0, maxV / 16.0);
        }

        public static UvFaceData from16(int minU, int minV, int maxU, int maxV) {
            return new UvFaceData((float)minU / 16.0f, (float)minV / 16.0f, (float)maxU / 16.0f, (float)maxV / 16.0f);
        }

        public UvFaceData(float uMin, float vMin, float uMax, float vMax) {
            this.minU = uMin;
            this.maxU = uMax;
            this.minV = vMin;
            this.maxV = vMax;
        }

        public UvFaceData(double minU, double minV, double maxU, double maxV) {
            this((float)minU, (float)minV, (float)maxU, (float)maxV);
        }

        public UvFaceData andSub(UvFaceData sub) {
            float size_u = this.maxU - this.minU;
            float size_v = this.maxV - this.minV;
            float min_u = this.minU + sub.minU * size_u;
            float min_v = this.minV + sub.minV * size_v;
            float max_u = this.minU + sub.maxU * size_u;
            float max_v = this.minV + sub.maxV * size_v;
            return new UvFaceData(min_u, min_v, max_u, max_v);
        }

        public UvFaceData inParent(UvFaceData parent) {
            return parent.andSub(this);
        }

        public String toString() {
            return "[ " + this.minU * 16.0f + ", " + this.minV * 16.0f + ", " + this.maxU * 16.0f + ", " + this.maxV * 16.0f + " ]";
        }

        public void inSprite(class_1058 sprite) {
            this.minU = SpriteUtil.getU(sprite, this.minU);
            this.maxU = SpriteUtil.getU(sprite, this.maxU);
            this.minV = SpriteUtil.getV(sprite, this.minV);
            this.maxV = SpriteUtil.getV(sprite, this.maxV);
        }
    }

    public static class TexturedFace {
        public class_1058 sprite;
        public UvFaceData faceData = new UvFaceData();
    }
}

