/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.client.model;

import alexiil.mc.mod.pipes.client.model.MutableVertex;
import alexiil.mc.mod.pipes.mixin.impl.BakedQuadAccessor;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_777;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MutableQuad {
    public static final MutableQuad[] EMPTY_ARRAY = new MutableQuad[0];
    public final MutableVertex vertex_0 = new MutableVertex();
    public final MutableVertex vertex_1 = new MutableVertex();
    public final MutableVertex vertex_2 = new MutableVertex();
    public final MutableVertex vertex_3 = new MutableVertex();
    private int colourIndex = -1;
    private class_2350 face = null;
    private class_1058 sprite = null;

    public MutableQuad() {
    }

    public MutableQuad(int tintIndex, class_2350 face) {
        this.colourIndex = tintIndex;
        this.face = face;
    }

    public MutableQuad(MutableQuad from) {
        this.copyFrom(from);
    }

    public MutableQuad copyFrom(MutableQuad from) {
        this.colourIndex = from.colourIndex;
        this.face = from.face;
        this.sprite = from.sprite;
        this.vertex_0.copyFrom(from.vertex_0);
        this.vertex_1.copyFrom(from.vertex_1);
        this.vertex_2.copyFrom(from.vertex_2);
        this.vertex_3.copyFrom(from.vertex_3);
        return this;
    }

    public MutableQuad setTint(int tint) {
        this.colourIndex = tint;
        return this;
    }

    public int getColourIndex() {
        return this.colourIndex;
    }

    public MutableQuad setFace(class_2350 face) {
        this.face = face;
        return this;
    }

    public class_2350 getFace() {
        return this.face;
    }

    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }

    public class_1058 getSprite() {
        return this.sprite;
    }

    public class_777 toBakedBlock() {
        int[] data = new int[32];
        this.vertex_0.toBakedBlock(data, 0);
        this.vertex_1.toBakedBlock(data, 8);
        this.vertex_2.toBakedBlock(data, 16);
        this.vertex_3.toBakedBlock(data, 24);
        return new class_777(data, this.colourIndex, this.face, this.sprite, false);
    }

    public class_777 toBakedItem() {
        int[] data = new int[]{};
        this.vertex_0.toBakedItem(data, 0);
        this.vertex_1.toBakedItem(data, 7);
        this.vertex_2.toBakedItem(data, 14);
        this.vertex_3.toBakedItem(data, 21);
        return new class_777(data, this.colourIndex, this.face, this.sprite, false);
    }

    public MutableQuad fromBakedBlock(class_777 quad) {
        this.colourIndex = quad.method_3359();
        this.face = quad.method_3358();
        this.sprite = ((BakedQuadAccessor)quad).simplepipes_getSprite();
        int[] data = quad.method_3357();
        int stride = data.length / 4;
        this.vertex_0.fromBakedBlock(data, 0);
        this.vertex_1.fromBakedBlock(data, stride);
        this.vertex_2.fromBakedBlock(data, stride * 2);
        this.vertex_3.fromBakedBlock(data, stride * 3);
        return this;
    }

    public MutableQuad fromBakedItem(class_777 quad) {
        this.colourIndex = quad.method_3359();
        this.face = quad.method_3358();
        this.sprite = ((BakedQuadAccessor)quad).simplepipes_getSprite();
        int[] data = quad.method_3357();
        int stride = data.length / 4;
        this.vertex_0.fromBakedItem(data, 0);
        this.vertex_1.fromBakedItem(data, stride);
        this.vertex_2.fromBakedItem(data, stride * 2);
        this.vertex_3.fromBakedItem(data, stride * 3);
        return this;
    }

    public MutableQuad fromBakedFormat(class_777 quad, class_293 format) {
        this.colourIndex = quad.method_3359();
        this.face = quad.method_3358();
        this.sprite = ((BakedQuadAccessor)quad).simplepipes_getSprite();
        int[] data = quad.method_3357();
        int stride = data.length / 4;
        this.vertex_0.fromBakedFormat(data, format, 0);
        this.vertex_1.fromBakedFormat(data, format, stride);
        this.vertex_2.fromBakedFormat(data, format, stride * 2);
        this.vertex_3.fromBakedFormat(data, format, stride * 3);
        return this;
    }

    public void render(class_287 bb) {
        this.vertex_0.render(bb);
        this.vertex_1.render(bb);
        this.vertex_2.render(bb);
        this.vertex_3.render(bb);
    }

    public void putData(QuadEmitter emitter) {
        this.vertex_0.putData(0, emitter);
        this.vertex_1.putData(1, emitter);
        this.vertex_2.putData(2, emitter);
        this.vertex_3.putData(3, emitter);
    }

    public Vector3f getCalculatedNormal() {
        Vector3f a = this.vertex_1.positionvf();
        a.sub((Vector3fc)this.vertex_0.positionvf());
        Vector3f b = this.vertex_2.positionvf();
        b.sub((Vector3fc)this.vertex_0.positionvf());
        a.cross((Vector3fc)b);
        return a;
    }

    public void setCalculatedNormal() {
        this.normalvf(this.getCalculatedNormal());
    }

    public static float diffuseLight(Vector3f normal) {
        return MutableQuad.diffuseLight(normal.x, normal.y, normal.z);
    }

    public static float diffuseLight(float x, float y, float z) {
        boolean up = y >= 0.0f;
        float xx = x * x;
        float yy = y * y;
        float zz = z * z;
        float t = xx + yy + zz;
        float light = (xx * 0.6f + zz * 0.8f) / t;
        float yyt = yy / t;
        if (!up) {
            yyt = (float)((double)yyt * 0.5);
        }
        return light += yyt;
    }

    public float getCalculatedDiffuse() {
        return MutableQuad.diffuseLight(this.getCalculatedNormal());
    }

    public void setDiffuse(Vector3f normal) {
        float diffuse = MutableQuad.diffuseLight(normal);
        this.colourf(diffuse, diffuse, diffuse, 1.0f);
    }

    public void setCalculatedDiffuse() {
        float diffuse = this.getCalculatedDiffuse();
        this.colourf(diffuse, diffuse, diffuse, 1.0f);
    }

    public MutableQuad copyAndInvertNormal() {
        MutableQuad copy = new MutableQuad(this);
        copy.vertex_0.copyFrom(this.vertex_3).invertNormal();
        copy.vertex_1.copyFrom(this.vertex_2).invertNormal();
        copy.vertex_2.copyFrom(this.vertex_1).invertNormal();
        copy.vertex_3.copyFrom(this.vertex_0).invertNormal();
        return copy;
    }

    public MutableQuad rotateTextureUp(int times) {
        switch (times & 3) {
            case 0: {
                return this;
            }
            case 1: {
                class_241 t = this.vertex_0.tex();
                this.vertex_0.texv(this.vertex_1.tex());
                this.vertex_1.texv(this.vertex_2.tex());
                this.vertex_2.texv(this.vertex_3.tex());
                this.vertex_3.texv(t);
                return this;
            }
            case 2: {
                class_241 t0 = this.vertex_0.tex();
                class_241 t1 = this.vertex_1.tex();
                this.vertex_0.texv(this.vertex_2.tex());
                this.vertex_1.texv(this.vertex_3.tex());
                this.vertex_2.texv(t0);
                this.vertex_3.texv(t1);
                return this;
            }
            case 3: {
                class_241 t = this.vertex_3.tex();
                this.vertex_3.texv(this.vertex_2.tex());
                this.vertex_2.texv(this.vertex_1.tex());
                this.vertex_1.texv(this.vertex_0.tex());
                this.vertex_0.texv(t);
                return this;
            }
        }
        throw new IllegalStateException("'times & 3' was not 0, 1, 2 or 3!");
    }

    public MutableQuad normalf(float x, float y, float z) {
        this.vertex_0.normalf(x, y, z);
        this.vertex_1.normalf(x, y, z);
        this.vertex_2.normalf(x, y, z);
        this.vertex_3.normalf(x, y, z);
        return this;
    }

    public MutableQuad normald(double x, double y, double z) {
        return this.normalf((float)x, (float)y, (float)z);
    }

    public MutableQuad normalvf(Vector3f vec) {
        return this.normalf(vec.x, vec.y, vec.z);
    }

    public MutableQuad normalvd(class_243 vec) {
        return this.normald(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public Vector3f normalvf() {
        return new Vector3f(this.vertex_0.normal_x, this.vertex_0.normal_y, this.vertex_0.normal_z);
    }

    public class_243 normalvd() {
        return new class_243((double)this.vertex_0.normal_x, (double)this.vertex_0.normal_y, (double)this.vertex_0.normal_z);
    }

    public MutableQuad colouri(int r, int g, int b, int a) {
        this.vertex_0.colouri(r, g, b, a);
        this.vertex_1.colouri(r, g, b, a);
        this.vertex_2.colouri(r, g, b, a);
        this.vertex_3.colouri(r, g, b, a);
        return this;
    }

    public MutableQuad colouri(int rgba) {
        this.vertex_0.colouri(rgba);
        this.vertex_1.colouri(rgba);
        this.vertex_2.colouri(rgba);
        this.vertex_3.colouri(rgba);
        return this;
    }

    public MutableQuad colourf(float r, float g, float b, float a) {
        this.vertex_0.colourf(r, g, b, a);
        this.vertex_1.colourf(r, g, b, a);
        this.vertex_2.colourf(r, g, b, a);
        this.vertex_3.colourf(r, g, b, a);
        return this;
    }

    public MutableQuad multColourd(double r, double g, double b, double a) {
        this.vertex_0.multColourd(r, g, b, a);
        this.vertex_1.multColourd(r, g, b, a);
        this.vertex_2.multColourd(r, g, b, a);
        this.vertex_3.multColourd(r, g, b, a);
        return this;
    }

    public MutableQuad multColourd(double by) {
        int m = (int)(by * 255.0);
        return this.multColouri(m);
    }

    public MutableQuad multColouri(int by) {
        this.vertex_0.multColouri(by);
        this.vertex_1.multColouri(by);
        this.vertex_2.multColouri(by);
        this.vertex_3.multColouri(by);
        return this;
    }

    public MutableQuad multColouri(int r, int g, int b, int a) {
        this.vertex_0.multColouri(r &= 0xFF, g &= 0xFF, b &= 0xFF, a &= 0xFF);
        this.vertex_1.multColouri(r, g, b, a);
        this.vertex_2.multColouri(r, g, b, a);
        this.vertex_3.multColouri(r, g, b, a);
        return this;
    }

    public MutableQuad multShade() {
        this.vertex_0.multShade();
        this.vertex_1.multShade();
        this.vertex_2.multShade();
        this.vertex_3.multShade();
        return this;
    }

    public MutableQuad texFromSprite(class_1058 sprite) {
        this.vertex_0.texFromSprite(sprite);
        this.vertex_1.texFromSprite(sprite);
        this.vertex_2.texFromSprite(sprite);
        this.vertex_3.texFromSprite(sprite);
        return this;
    }

    public MutableQuad lighti(int block, int sky) {
        this.vertex_0.lighti(block, sky);
        this.vertex_1.lighti(block, sky);
        this.vertex_2.lighti(block, sky);
        this.vertex_3.lighti(block, sky);
        return this;
    }

    public MutableQuad lighti(int combined) {
        this.vertex_0.lighti(combined);
        this.vertex_1.lighti(combined);
        this.vertex_2.lighti(combined);
        this.vertex_3.lighti(combined);
        return this;
    }

    public MutableQuad lightf(float block, float sky) {
        return this.lighti((int)(block * 15.0f), (int)(sky * 15.0f));
    }

    public MutableQuad lightvf(class_241 vec) {
        return this.lightf(vec.field_1343, vec.field_1342);
    }

    public MutableQuad maxLighti(int block, int sky) {
        this.vertex_0.maxLighti(block, sky);
        this.vertex_1.maxLighti(block, sky);
        this.vertex_2.maxLighti(block, sky);
        this.vertex_3.maxLighti(block, sky);
        return this;
    }

    public MutableQuad translatei(int x, int y, int z) {
        return this.translatef(x, y, z);
    }

    public MutableQuad translatef(float x, float y, float z) {
        this.vertex_0.translatef(x, y, z);
        this.vertex_1.translatef(x, y, z);
        this.vertex_2.translatef(x, y, z);
        this.vertex_3.translatef(x, y, z);
        return this;
    }

    public MutableQuad translated(double x, double y, double z) {
        return this.translatef((float)x, (float)y, (float)z);
    }

    public MutableQuad translatevi(class_2382 vec) {
        return this.translatei(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public MutableQuad translatevf(Vector3f vec) {
        return this.translatef(vec.x, vec.y, vec.z);
    }

    public MutableQuad translatevd(class_243 vec) {
        return this.translated(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public MutableQuad scalef(float scale) {
        this.vertex_0.scalef(scale);
        this.vertex_1.scalef(scale);
        this.vertex_2.scalef(scale);
        this.vertex_3.scalef(scale);
        return this;
    }

    public MutableQuad scaled(double scale) {
        return this.scalef((float)scale);
    }

    public MutableQuad scalef(float x, float y, float z) {
        this.vertex_0.scalef(x, y, z);
        this.vertex_1.scalef(x, y, z);
        this.vertex_2.scalef(x, y, z);
        this.vertex_3.scalef(x, y, z);
        return this;
    }

    public MutableQuad scaled(double x, double y, double z) {
        return this.scalef((float)x, (float)y, (float)z);
    }

    public void rotateX(float angle) {
        this.vertex_0.rotateX(angle);
        this.vertex_1.rotateX(angle);
        this.vertex_2.rotateX(angle);
        this.vertex_3.rotateX(angle);
    }

    public void rotateY(float angle) {
        this.vertex_0.rotateY(angle);
        this.vertex_1.rotateY(angle);
        this.vertex_2.rotateY(angle);
        this.vertex_3.rotateY(angle);
    }

    public void rotateZ(float angle) {
        this.vertex_0.rotateZ(angle);
        this.vertex_1.rotateZ(angle);
        this.vertex_2.rotateZ(angle);
        this.vertex_3.rotateZ(angle);
    }

    public void rotateDirectlyX(float cos, float sin) {
        this.vertex_0.rotateDirectlyX(cos, sin);
        this.vertex_1.rotateDirectlyX(cos, sin);
        this.vertex_2.rotateDirectlyX(cos, sin);
        this.vertex_3.rotateDirectlyX(cos, sin);
    }

    public void rotateDirectlyY(float cos, float sin) {
        this.vertex_0.rotateDirectlyY(cos, sin);
        this.vertex_1.rotateDirectlyY(cos, sin);
        this.vertex_2.rotateDirectlyY(cos, sin);
        this.vertex_3.rotateDirectlyY(cos, sin);
    }

    public void rotateDirectlyZ(float cos, float sin) {
        this.vertex_0.rotateDirectlyZ(cos, sin);
        this.vertex_1.rotateDirectlyZ(cos, sin);
        this.vertex_2.rotateDirectlyZ(cos, sin);
        this.vertex_3.rotateDirectlyZ(cos, sin);
    }

    public MutableQuad rotate(class_2350 from, class_2350 to, float ox, float oy, float oz) {
        if (from == to) {
            return this;
        }
        this.translatef(-ox, -oy, -oz);
        switch (from.method_10166()) {
            case field_11048: {
                int mult = from.method_10148();
                switch (to.method_10166()) {
                    case field_11048: {
                        this.rotateY_180();
                        break;
                    }
                    case field_11052: {
                        this.rotateZ_90(mult * to.method_10164());
                        break;
                    }
                    case field_11051: {
                        this.rotateY_90(mult * to.method_10165());
                    }
                }
                break;
            }
            case field_11052: {
                int mult = from.method_10164();
                switch (to.method_10166()) {
                    case field_11048: {
                        this.rotateZ_90(-mult * to.method_10148());
                        break;
                    }
                    case field_11052: {
                        this.rotateZ_180();
                        break;
                    }
                    case field_11051: {
                        this.rotateX_90(mult * to.method_10165());
                    }
                }
                break;
            }
            case field_11051: {
                int mult = -from.method_10165();
                switch (to.method_10166()) {
                    case field_11048: {
                        this.rotateY_90(mult * to.method_10148());
                        break;
                    }
                    case field_11052: {
                        this.rotateX_90(mult * to.method_10164());
                        break;
                    }
                    case field_11051: {
                        this.rotateY_180();
                    }
                }
                break;
            }
        }
        this.translatef(ox, oy, oz);
        return this;
    }

    public MutableQuad rotateX_90(float scale) {
        this.vertex_0.rotateX_90(scale);
        this.vertex_1.rotateX_90(scale);
        this.vertex_2.rotateX_90(scale);
        this.vertex_3.rotateX_90(scale);
        return this;
    }

    public MutableQuad rotateY_90(float scale) {
        this.vertex_0.rotateY_90(scale);
        this.vertex_1.rotateY_90(scale);
        this.vertex_2.rotateY_90(scale);
        this.vertex_3.rotateY_90(scale);
        return this;
    }

    public MutableQuad rotateZ_90(float scale) {
        this.vertex_0.rotateZ_90(scale);
        this.vertex_1.rotateZ_90(scale);
        this.vertex_2.rotateZ_90(scale);
        this.vertex_3.rotateZ_90(scale);
        return this;
    }

    public MutableQuad rotateX_180() {
        this.vertex_0.rotateX_180();
        this.vertex_1.rotateX_180();
        this.vertex_2.rotateX_180();
        this.vertex_3.rotateX_180();
        return this;
    }

    public MutableQuad rotateY_180() {
        this.vertex_0.rotateY_180();
        this.vertex_1.rotateY_180();
        this.vertex_2.rotateY_180();
        this.vertex_3.rotateY_180();
        return this;
    }

    public MutableQuad rotateZ_180() {
        this.vertex_0.rotateZ_180();
        this.vertex_1.rotateZ_180();
        this.vertex_2.rotateZ_180();
        this.vertex_3.rotateZ_180();
        return this;
    }

    public String toString() {
        return "MutableQuad [vertices=" + this.vToS() + ", tintIndex=" + this.colourIndex + ", face=" + String.valueOf(this.face) + "]";
    }

    private String vToS() {
        return "[ " + String.valueOf(this.vertex_0) + ", " + String.valueOf(this.vertex_1) + ", " + String.valueOf(this.vertex_2) + ", " + String.valueOf(this.vertex_3) + " ]";
    }
}

