/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.client.model;

import alexiil.mc.mod.pipes.client.model.ModelUtil;
import alexiil.mc.mod.pipes.client.model.MutableQuad;
import alexiil.mc.mod.pipes.client.model.SpriteSupplier;
import alexiil.mc.mod.pipes.client.model.part.PipeSpPartKey;
import alexiil.mc.mod.pipes.client.model.part.PipeSpSidedPartKey;
import alexiil.mc.mod.pipes.part.SimplePipeParts;
import alexiil.mc.mod.pipes.pipe.PipeSpDef;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_777;

public class PipeBaseModelGenStandard {
    private static final MutableQuad[][][] QUADS = new MutableQuad[2][][];
    private static final MutableQuad[][][] QUADS_COLOURED = new MutableQuad[2][][];

    private static void dupDarker(MutableQuad[] quads) {
        int halfLength = quads.length / 2;
        float mult = 0.7f;
        for (int i = 0; i < halfLength; ++i) {
            int n = i + halfLength;
            MutableQuad from = quads[i];
            if (from == null) continue;
            MutableQuad to = from.copyAndInvertNormal();
            to.translatevd(to.normalvd().method_1021(0.0625));
            to.setCalculatedDiffuse();
            to.multColourd(mult);
            quads[n] = to;
        }
    }

    private static void dupInverted(MutableQuad[] quads) {
        int halfLength = quads.length / 2;
        for (int i = 0; i < halfLength; ++i) {
            int n = i + halfLength;
            MutableQuad from = quads[i];
            if (from == null) continue;
            MutableQuad to = from.copyAndInvertNormal();
            to.translatevd(to.normalvd().method_1021(0.0625));
            quads[n] = to;
        }
    }

    public static List<class_777> generateCutout(SpriteSupplier sprites, PipeSpPartKey key) {
        return PipeBaseModelGenStandard.generateCutout(key, () -> PipeBaseModelGenStandard.getCenterSprite(sprites, key.def), face -> PipeBaseModelGenStandard.getSprite(sprites, key, face));
    }

    public static List<class_777> generateCutout(PipeSpPartKey key, Supplier<class_1058> getCenterSprite, Function<class_2350, class_1058> getSideSprite) {
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        for (class_2350 face : class_2350.values()) {
            boolean connected = key.isConnected(face);
            class_1058 sprite = connected ? getSideSprite.apply(face) : getCenterSprite.get();
            int quadsIndex = connected ? 1 : 0;
            MutableQuad[] quadArray = QUADS[quadsIndex][face.ordinal()];
            PipeBaseModelGenStandard.addQuads(quadArray, quads, sprite);
        }
        ArrayList<class_777> bakedQuads = new ArrayList<class_777>();
        for (MutableQuad q : quads) {
            bakedQuads.add(q.toBakedBlock());
        }
        return bakedQuads;
    }

    private static class_1058 getPipeSprite(SpriteSupplier sprites, String id) {
        return sprites.getBlockSprite("simple_pipes:block/pipe_" + id);
    }

    public static class_1058 getCenterSprite(SpriteSupplier sprites, PipeSpDef def) {
        if (def == SimplePipeParts.WOODEN_PIPE_ITEMS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "wooden_item_clear");
        }
        if (def == SimplePipeParts.STONE_PIPE_ITEMS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "stone_item");
        }
        if (def == SimplePipeParts.GOLD_PIPE_ITEMS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "gold_item");
        }
        if (def == SimplePipeParts.DIAMOND_PIPE_ITEMS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item");
        }
        if (def == SimplePipeParts.IRON_PIPE_ITEMS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "iron_item_filled");
        }
        if (def == SimplePipeParts.CLAY_PIPE_ITEMS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "clay_item");
        }
        if (def == SimplePipeParts.WOODEN_PIPE_FLUIDS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "wooden_fluid_clear");
        }
        if (def == SimplePipeParts.STONE_PIPE_FLUIDS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "stone_fluid");
        }
        if (def == SimplePipeParts.IRON_PIPE_FLUIDS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "iron_fluid_filled");
        }
        if (def == SimplePipeParts.CLAY_PIPE_FLUIDS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "clay_fluid");
        }
        if (def == SimplePipeParts.SPONGE_PIPE_FLUIDS) {
            return PipeBaseModelGenStandard.getPipeSprite(sprites, "sponge_fluid");
        }
        class_2960 spriteId = class_2960.method_60655((String)def.identifier.method_12836(), (String)("block/" + def.identifier.method_12832()));
        return sprites.getBlockSprite(spriteId);
    }

    private static class_1058 getSprite(SpriteSupplier sprites, PipeSpPartKey key, class_2350 face) {
        PipeSpDef pipeDef = key.def;
        if (key instanceof PipeSpSidedPartKey) {
            class_2350 mainDir = ((PipeSpSidedPartKey)key).mainSide;
            if (mainDir == face) {
                if (pipeDef == SimplePipeParts.WOODEN_PIPE_ITEMS) {
                    return PipeBaseModelGenStandard.getPipeSprite(sprites, "wooden_item_filled");
                }
                if (pipeDef == SimplePipeParts.IRON_PIPE_ITEMS) {
                    return PipeBaseModelGenStandard.getPipeSprite(sprites, "iron_item_clear");
                }
                if (pipeDef == SimplePipeParts.WOODEN_PIPE_FLUIDS) {
                    return PipeBaseModelGenStandard.getPipeSprite(sprites, "wooden_fluid_filled");
                }
                if (pipeDef == SimplePipeParts.IRON_PIPE_FLUIDS) {
                    return PipeBaseModelGenStandard.getPipeSprite(sprites, "iron_fluid_clear");
                }
            }
        } else if (pipeDef == SimplePipeParts.DIAMOND_PIPE_ITEMS) {
            if (face == class_2350.field_11033) {
                return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item_down");
            }
            if (face == class_2350.field_11036) {
                return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item_up");
            }
            if (face == class_2350.field_11043) {
                return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item_north");
            }
            if (face == class_2350.field_11035) {
                return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item_south");
            }
            if (face == class_2350.field_11039) {
                return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item_west");
            }
            if (face == class_2350.field_11034) {
                return PipeBaseModelGenStandard.getPipeSprite(sprites, "diamond_item_east");
            }
        }
        return PipeBaseModelGenStandard.getCenterSprite(sprites, pipeDef);
    }

    private static void addQuads(MutableQuad[] from, List<MutableQuad> to, class_1058 sprite) {
        for (MutableQuad f : from) {
            if (f == null) continue;
            MutableQuad copy = new MutableQuad(f);
            copy.setSprite(sprite);
            copy.texFromSprite(sprite);
            to.add(copy);
        }
    }

    static {
        double colourOffset = 0.01;
        class_243[] faceOffset = new class_243[6];
        for (class_2350 class_23502 : class_2350.values()) {
            faceOffset[class_23502.ordinal()] = class_243.method_24954((class_2382)class_23502.method_10153().method_10163()).method_1021(0.01);
        }
        PipeBaseModelGenStandard.QUADS[0] = new MutableQuad[6][2];
        PipeBaseModelGenStandard.QUADS_COLOURED[0] = new MutableQuad[6][2];
        class_243 center = new class_243(0.5, 0.5, 0.5);
        class_243 radius = new class_243(0.25, 0.25, 0.25);
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        uvs.minV = 0.25f;
        uvs.minU = 0.25f;
        uvs.maxV = 0.75f;
        uvs.maxU = 0.75f;
        for (class_2350 face : class_2350.values()) {
            MutableQuad[] colQuads;
            MutableQuad quad = ModelUtil.createFace(face, center, radius, uvs);
            quad.setDiffuse(quad.normalvf());
            PipeBaseModelGenStandard.QUADS[0][face.ordinal()][0] = quad;
            PipeBaseModelGenStandard.dupDarker(QUADS[0][face.ordinal()]);
            for (MutableQuad q : colQuads = ModelUtil.createDoubleFace(face, center, radius, uvs)) {
                q.translatevd(faceOffset[face.ordinal()]);
            }
            PipeBaseModelGenStandard.QUADS_COLOURED[0][face.ordinal()] = colQuads;
        }
        int[][] nArrayArray = new int[][]{{2, 0, 3, 3}, {0, 2, 1, 1}, {2, 0, 0, 2}, {0, 2, 2, 0}, {3, 3, 0, 2}, {1, 1, 2, 0}};
        ModelUtil.UvFaceData[] types = new ModelUtil.UvFaceData[]{ModelUtil.UvFaceData.from16(4, 0, 12, 4), ModelUtil.UvFaceData.from16(4, 12, 12, 16), ModelUtil.UvFaceData.from16(0, 4, 4, 12), ModelUtil.UvFaceData.from16(12, 4, 16, 12)};
        PipeBaseModelGenStandard.QUADS[1] = new MutableQuad[6][8];
        PipeBaseModelGenStandard.QUADS_COLOURED[1] = new MutableQuad[6][8];
        for (class_2350 side : class_2350.values()) {
            center = new class_243(0.5 + (double)((float)side.method_10148() * 0.375f), 0.5 + (double)((float)side.method_10164() * 0.375f), 0.5 + (double)((float)side.method_10165() * 0.375f));
            radius = new class_243(side.method_10166() == class_2350.class_2351.field_11048 ? 0.125 : 0.25, side.method_10166() == class_2350.class_2351.field_11052 ? 0.125 : 0.25, side.method_10166() == class_2350.class_2351.field_11051 ? 0.125 : 0.25);
            int i = 0;
            for (class_2350 face : class_2350.values()) {
                if (face.method_10166() == side.method_10166()) continue;
                MutableQuad quad = ModelUtil.createFace(face, center, radius, types[i]);
                quad.rotateTextureUp(nArrayArray[side.ordinal()][i]);
                MutableQuad col = new MutableQuad(quad);
                quad.setDiffuse(quad.normalvf());
                PipeBaseModelGenStandard.QUADS[1][side.ordinal()][i] = quad;
                col.translatevd(faceOffset[face.ordinal()]);
                PipeBaseModelGenStandard.QUADS_COLOURED[1][side.ordinal()][i++] = col;
            }
            PipeBaseModelGenStandard.dupDarker(QUADS[1][side.ordinal()]);
            PipeBaseModelGenStandard.dupInverted(QUADS_COLOURED[1][side.ordinal()]);
        }
    }
}

