/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.part;

import alexiil.mc.lib.attributes.item.ItemStackCollections;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.SimplePipes;
import alexiil.mc.mod.pipes.part.FacadeBlockStateInfo;
import alexiil.mc.mod.pipes.util.BlockUtil;
import alexiil.mc.mod.pipes.util.SingleBlockView;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2429;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2506;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8923;

public final class FacadeStateManager {
    private static final FacadeStateManager INSTANCE;
    public static final boolean DEBUG;
    private static final Map<class_2248, String> disabledBlocks;
    private static final Map<class_2680, class_1799> customBlocks;
    private static final Map<class_2769<?>, Comparable<?>> limitedProperties;
    private static final FacadeBlockStateInfo defaultState;
    private static final SortedMap<class_2680, FacadeBlockStateInfo> validFacadeStates;
    private static final Map<class_1799, List<FacadeBlockStateInfo>> stackFacades;
    private static FacadeBlockStateInfo previewState;
    private static boolean hasUpdates;
    private static final Set<class_2248> newBlocks;
    private static final ReentrantLock LOCK;
    private static final List<String> KNOWN_INVALID_REPORTED_MODS;

    public static FacadeStateManager getInstance() {
        return INSTANCE;
    }

    public static void lock() {
        LOCK.lock();
    }

    public static void unlock() {
        LOCK.unlock();
    }

    private FacadeStateManager() {
        FacadeStateManager.scanBlocks((Iterable<class_2248>)class_7923.field_41175);
        RegistryEntryAddedCallback.event((class_2378)class_7923.field_41175).register((rawId, identifier, object) -> {
            newBlocks.add((class_2248)object);
            hasUpdates = true;
        });
        previewState = (FacadeBlockStateInfo)validFacadeStates.get(class_2246.field_10104.method_9564());
    }

    private static void scanBlocks(Iterable<class_2248> blockSet) {
        Throwable ex = null;
        for (class_2248 block : blockSet) {
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            try {
                FacadeStateManager.scanBlock(block, blockId);
            }
            catch (Throwable t) {
                if (ex == null) {
                    ex = new RuntimeException("Failed to scan all block's while loading facades!");
                }
                ex.addSuppressed(t);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static SortedMap<class_2680, FacadeBlockStateInfo> getValidFacadeStates() {
        FacadeStateManager.update();
        return validFacadeStates;
    }

    public static Map<class_1799, List<FacadeBlockStateInfo>> getStackFacades() {
        return stackFacades;
    }

    public static FacadeBlockStateInfo getDefaultState() {
        FacadeStateManager.update();
        return defaultState;
    }

    public static FacadeBlockStateInfo getPreviewState() {
        FacadeStateManager.update();
        return previewState;
    }

    public static FacadeBlockStateInfo getInfoForBlock(class_2248 block) {
        return FacadeStateManager.getInfoForState(block.method_9564());
    }

    private static FacadeBlockStateInfo getInfoForState(class_2680 state) {
        return (FacadeBlockStateInfo)FacadeStateManager.getValidFacadeStates().get(state);
    }

    public static void load() {
    }

    private static void update() {
        if (hasUpdates) {
            FacadeStateManager.updateInner();
            hasUpdates = false;
        }
    }

    private static void updateInner() {
        ArrayList<class_2248> blocks = new ArrayList<class_2248>(newBlocks);
        newBlocks.clear();
        FacadeStateManager.scanBlocks(blocks);
    }

    private static void scanBlock(class_2248 block, class_2960 blockId) {
        if (!DEBUG && KNOWN_INVALID_REPORTED_MODS.contains(blockId.method_12836())) {
            return;
        }
        Throwable ex = null;
        for (class_2769 property : block.method_9595().method_11659()) {
            try {
                FacadeStateManager.ensurePropertyConforms(property);
            }
            catch (RuntimeException t) {
                if (ex == null) {
                    ex = new IllegalStateException("Found some properties that didn't conform!\n(For block = " + String.valueOf(blockId) + ")");
                }
                ex.addSuppressed(t);
            }
        }
        if (ex != null) {
            throw ex;
        }
        class_1271<String> result = FacadeStateManager.isValidFacadeBlock(block);
        if (result.method_5467() != class_1269.field_5811 && result.method_5467() != class_1269.field_5812) {
            if (DEBUG) {
                SimplePipes.LOGGER.info("[silicon.facade] Disallowed block " + String.valueOf(blockId) + " because " + (String)result.method_5466());
            }
            return;
        }
        if (DEBUG && result.method_5467() == class_1269.field_5812) {
            SimplePipes.LOGGER.info("[silicon.facade] Allowed block " + String.valueOf(blockId));
        }
        HashMap<class_2680, class_1799> usedStates = new HashMap<class_2680, class_1799>();
        Map varyingProperties = ItemStackCollections.map();
        for (class_2680 state : block.method_9595().method_11662()) {
            class_1799 stack;
            if (result.method_5467() != class_1269.field_5812) {
                class_1271<String> stateResult = FacadeStateManager.isValidFacadeState(state);
                if (stateResult.method_5467() == class_1269.field_5812) {
                    if (DEBUG) {
                        SimplePipes.LOGGER.info("[silicon.facade] Allowed state " + String.valueOf(state));
                    }
                } else {
                    if (!DEBUG) continue;
                    SimplePipes.LOGGER.info("[silicon.facade] Disallowed state " + String.valueOf(state) + " because " + (String)stateResult.method_5466());
                    continue;
                }
            }
            if ((stack = FacadeStateManager.getRequiredStack(state)).method_7960()) {
                if (DEBUG) {
                    SimplePipes.LOGGER.info("[silicon.facade] Disallowed state " + String.valueOf(state) + " because it didn't have an item!");
                }
                return;
            }
            usedStates.put(state, stack);
            HashMap vars2 = (HashMap)varyingProperties.get(stack);
            if (vars2 == null) {
                vars2 = new HashMap(state.method_11656());
                varyingProperties.put(stack, vars2);
                continue;
            }
            for (Map.Entry entry : state.method_11656().entrySet()) {
                class_2769 prop = (class_2769)entry.getKey();
                Comparable value = (Comparable)entry.getValue();
                if (vars2.get(prop) == value) continue;
                vars2.put(prop, null);
            }
        }
        NetByteBuf testingBuffer = NetByteBuf.buffer();
        varyingProperties.forEach((key, vars) -> {
            if (DEBUG) {
                SimplePipes.LOGGER.info("[silicon.facade]   pre-" + String.valueOf(key) + ":");
                vars.keySet().forEach(p -> SimplePipes.LOGGER.info("[silicon.facade]       " + String.valueOf(p)));
            }
            vars.values().removeIf(Objects::nonNull);
            if (DEBUG && !vars.isEmpty()) {
                SimplePipes.LOGGER.info("[silicon.facade]   " + String.valueOf(key) + ":");
                vars.keySet().forEach(p -> SimplePipes.LOGGER.info("[silicon.facade]       " + String.valueOf(p)));
            }
        });
        for (Map.Entry entry : usedStates.entrySet()) {
            class_2680 state = (class_2680)entry.getKey();
            class_1799 stack = (class_1799)entry.getValue();
            Map vars3 = (Map)varyingProperties.get(stack);
            try {
                class_2487 nbt;
                FacadeBlockStateInfo read;
                ImmutableSet varSet = ImmutableSet.copyOf(vars3.keySet());
                FacadeBlockStateInfo info = new FacadeBlockStateInfo(state, stack, varSet);
                validFacadeStates.put(state, info);
                if (!info.requiredStack.method_7960()) {
                    stackFacades.computeIfAbsent(info.requiredStack, k -> new ArrayList()).add(info);
                }
                if ((read = FacadeBlockStateInfo.fromTag(nbt = info.toTag(), validFacadeStates)) != info) {
                    throw new IllegalStateException("Read (from NBT) state was different! (\n\t" + String.valueOf(read) + "\n !=\n\t" + String.valueOf(info) + "\n\tNBT = " + String.valueOf(nbt) + "\n)");
                }
                info.writeToBuffer(testingBuffer);
                read = FacadeBlockStateInfo.readFromBuffer(testingBuffer, validFacadeStates);
                if (read != info) {
                    throw new IllegalStateException("Read (from buffer) state was different! (\n\t" + String.valueOf(read) + "\n !=\n\t" + String.valueOf(info) + "\n)");
                }
                testingBuffer.clear();
                if (!DEBUG) continue;
                SimplePipes.LOGGER.info("[silicon.facade]   Added " + String.valueOf(info));
            }
            catch (Throwable t) {
                Object msg = "Scanning facade states";
                msg = (String)msg + "\n\tState = " + String.valueOf(state);
                msg = (String)msg + "\n\tBlock = " + String.valueOf(blockId);
                msg = (String)msg + "\n\tStack = " + String.valueOf(stack);
                msg = (String)msg + "\n\tvarying-properties: {";
                for (Map.Entry varEntry : vars3.entrySet()) {
                    msg = (String)msg + "\n\t\t" + String.valueOf(varEntry.getKey()) + " = " + String.valueOf(varEntry.getValue());
                }
                msg = (String)msg + "\n\t}";
                throw new IllegalStateException(((String)msg).replace("\t", "    "), t);
            }
        }
    }

    private static class_1271<String> isValidFacadeBlock(class_2248 block) {
        String disablingMod = disabledBlocks.get(block);
        if (disablingMod != null) {
            return new class_1271(class_1269.field_5814, (Object)("it has been disabled by " + disablingMod));
        }
        if (block instanceof class_2404) {
            return new class_1271(class_1269.field_5814, (Object)"it is a fluid block");
        }
        if (block instanceof class_8923 || block instanceof class_2506) {
            return new class_1271(class_1269.field_5812, (Object)"");
        }
        if (block instanceof class_2482) {
            return new class_1271(class_1269.field_5814, (Object)"it is a slab block");
        }
        return new class_1271(class_1269.field_5811, (Object)"");
    }

    private static class_1271<String> isValidFacadeState(class_2680 state) {
        class_265 shape;
        if (state.method_26204() instanceof class_2343) {
            return new class_1271(class_1269.field_5814, (Object)"it has a block entity");
        }
        if (state.method_26217() != class_2464.field_11458) {
            return new class_1271(class_1269.field_5814, (Object)"it doesn't have a normal model");
        }
        for (class_2769 prop : state.method_28501()) {
            Comparable<?> value = limitedProperties.get(prop);
            if (value == null || Objects.equals(value, state.method_11654(prop))) continue;
            return new class_1271(class_1269.field_5814, (Object)("it has a property (" + String.valueOf(prop) + ") that doesn't match it's limited value!"));
        }
        if (state.method_28501().containsAll(class_2429.field_11329.values())) {
            boolean val = (Boolean)state.method_11654((class_2769)class_2429.field_11330);
            for (class_2746 prop : class_2429.field_11329.values()) {
                if ((Boolean)state.method_11654((class_2769)prop) == val) continue;
                return new class_1271(class_1269.field_5814, (Object)"it is a mushroom with non-matching properties!");
            }
        }
        if (!class_259.method_1082((class_265)(shape = state.method_26220((class_1922)new SingleBlockView(state), SingleBlockView.POS)), (class_265)class_259.method_1077(), (class_247)class_247.field_16893).method_1110()) {
            return new class_1271(class_1269.field_5814, (Object)"it isn't a full cube");
        }
        return new class_1271(class_1269.field_5812, (Object)"");
    }

    @Nonnull
    private static class_1799 getRequiredStack(class_2680 state) {
        class_1799 stack = customBlocks.get(state);
        if (stack != null) {
            return stack;
        }
        return new class_1799((class_1935)state.method_26204());
    }

    private static <V extends Comparable<V>> void ensurePropertyConforms(class_2769<V> property) throws RuntimeException {
        try {
            property.method_11900("");
        }
        catch (AbstractMethodError error) {
            Object message = "Invalid Property object detected!";
            message = (String)message + "\n  Class = " + String.valueOf(property.getClass());
            message = (String)message + "\n  Method not overriden: Property.getValue(String)";
            RuntimeException exception = new RuntimeException((String)message, error);
            throw exception;
        }
        Iterator iterator = property.method_11898().iterator();
        while (iterator.hasNext()) {
            Comparable value;
            String name = property.method_11901(value = (Comparable)iterator.next());
            Optional optional = property.method_11900(name);
            Comparable parsed = optional == null ? null : (Comparable)optional.orElse(null);
            if (Objects.equals(value, parsed)) continue;
            Object message = "Invalid property value detected!";
            message = (String)message + "\n  Property class = " + String.valueOf(property.getClass());
            message = (String)message + "\n  Property = " + String.valueOf(property);
            message = (String)message + "\n  Possible Values = " + String.valueOf(property.method_11898());
            message = (String)message + "\n  Value Name = " + name;
            message = (String)message + "\n  Value (original) = " + String.valueOf(value);
            message = (String)message + "\n  Value (parsed) = " + String.valueOf(parsed);
            message = (String)message + "\n  Value class (original) = " + String.valueOf(value == null ? null : value.getClass());
            message = (String)message + "\n  Value class (parsed) = " + String.valueOf(parsed == null ? null : parsed.getClass());
            if (optional == null) {
                message = (String)message + "\n  Property.parseValue() -> Null java.util.Optional!!";
            }
            message = (String)message + "\n";
            RuntimeException exception = new RuntimeException((String)message);
            throw exception;
        }
    }

    public Collection<FacadeBlockStateInfo> getValidFacades() {
        return validFacadeStates.values();
    }

    static {
        DEBUG = Boolean.getBoolean("simplepipes.debug_facades");
        disabledBlocks = new HashMap<class_2248, String>();
        customBlocks = new HashMap<class_2680, class_1799>();
        limitedProperties = new IdentityHashMap();
        hasUpdates = false;
        newBlocks = new HashSet<class_2248>();
        LOCK = new ReentrantLock();
        KNOWN_INVALID_REPORTED_MODS = Arrays.asList(new String[0]);
        try {
            LOCK.lock();
            if (DEBUG) {
                SimplePipes.LOGGER.info("Debugging enabled for facades. Prepare for log spam!");
            } else {
                SimplePipes.LOGGER.debug("Debugging disabled for facades. (Add -Dsimplepipes.debug_facades=true to enable)");
            }
            limitedProperties.put((class_2769<?>)class_2741.field_12514, Boolean.valueOf(false));
            limitedProperties.put((class_2769<?>)class_2741.field_16503, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12541, Integer.valueOf(1));
            limitedProperties.put((class_2769<?>)class_2741.field_12521, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12556, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12497, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12482, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12550, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12498, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12517, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12484, Boolean.valueOf(false));
            limitedProperties.put((class_2769<?>)class_2741.field_12499, (Comparable<?>)class_2766.field_12648);
            limitedProperties.put((class_2769<?>)class_2741.field_12524, Integer.valueOf(0));
            limitedProperties.put((class_2769<?>)class_2741.field_12508, Boolean.valueOf(false));
            defaultState = new FacadeBlockStateInfo(class_2246.field_10124.method_9564(), class_1799.field_8037, ImmutableSet.of());
            validFacadeStates = new TreeMap<class_2680, FacadeBlockStateInfo>(BlockUtil.blockStateComparator());
            stackFacades = ItemStackCollections.map();
            previewState = defaultState;
            INSTANCE = new FacadeStateManager();
        }
        finally {
            LOCK.unlock();
        }
    }
}

