/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.part;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidInvUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.impl.SimpleFixedFluidInv;
import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.mod.pipes.client.model.part.TankPartModelKey;
import alexiil.mc.mod.pipes.container.ContainerTank;
import alexiil.mc.mod.pipes.container.SimplePipeContainerFactory;
import alexiil.mc.mod.pipes.items.SimplePipeItems;
import alexiil.mc.mod.pipes.util.FluidSmoother;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_9062;

public class PartTank
extends AbstractPart {
    public static final ParentNetIdSingle<PartTank> NET_TANK = NET_ID.subType(PartTank.class, "simple_pipes:tank");
    public static final NetIdDataK<PartTank> SMOOTHED_TANK_DATA = NET_TANK.idData("smoothed_tank_data").setReceiver(PartTank::receiveSmoothedTankData);
    public static final class_265 SHAPE = class_259.method_1081((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
    private static final FluidAmount SINGLE_TANK_CAPACITY = FluidAmount.BUCKET.mul(16L);
    private boolean isPlayerInteracting = false;
    public final SimpleFixedFluidInv fluidInv = new SimpleFixedFluidInv(1, SINGLE_TANK_CAPACITY);
    public final FluidSmoother smoothedTank = new FluidSmoother(writer -> this.holder.getContainer().sendNetworkUpdate((Object)this, SMOOTHED_TANK_DATA, (obj, buf, ctx) -> {
        buf.writeBoolean(this.isPlayerInteracting);
        writer.write(buf, ctx);
    }), this.fluidInv);

    public PartTank(PartDefinition definition, MultipartHolder holder) {
        super(definition, holder);
        this.fluidInv.setOwnerListener((tank, slot, prev, current) -> holder.getContainer().getMultipartBlockEntity().method_5431());
    }

    public PartTank(PartDefinition definition, MultipartHolder holder, class_2487 tag, class_7225.class_7874 lookup) {
        this(definition, holder);
        if (tag.method_10545("fluidInv")) {
            this.fluidInv.fromTag(tag.method_10562("fluidInv"), lookup);
        }
    }

    public class_2487 toTag(class_7225.class_7874 lookup) {
        class_2487 tag = super.toTag(lookup);
        tag.method_10566("fluidInv", (class_2520)this.fluidInv.toTag(lookup));
        return tag;
    }

    public PartTank(PartDefinition definition, MultipartHolder holder, NetByteBuf buf, IMsgReadCtx ctx) {
        this(definition, holder);
        this.smoothedTank.handleMessage(holder.getContainer().getMultipartWorld(), buf, ctx);
    }

    public void writeCreationData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        super.writeCreationData(buffer, ctx);
        this.smoothedTank.writeInit(buffer, ctx);
    }

    public class_265 getShape() {
        return SHAPE;
    }

    public class_265 getCullingShape() {
        return class_259.method_1073();
    }

    public PartModelKey getModelKey() {
        return TankPartModelKey.INSTANCE;
    }

    private final void receiveSmoothedTankData(NetByteBuf buffer, IMsgReadCtx ctx) {
        boolean playerInteraction = buffer.readBoolean();
        class_1937 world = this.holder.getContainer().getMultipartWorld();
        this.smoothedTank.handleMessage(world, buffer, ctx);
        if (playerInteraction) {
            this.smoothedTank.resetSmoothing(world);
        }
    }

    public void addAllAttributes(AttributeList<?> list) {
        super.addAllAttributes(list);
        list.offer((Object)this.fluidInv, SHAPE);
    }

    public void onAdded(MultipartEventBus bus) {
        super.onAdded(bus);
        bus.addContextlessListener((Object)this, PartTickEvent.class, this::onTick);
    }

    public class_1799 getPickStack() {
        return new class_1799((class_1935)SimplePipeItems.TANK);
    }

    protected class_2680 getClosestBlockState() {
        return class_2246.field_10033.method_9564();
    }

    protected void onTick() {
        this.smoothedTank.tick(this.holder.getContainer().getMultipartWorld());
        this.isPlayerInteracting = false;
    }

    public class_1269 onUse(class_1657 player, class_3965 hit) {
        if (!player.method_37908().field_9236) {
            player.method_17355(new SimplePipeContainerFactory<Object>(SimplePipeItems.TANK.method_7848(), (syncId, inv, player1) -> new ContainerTank(syncId, player1, this), player1 -> this.holder.getContainer().getMultipartPos()));
        }
        return class_1269.field_5812;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_9062 onUseWithItem(class_1799 stack, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_37908().field_9236) {
            return class_9062.field_47728;
        }
        try {
            this.isPlayerInteracting = true;
            class_9062 class_90622 = FluidInvUtil.interactHandWithTank((FixedFluidInv)this.fluidInv, (class_1657)player, (class_1268)hand).asItemActionResult();
            return class_90622;
        }
        finally {
            this.isPlayerInteracting = false;
        }
    }

    public void onRemoved() {
        super.onRemoved();
        this.fluidInv.invalidateListeners();
    }

    @Nullable
    public FluidSmoother.FluidStackInterp getFluidForRender(float partialTicks) {
        return this.smoothedTank.getFluidForRender(partialTicks);
    }
}

