/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.pipe;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.SearchOption;
import alexiil.mc.lib.attributes.SearchOptions;
import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.NeighbourUpdateEvent;
import alexiil.mc.lib.multipart.api.event.PartAddedEvent;
import alexiil.mc.lib.multipart.api.event.PartRemovedEvent;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.multipart.api.event.PartTransformEvent;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdData;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.NetIdTyped;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.mod.pipes.client.model.PipeBaseModelGenStandard;
import alexiil.mc.mod.pipes.client.model.SpriteSupplier;
import alexiil.mc.mod.pipes.pipe.ISimplePipe;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviour;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviourSided;
import alexiil.mc.mod.pipes.pipe.PipeSpDef;
import alexiil.mc.mod.pipes.pipe.PipeSpFlow;
import alexiil.mc.mod.pipes.pipe.PipeSpFlowItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4990;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class PartSpPipe
extends AbstractPart
implements ISimplePipe {
    public static final class_265 CENTER_SHAPE = class_259.method_1081((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    public static final class_265[] FACE_SHAPES = new class_265[6];
    public static final class_265[] FACE_CENTER_SHAPES = new class_265[6];
    public static final class_265[] SHAPES;
    public static final ParentNetIdSingle<PartSpPipe> NET_PARENT;
    public static final NetIdDataK<PartSpPipe> ID_FLOW;
    public final PipeSpDef definition;
    public final PipeSpFlow flow;
    public final PipeSpBehaviour behaviour;
    public byte connections;

    public static void load() {
    }

    public PartSpPipe(PipeSpDef definition, MultipartHolder holder) {
        super((PartDefinition)definition, holder);
        this.definition = definition;
        this.flow = definition.createFlow(this);
        this.behaviour = definition.createBehaviour(this);
    }

    public void fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        this.connections = (byte)(nbt.method_10571("c") & 0x3F);
        this.flow.fromTag(nbt.method_10562("f"), lookup);
        this.behaviour.fromNbt(nbt.method_10562("b"), lookup);
    }

    public class_2487 toTag(class_7225.class_7874 lookup) {
        class_2487 nbt = super.toTag(lookup);
        nbt.method_10567("c", this.connections);
        nbt.method_10566("f", (class_2520)this.flow.toTag(lookup));
        nbt.method_10566("b", (class_2520)this.behaviour.toNbt(lookup));
        return nbt;
    }

    public void fromBuffer(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.connections = (byte)(buffer.readFixedBits(6) & 0x3F);
        this.flow.fromBuffer(buffer, ctx);
        this.behaviour.fromBuffer(buffer, ctx);
    }

    private void writeToBuffer(NetByteBuf buffer, IMsgWriteCtx ctx) {
        buffer.writeFixedBits((int)this.connections, 6);
        this.flow.writeToBuffer(buffer, ctx);
        this.behaviour.writeToBuffer(buffer, ctx);
    }

    public void writeCreationData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        this.writeToBuffer(buffer, ctx);
    }

    public void readRenderData(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.fromBuffer(buffer, ctx);
        this.refreshModel();
    }

    public void writeRenderData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        this.writeToBuffer(buffer, ctx);
    }

    public PartModelKey getModelKey() {
        return this.behaviour.createModelState();
    }

    public class_265 getShape() {
        return CENTER_SHAPE;
    }

    public class_265 getCollisionShape() {
        return SHAPES[this.connections & 0x3F];
    }

    protected class_2680 getClosestBlockState() {
        return class_2246.field_10340.method_9564();
    }

    public float calculateBreakingDelta(class_1657 player) {
        return PartSpPipe.calcBreakingDelta((class_1657)player, (class_2680)class_2246.field_10033.method_9564(), (float)0.5f);
    }

    public class_1799 getPickStack(@Nullable class_3965 hitResult) {
        return this.definition.getPickStack();
    }

    @Environment(value=EnvType.CLIENT)
    protected void spawnBreakParticles() {
        this.spawnBreakParticles(class_2246.field_10340.method_9564(), PipeBaseModelGenStandard.getCenterSprite(SpriteSupplier.NO_CONTEXT_SUPPLIER, this.definition));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean spawnHitParticle(class_2350 side) {
        this.spawnHitParticle(side, class_2246.field_10340.method_9564(), PipeBaseModelGenStandard.getCenterSprite(SpriteSupplier.NO_CONTEXT_SUPPLIER, this.definition));
        return true;
    }

    public void addAllAttributes(AttributeList<?> list) {
        class_265 pipeShape;
        super.addAllAttributes(list);
        class_2350 pipeSide = list.getTargetSide();
        if (pipeSide == null) {
            return;
        }
        class_265 class_2652 = pipeShape = this.isConnected(pipeSide) ? FACE_CENTER_SHAPES[pipeSide.ordinal()] : CENTER_SHAPE;
        if (this.definition.isExtraction && this.behaviour instanceof PipeSpBehaviourSided && ((PipeSpBehaviourSided)this.behaviour).currentDirection() == pipeSide) {
            list.offer(this.getFlow().getInsertable(list.getSearchDirection()), pipeShape);
        } else {
            list.offer(this.definition.getEmptyExtractable(), pipeShape);
        }
        list.offer((Object)this, CENTER_SHAPE);
    }

    public void onAdded(MultipartEventBus bus) {
        super.onAdded(bus);
        bus.addContextlessListener((Object)this, PartTickEvent.class, this::tick);
        bus.addListener((Object)this, NeighbourUpdateEvent.class, this::onNeighbourUpdate);
        bus.addListener((Object)this, PartAddedEvent.class, e -> this.updateConnections());
        bus.addListener((Object)this, PartRemovedEvent.class, e -> this.updateConnections());
        bus.addListener((Object)this, PartTransformEvent.class, e -> this.transform(e.transformation));
    }

    public void tick() {
        this.behaviour.tick();
        this.flow.tick();
        class_1937 w = this.getPipeWorld();
        if (w != null) {
            w.method_8524(this.getPipePos());
        }
    }

    private void onNeighbourUpdate(NeighbourUpdateEvent event) {
        this.updateConnections();
    }

    private void updateConnections() {
        for (class_2350 dir : class_2350.values()) {
            ISimplePipe oPipe = this.getNeighbourPipe(dir);
            if (this.definition.isExtraction && oPipe != null && oPipe.getDefinition().isExtraction) {
                this.disconnect(dir);
                continue;
            }
            if (oPipe != null) {
                if (this.getFlow() instanceof PipeSpFlowItem == oPipe.getFlow() instanceof PipeSpFlowItem) {
                    this.connect(dir);
                    continue;
                }
                this.disconnect(dir);
                continue;
            }
            if (!PartSpPipe.hasConnectionOverlap(dir, this.holder.getContainer()) && this.canConnect(dir)) {
                this.connect(dir);
                continue;
            }
            this.disconnect(dir);
        }
    }

    private void transform(class_4990 transform) {
        this.transformConnections(transform);
        this.behaviour.transform(transform);
        this.flow.transform(transform);
    }

    public class_1269 onUse(class_1657 player, class_3965 hit) {
        return this.behaviour.onUse(player, hit);
    }

    public class_9062 onUseWithItem(class_1799 stack, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.behaviour.onUseWithItem(stack, player, hand, hit);
    }

    public void addDrops(AbstractPart.ItemDropTarget target, class_8567 context) {
        super.addDrops(target, context);
        this.flow.addDrops(target, context);
        this.behaviour.addDrops(target, context);
    }

    @Override
    public class_2338 getPipePos() {
        return this.holder.getContainer().getMultipartPos();
    }

    @Override
    public class_1937 getPipeWorld() {
        return this.holder.getContainer().getMultipartWorld();
    }

    @Override
    public PipeSpDef getDefinition() {
        return this.definition;
    }

    @Override
    public PipeSpFlow getFlow() {
        return this.flow;
    }

    @Override
    public ISimplePipe getNeighbourPipe(class_2350 dir) {
        if (PartSpPipe.hasConnectionOverlap(dir, this.holder.getContainer())) {
            return null;
        }
        class_2586 neighbour = this.holder.getContainer().getNeighbourBlockEntity(dir);
        if (neighbour instanceof ISimplePipe || neighbour == null) {
            return (ISimplePipe)neighbour;
        }
        MultipartContainer container = (MultipartContainer)MultipartContainer.ATTRIBUTE.getFirstOrNull(this.getPipeWorld(), neighbour.method_11016());
        if (container == null || PartSpPipe.hasConnectionOverlap(dir.method_10153(), container)) {
            return null;
        }
        return (ISimplePipe)container.getFirstPart(ISimplePipe.class);
    }

    public static boolean hasConnectionOverlap(class_2350 dir, MultipartContainer container) {
        return !container.getAllParts(part -> PartSpPipe.doesOverlapConnection(dir, part)).isEmpty();
    }

    private static boolean doesOverlapConnection(class_2350 dir, AbstractPart part) {
        return class_259.method_1074((class_265)part.getShape(), (class_265)FACE_SHAPES[dir.ordinal()], (class_247)class_247.field_16896);
    }

    @Override
    public <T> T getNeighbourAttribute(CombinableAttribute<T> attr, class_2350 dir) {
        if (PartSpPipe.hasConnectionOverlap(dir, this.holder.getContainer())) {
            return (T)attr.defaultValue;
        }
        class_265 shape = SHAPES[1 << dir.ordinal() | 1 << dir.method_10153().ordinal()];
        return (T)attr.get(this.getPipeWorld(), this.getPipePos().method_10093(dir), (SearchOption)SearchOptions.inDirectionalVoxel((class_2350)dir, (class_265)shape));
    }

    protected final byte encodeConnectedSides() {
        return this.connections;
    }

    @Override
    public boolean isConnected(class_2350 dir) {
        return (this.connections & 1 << dir.ordinal()) != 0;
    }

    @Override
    public void connect(class_2350 dir) {
        this.connections = (byte)(this.connections | 1 << dir.ordinal());
        this.refreshModel();
    }

    @Override
    public void disconnect(class_2350 dir) {
        this.connections = (byte)(this.connections & ~(1 << dir.ordinal()));
        this.refreshModel();
    }

    private void transformConnections(class_4990 transform) {
        byte newConnections = 0;
        for (class_2350 dir : class_2350.values()) {
            if (!this.isConnected(dir)) continue;
            class_2350 newDir = transform.method_26388(dir);
            newConnections = (byte)(newConnections | 1 << newDir.ordinal());
        }
        this.connections = newConnections;
    }

    public void refreshModel() {
        if (this.holder.getContainer().isClientWorld()) {
            this.redrawIfChanged();
        } else {
            this.sendNetworkUpdate(this, (NetIdTyped)NET_RENDER_DATA);
        }
        this.recalculateShape();
    }

    protected boolean canConnect(class_2350 dir) {
        return this.behaviour.canConnect(dir);
    }

    @Override
    public double getPipeLength(class_2350 side) {
        if (side == null) {
            return 0.0;
        }
        if (this.isConnected(side)) {
            if (this.getNeighbourPipe(side) == null) {
                return 0.75;
            }
            return 0.5;
        }
        return 0.25;
    }

    @Override
    public void sendFlowPacket(NetIdData.IMsgDataWriter writer) {
        this.sendNetworkUpdate(this, ID_FLOW, (obj, buf, ctx) -> writer.write(buf, ctx));
    }

    private void receiveFlow(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.flow.fromClientTag(buffer, ctx);
    }

    static {
        for (class_2350 dir : class_2350.values()) {
            class_265 faceShape;
            double x = 0.5 + (double)dir.method_10148() * 0.375;
            double y = 0.5 + (double)dir.method_10164() * 0.375;
            double z = 0.5 + (double)dir.method_10165() * 0.375;
            double rx = dir.method_10166() == class_2350.class_2351.field_11048 ? 0.125 : 0.25;
            double ry = dir.method_10166() == class_2350.class_2351.field_11052 ? 0.125 : 0.25;
            double rz = dir.method_10166() == class_2350.class_2351.field_11051 ? 0.125 : 0.25;
            PartSpPipe.FACE_SHAPES[dir.ordinal()] = faceShape = class_259.method_1081((double)(x - rx), (double)(y - ry), (double)(z - rz), (double)(x + rx), (double)(y + ry), (double)(z + rz));
            PartSpPipe.FACE_CENTER_SHAPES[dir.ordinal()] = class_259.method_1084((class_265)faceShape, (class_265)CENTER_SHAPE);
        }
        SHAPES = new class_265[64];
        for (int c = 0; c <= 63; ++c) {
            class_265 shape = CENTER_SHAPE;
            for (class_2350 dir : class_2350.values()) {
                if ((c & 1 << dir.ordinal()) == 0) continue;
                shape = class_259.method_1082((class_265)shape, (class_265)FACE_SHAPES[dir.ordinal()], (class_247)class_247.field_1366);
            }
            PartSpPipe.SHAPES[c] = shape.method_1097();
        }
        NET_PARENT = AbstractPart.NET_ID.subType(PartSpPipe.class, "simple_pipes:pipe_part");
        ID_FLOW = NET_PARENT.idData("flow").toClientOnly();
        ID_FLOW.setReceiver(PartSpPipe::receiveFlow);
    }
}

