/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.pipe;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.client.model.part.PipeSpSidedPartKey;
import alexiil.mc.mod.pipes.pipe.ISimplePipe;
import alexiil.mc.mod.pipes.pipe.PartSpPipe;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviour;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3965;
import net.minecraft.class_4990;
import net.minecraft.class_7225;

public abstract class PipeSpBehaviourSided
extends PipeSpBehaviour {
    private class_2350 currentDirection = null;

    public PipeSpBehaviourSided(PartSpPipe pipe) {
        super(pipe);
    }

    @Override
    public void fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        super.fromNbt(nbt, lookup);
        byte b = nbt.method_10571("dir");
        this.currentDirection = b >= 0 && b < 6 ? class_2350.method_10143((int)b) : null;
    }

    @Override
    public class_2487 toNbt(class_7225.class_7874 lookup) {
        class_2487 nbt = super.toNbt(lookup);
        nbt.method_10567("dir", (byte)(this.currentDirection == null ? 255 : this.currentDirection.method_10146()));
        return nbt;
    }

    @Override
    public void fromBuffer(NetByteBuf buf, IMsgReadCtx ctx) {
        super.fromBuffer(buf, ctx);
        byte b = buf.readByte();
        this.currentDirection = b >= 0 && b < 6 ? class_2350.method_10143((int)b) : null;
    }

    @Override
    public void writeToBuffer(NetByteBuf buf, IMsgWriteCtx ctx) {
        super.writeToBuffer(buf, ctx);
        buf.method_52997(this.currentDirection == null ? 255 : this.currentDirection.method_10146());
    }

    public class_2350 currentDirection() {
        return this.currentDirection;
    }

    public void currentDirection(class_2350 dir) {
        if (this.currentDirection != dir && this.canFaceDirection(dir)) {
            this.currentDirection = dir;
            this.pipe.refreshModel();
        }
    }

    @Override
    public boolean canConnect(class_2350 dir) {
        return super.canConnect(dir) || this.canFaceDirection(dir);
    }

    protected abstract boolean canFaceDirection(class_2350 var1);

    @Override
    public class_1269 onUse(class_1657 player, class_3965 hit) {
        if (player.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        return this.attemptRotation() ? class_1269.field_5812 : class_1269.field_5814;
    }

    public boolean attemptRotation() {
        int idx;
        ArrayList dirs = new ArrayList();
        Collections.addAll(dirs, class_2350.values());
        class_2350 old = this.currentDirection;
        if (old != null && (idx = old.method_10146()) < 5) {
            dirs.addAll(dirs.subList(0, idx + 1));
            dirs.subList(0, idx + 1).clear();
        }
        boolean connectedToAny = false;
        for (class_2350 dir : dirs) {
            ISimplePipe oPipe;
            if (this.canFaceDirection(dir) && !connectedToAny) {
                if (!this.pipe.isConnected(dir)) {
                    this.pipe.connect(dir);
                }
                this.currentDirection = dir;
                connectedToAny = true;
                continue;
            }
            if (!this.pipe.isConnected(dir) || (oPipe = this.pipe.getNeighbourPipe(dir)) != null || this.canConnect(dir)) continue;
            this.pipe.disconnect(dir);
        }
        if (!connectedToAny) {
            this.currentDirection = null;
        }
        if (this.currentDirection != old) {
            this.pipe.refreshModel();
            return true;
        }
        return false;
    }

    @Override
    public void transform(class_4990 transform) {
        this.currentDirection = transform.method_26388(this.currentDirection);
    }

    @Override
    protected PipeSpSidedPartKey createModelState() {
        return new PipeSpSidedPartKey(this.pipe.definition, this.pipe.encodeConnectedSides(), this.currentDirection);
    }
}

