/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.pipe;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmountBase;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.EmptyFluidExtractable;
import alexiil.mc.lib.attributes.fluid.impl.RejectingFluidInsertable;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.part.PipeSpBehaviourIron;
import alexiil.mc.mod.pipes.pipe.ISimplePipe;
import alexiil.mc.mod.pipes.pipe.PartSpPipe;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviourWood;
import alexiil.mc.mod.pipes.pipe.PipeSpFlow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_7225;

public class PipeSpFlowFluid
extends PipeSpFlow {
    public static final FluidAmount SECTION_CAPACITY = FluidAmount.BUCKET.div(2L);
    private static final FluidAmount AMOUNT_OVERFLOW = FluidAmount.of((long)1L, (long)1000L);
    private final Map<class_2350, SideSection> sideSections = new EnumMap<class_2350, SideSection>(class_2350.class);
    public final CenterSection centerSection = new CenterSection();
    final FluidInsertable[] insertables;
    long lastTickTime;

    public PipeSpFlowFluid(ISimplePipe pipe) {
        super(pipe);
        for (final class_2350 dir : class_2350.values()) {
            this.sideSections.put(dir, new SideSection(dir));
        }
        this.insertables = new FluidInsertable[6];
        for (final class_2350 dir : class_2350.values()) {
            this.insertables[dir.method_10153().ordinal()] = new FluidInsertable(){

                public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                    if (fluid.isEmpty()) {
                        return fluid;
                    }
                    SideSection sideSection = PipeSpFlowFluid.this.sideSections.get(dir);
                    if (!(sideSection.fluid.isEmpty() || !sideSection.fluid.amount().isGreaterThanOrEqual((FluidAmountBase)SECTION_CAPACITY) && sideSection.fluid.canMerge(fluid))) {
                        return fluid;
                    }
                    FluidVolume incoming = fluid.copy();
                    FluidVolume inSection = sideSection.fluid.copy();
                    FluidVolume merged = FluidVolume.merge((FluidVolume)inSection, (FluidVolume)incoming);
                    if (merged == null) {
                        return fluid;
                    }
                    FluidVolume excess = FluidVolumeUtil.EMPTY;
                    if (merged.amount().isGreaterThan((FluidAmountBase)SECTION_CAPACITY)) {
                        excess = merged.split(merged.amount().sub(SECTION_CAPACITY));
                    }
                    if (simulation == Simulation.ACTION) {
                        sideSection.fluid = merged;
                    }
                    return excess;
                }

                public FluidFilter getInsertionFilter() {
                    return ConstantFluidFilter.ANYTHING;
                }
            };
        }
    }

    @Override
    public void fromTag(class_2487 tag, class_7225.class_7874 lookup) {
        class_2487 inner = tag.method_10562("sides");
        this.centerSection.fluid = FluidVolume.fromTag((class_2487)inner.method_10562("c"));
        for (class_2350 dir : class_2350.values()) {
            this.sideSections.get((Object)dir).fluid = FluidVolume.fromTag((class_2487)inner.method_10562(dir.method_10151()));
        }
    }

    @Override
    public class_2487 toTag(class_7225.class_7874 lookup) {
        class_2487 tag = new class_2487();
        this.toTag0(tag);
        return tag;
    }

    private void toTag0(class_2487 tag) {
        class_2487 inner = new class_2487();
        tag.method_10566("sides", (class_2520)inner);
        inner.method_10566("c", (class_2520)this.centerSection.fluid.toTag());
        for (class_2350 dir : class_2350.values()) {
            inner.method_10566(dir.method_10151(), (class_2520)this.sideSections.get((Object)dir).fluid.toTag());
        }
    }

    @Override
    public void fromBuffer(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        try {
            this.centerSection.fluid = FluidVolume.fromMcBuffer((class_2540)buffer);
            for (class_2350 dir : class_2350.values()) {
                this.sideSections.get((Object)dir).fluid = FluidVolume.fromMcBuffer((class_2540)buffer);
            }
        }
        catch (IOException e) {
            throw new InvalidInputDataException("Error reading fluid flow", (Throwable)e);
        }
    }

    @Override
    public void writeToBuffer(NetByteBuf buffer, IMsgWriteCtx ctx) {
        this.centerSection.fluid.toMcBuffer((class_2540)buffer);
        for (class_2350 dir : class_2350.values()) {
            this.sideSections.get((Object)dir).fluid.toMcBuffer((class_2540)buffer);
        }
    }

    @Override
    public void fromInitialClientTag(class_2487 tag, class_7225.class_7874 lookup) {
        this.fromTag(tag, lookup);
    }

    @Override
    public void toInitialClientTag(class_2487 tag, class_7225.class_7874 lookup) {
        this.toTag0(tag);
    }

    @Override
    public void fromClientTag(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.fromBuffer(buffer, ctx);
    }

    @Override
    public boolean hasInsertable(class_2350 dir) {
        return this.pipe.getFluidInsertable(dir) != RejectingFluidInsertable.NULL;
    }

    @Override
    public boolean hasExtractable(class_2350 dir) {
        return this.pipe.getFluidExtractable(dir) != EmptyFluidExtractable.NULL;
    }

    public SideSection getSideSection(class_2350 dir) {
        return this.sideSections.get(dir);
    }

    @Override
    public void tick() {
        if (this.world().field_9236) {
            return;
        }
        this.lastTickTime = this.world().method_8510();
        this.updateAmounts();
        this.centerSection.tick();
        for (SideSection section : this.sideSections.values()) {
            section.tick();
        }
        this.updateAmounts();
        if (Math.random() < 0.1) {
            this.pipe.sendFlowPacket(this::writeToBuffer);
        }
    }

    public void tryExtract(class_2350 dir) {
        FluidVolume reallyExtracted;
        FluidVolume merged;
        FluidExtractable from = this.pipe.getFluidExtractable(dir);
        SideSection section = this.sideSections.get(dir);
        FluidAmount max = SECTION_CAPACITY.sub(section.fluid.amount());
        if (!max.isPositive()) {
            return;
        }
        Object filter = section.fluid.isEmpty() ? ConstantFluidFilter.ANYTHING : new ExactFluidFilter(section.fluid.getFluidKey());
        FluidVolume extracted = from.attemptExtraction((FluidFilter)filter, max, Simulation.SIMULATE);
        FluidAmount extractedAmount = extracted.amount();
        if (extractedAmount.isNegative()) {
            throw new IllegalStateException("Extracted a negative amount of fluid!");
        }
        if (extracted.isEmpty()) {
            return;
        }
        FluidVolume fluidVolume = merged = section.fluid.isEmpty() ? extracted : FluidVolume.merge((FluidVolume)section.fluid.copy(), (FluidVolume)extracted);
        if (merged == null) {
            return;
        }
        if (filter == ConstantFluidFilter.ANYTHING) {
            filter = new ExactFluidFilter(extracted.getFluidKey());
        }
        if ((reallyExtracted = from.attemptExtraction((FluidFilter)filter, extractedAmount, Simulation.ACTION)).isEmpty() || !reallyExtracted.amount().equals(extractedAmount)) {
            throw new IllegalStateException("The second call to attemptExtraction on " + String.valueOf(from.getClass()) + " returned a different fluid than was expected!\n  first = " + String.valueOf(extracted) + ",\n  second = " + String.valueOf(reallyExtracted));
        }
        FluidVolume reallyMerged = FluidVolume.merge((FluidVolume)section.fluid, (FluidVolume)reallyExtracted);
        if (reallyMerged == null) {
            throw new IllegalStateException("Failed to merge back again!");
        }
        section.fluid = reallyMerged;
    }

    private void updateAmounts() {
        this.centerSection.updateAmount();
        for (SideSection section : this.sideSections.values()) {
            section.updateAmount();
        }
    }

    @Override
    public Object getInsertable(class_2350 searchDirection) {
        return this.insertables[searchDirection.ordinal()];
    }

    private boolean canGoInDirection(@Nullable class_2350 from, @Nullable class_2350 to) {
        if (from == null) {
            if (to == null) {
                throw new IllegalArgumentException("You cannot got from the center to the center!");
            }
            if (!this.pipe.isConnected(to)) {
                return false;
            }
            if (this.pipe instanceof PartSpPipe) {
                PartSpPipe part = (PartSpPipe)this.pipe;
                if (part.behaviour instanceof PipeSpBehaviourIron) {
                    return to == ((PipeSpBehaviourIron)part.behaviour).currentDirection();
                }
                if (part.behaviour instanceof PipeSpBehaviourWood) {
                    return to != ((PipeSpBehaviourWood)part.behaviour).currentDirection();
                }
            }
            return true;
        }
        if (to == null) {
            return true;
        }
        if (to != from) {
            throw new IllegalArgumentException("You cannot got from a side to another side except for itself!");
        }
        if (!this.pipe.isConnected(to)) {
            return false;
        }
        if (this.pipe instanceof PartSpPipe) {
            PartSpPipe part = (PartSpPipe)this.pipe;
            if (part.behaviour instanceof PipeSpBehaviourIron) {
                return to == ((PipeSpBehaviourIron)part.behaviour).currentDirection();
            }
            if (part.behaviour instanceof PipeSpBehaviourWood) {
                return to != ((PipeSpBehaviourWood)part.behaviour).currentDirection();
            }
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public FluidVolume getClientCenterFluid() {
        return this.centerSection.fluid;
    }

    @Environment(value=EnvType.CLIENT)
    public FluidVolume getClientSideFluid(class_2350 side) {
        return this.sideSections.get((Object)side).fluid;
    }

    public class CenterSection
    extends Section {
        public CenterSection() {
            super(PipeSpFlowFluid.this);
        }

        public FluidVolume getFluid() {
            return this.fluid;
        }

        @Override
        void tick() {
            if (this.fluid.isEmpty()) {
                return;
            }
            ArrayList<class_2350> sides = new ArrayList<class_2350>(6);
            for (class_2350 to : class_2350.values()) {
                if (!PipeSpFlowFluid.this.canGoInDirection(null, to)) continue;
                SideSection other = PipeSpFlowFluid.this.sideSections.get(to);
                FluidAmount movable = this.getMoveable(other, null);
                if (movable.isPositive()) {
                    sides.add(to);
                    continue;
                }
                if (PipeSpFlowFluid.this.canGoInDirection(to, null) || !other.fluid.amount().isLessThan((FluidAmountBase)SECTION_CAPACITY)) continue;
                sides.add(to);
            }
            if (sides.isEmpty()) {
                return;
            }
            Collections.shuffle(sides);
            FluidAmount amt = (FluidAmount)this.lastTickAmount.min((FluidAmountBase)this.fluid.amount());
            FluidAmount[] amounts = amt.splitBalanced(sides.size());
            for (int i = 0; i < sides.size(); ++i) {
                FluidVolume fluidCopy;
                FluidVolume split;
                FluidVolume merged;
                class_2350 to;
                to = (class_2350)sides.get(i);
                FluidAmount max = amounts[i];
                SideSection other = PipeSpFlowFluid.this.sideSections.get(to);
                FluidAmount movable = this.getMoveable(other, max);
                if (!PipeSpFlowFluid.this.canGoInDirection(to, null)) {
                    movable = (FluidAmount)this.fluid.amount().min((FluidAmountBase)SECTION_CAPACITY.sub(other.fluid.amount()));
                }
                if (!movable.isPositive() || (merged = FluidVolume.merge((FluidVolume)other.fluid, (FluidVolume)(split = (fluidCopy = this.fluid.copy()).split(movable)))) == null) continue;
                other.fluid = merged;
                this.fluid = fluidCopy;
                if (!this.fluid.isEmpty()) continue;
                return;
            }
        }
    }

    class SideSection
    extends Section {
        final class_2350 side;

        public SideSection(class_2350 side) {
            super(PipeSpFlowFluid.this);
            this.side = side;
        }

        @Override
        void tick() {
            if (this.fluid.isEmpty()) {
                return;
            }
            ArrayList<class_2350> sides = new ArrayList<class_2350>(2);
            if (PipeSpFlowFluid.this.canGoInDirection(this.side, null)) {
                CenterSection other = PipeSpFlowFluid.this.centerSection;
                FluidAmount movable = this.getMoveable(other, null);
                if (movable.isPositive()) {
                    sides.add(null);
                } else if (!PipeSpFlowFluid.this.canGoInDirection(null, this.side) && other.fluid.amount().isLessThan((FluidAmountBase)SECTION_CAPACITY)) {
                    sides.add(null);
                }
            }
            if (PipeSpFlowFluid.this.canGoInDirection(this.side, this.side)) {
                ISimplePipe oPipe = PipeSpFlowFluid.this.pipe.getNeighbourPipe(this.side);
                if (oPipe != null && oPipe.getFlow() instanceof PipeSpFlowFluid) {
                    PipeSpFlowFluid oFlow = (PipeSpFlowFluid)oPipe.getFlow();
                    SideSection other = oFlow.sideSections.get(this.side.method_10153());
                    FluidAmount movable = this.lastTickAmount.sub((FluidAmount)other.lastTickAmount.sub(AMOUNT_OVERFLOW).max((FluidAmountBase)FluidAmount.ZERO));
                    if (movable.isPositive()) {
                        sides.add(this.side);
                    }
                } else {
                    FluidInsertable insertable = (FluidInsertable)PipeSpFlowFluid.this.pipe.getNeighbourAttribute(FluidAttributes.INSERTABLE, this.side);
                    FluidVolume leftover = insertable.attemptInsertion(this.fluid, Simulation.SIMULATE);
                    if (leftover.amount().isLessThan((FluidAmountBase)this.fluid.amount())) {
                        sides.add(this.side);
                    }
                }
            }
            if (sides.isEmpty()) {
                return;
            }
            Collections.shuffle(sides);
            FluidAmount amt = (FluidAmount)this.lastTickAmount.min((FluidAmountBase)this.fluid.amount());
            FluidAmount[] amounts = amt.splitBalanced(sides.size());
            for (int i = 0; i < sides.size(); ++i) {
                class_2350 to = (class_2350)sides.get(i);
                FluidAmount max = amounts[i];
                if (to == null) {
                    FluidVolume fluidCopy;
                    FluidVolume split;
                    FluidVolume merged;
                    CenterSection other = PipeSpFlowFluid.this.centerSection;
                    FluidAmount movable = this.getMoveable(other, max);
                    if (!PipeSpFlowFluid.this.canGoInDirection(null, this.side)) {
                        movable = (FluidAmount)this.fluid.amount().min((FluidAmountBase)SECTION_CAPACITY.sub(other.fluid.amount()));
                    }
                    if (!movable.isPositive() || (merged = FluidVolume.merge((FluidVolume)other.fluid, (FluidVolume)(split = (fluidCopy = this.fluid.copy()).split(movable)))) == null) continue;
                    other.fluid = merged;
                    this.fluid = fluidCopy;
                    if (!this.fluid.isEmpty()) continue;
                    return;
                }
                ISimplePipe oPipe = PipeSpFlowFluid.this.pipe.getNeighbourPipe(this.side);
                if (oPipe != null && oPipe.getFlow() instanceof PipeSpFlowFluid) {
                    FluidVolume fluidCopy;
                    FluidVolume split;
                    FluidVolume merged;
                    PipeSpFlowFluid oFlow = (PipeSpFlowFluid)oPipe.getFlow();
                    SideSection other = oFlow.sideSections.get(this.side.method_10153());
                    FluidAmount movable = this.getMoveable(other, max);
                    if (!movable.isPositive() || (merged = FluidVolume.merge((FluidVolume)other.fluid, (FluidVolume)(split = (fluidCopy = this.fluid.copy()).split(movable)))) == null) continue;
                    other.fluid = merged;
                    this.fluid = fluidCopy;
                    if (!this.fluid.isEmpty()) continue;
                    return;
                }
                FluidInsertable insertable = (FluidInsertable)PipeSpFlowFluid.this.pipe.getNeighbourAttribute(FluidAttributes.INSERTABLE, this.side);
                FluidAmount movable = this.fluid.amount();
                if (!movable.isPositive()) continue;
                FluidVolume fluidCopy = this.fluid.copy();
                FluidVolume split = fluidCopy.split(movable);
                FluidVolume leftover = insertable.attemptInsertion(split, Simulation.ACTION);
                FluidAmount inserted = split.amount().sub(leftover.amount());
                if (!inserted.isPositive()) continue;
                FluidVolume merged = FluidVolume.merge((FluidVolume)fluidCopy, (FluidVolume)leftover);
                if (merged == null) {
                    throw new IllegalStateException("The fluid " + String.valueOf(fluidCopy.getClass()) + " and " + String.valueOf(leftover.getClass()) + " didn't merge again after they were split!\nThis is either a bug in that fluid volume class, or a bug in " + String.valueOf(insertable.getClass()) + "for returning an invalid result from attemptInsertion");
                }
                this.fluid = merged;
                if (!this.fluid.isEmpty()) continue;
                return;
            }
        }
    }

    abstract class Section {
        FluidVolume fluid = FluidVolumeUtil.EMPTY;
        FluidAmount lastTickAmount = FluidAmount.ZERO;

        Section(PipeSpFlowFluid this$0) {
        }

        public void updateAmount() {
            this.lastTickAmount = this.fluid.amount();
        }

        FluidAmount getMoveable(Section other, FluidAmount max) {
            FluidAmount inOther = (FluidAmount)other.lastTickAmount.max((FluidAmountBase)FluidAmount.ZERO);
            FluidAmount realSpace = SECTION_CAPACITY.sub(other.fluid.amount());
            FluidAmount space = (FluidAmount)this.lastTickAmount.sub(inOther).min((FluidAmountBase)realSpace);
            if (max != null) {
                return (FluidAmount)space.min((FluidAmountBase)max);
            }
            return space;
        }

        abstract void tick();
    }
}

