/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.util;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.impl.SimpleFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class FluidSmoother {
    final IFluidDataSender sender;
    final SimpleFixedFluidInv tank;
    _Side data;

    public FluidSmoother(IFluidDataSender sender, SimpleFixedFluidInv tank) {
        this.sender = sender;
        this.tank = tank;
    }

    public void tick(class_1937 world) {
        if (this.data == null) {
            if (world == null) {
                return;
            }
            this.data = world.field_9236 ? new _Client(this) : new _Server();
        }
        this.data.tick(world);
    }

    public void handleMessage(class_1937 world, NetByteBuf buffer, IMsgReadCtx ctx) {
        if (this.data == null) {
            this.data = new _Client(this);
        }
        if (!(this.data instanceof _Client)) {
            throw new IllegalStateException("You can only call this on the client!");
        }
        ((_Client)this.data).handleMessage(world, buffer, ctx);
    }

    public void writeInit(NetByteBuf buffer, IMsgWriteCtx ctx) {
        if (this.data == null) {
            this.data = new _Server();
        }
        if (!(this.data instanceof _Server)) {
            throw new IllegalStateException("You can only call this on the server!");
        }
        ((_Server)this.data).writeMessage(buffer, ctx);
    }

    public void resetSmoothing(class_1937 world) {
        if (this.data == null && world.field_9236) {
            this.data = new _Client(this);
        }
        if (!(this.data instanceof _Client)) {
            throw new IllegalStateException("You can only call this on the client!");
        }
        _Client client = (_Client)this.data;
        client.resetSmoothing(world);
    }

    @Nullable
    public FluidVolume getFluidForRender() {
        if (this.data instanceof _Client) {
            _Client client = (_Client)this.data;
            if (client.fluid == null) {
                return null;
            }
            return client.fluid;
        }
        return null;
    }

    @Nullable
    public FluidStackInterp getFluidForRender(double partialTicks) {
        if (this.data instanceof _Client) {
            _Client client = (_Client)this.data;
            if (client.fluid == null || client.fluid.isEmpty()) {
                return null;
            }
            double amount = (double)client.amountLast * (1.0 - partialTicks) + (double)client.amount * partialTicks;
            return new FluidStackInterp(client.fluid, amount);
        }
        return null;
    }

    public FluidAmount getCapacity() {
        return this.tank.getMaxAmount_F(0);
    }

    @FunctionalInterface
    public static interface IFluidDataSender {
        public void writePacket(IPayloadWriter var1);
    }

    abstract class _Side {
        _Side(FluidSmoother this$0) {
        }

        abstract void tick(class_1937 var1);
    }

    final class _Client
    extends _Side {
        private float target;
        float amount;
        float amountLast;
        long lastMessage;
        long lastMessageMinus1;
        FluidVolume fluid;

        _Client(FluidSmoother this$0) {
            super(this$0);
        }

        @Override
        void tick(class_1937 world) {
            this.amountLast = this.amount;
            if (this.amount != this.target) {
                float delta = this.target - this.amount;
                long msgDelta = this.lastMessage - this.lastMessageMinus1;
                msgDelta = Math.min(Math.max((int)msgDelta, 1), 10);
                this.amount = Math.abs(delta) < (float)msgDelta ? (this.amount += delta) : (this.amount += delta / (float)((int)msgDelta));
            }
        }

        void handleMessage(class_1937 world, NetByteBuf buffer, IMsgReadCtx ctx) {
            this.target = buffer.readFloat();
            this.fluid = FluidVolume.fromTag((class_2487)buffer.method_10798());
            this.lastMessageMinus1 = this.lastMessage;
            this.lastMessage = world.method_8510();
        }

        void resetSmoothing(class_1937 world) {
            this.lastMessageMinus1 = this.lastMessage = world.method_8510();
            --this.lastMessageMinus1;
        }
    }

    final class _Server
    extends _Side {
        private float sentAmount;
        private boolean sentHasFluid;

        _Server() {
            super(FluidSmoother.this);
            this.sentAmount = -1.0f;
            this.sentHasFluid = false;
        }

        @Override
        void tick(class_1937 world) {
            boolean hasFluid;
            FluidVolume fluid = FluidSmoother.this.tank.getInvFluid(0);
            boolean bl = hasFluid = !fluid.isEmpty();
            if ((float)fluid.amount().asInexactDouble() != this.sentAmount || hasFluid != this.sentHasFluid) {
                FluidSmoother.this.sender.writePacket(this::writeMessage);
            }
        }

        void writeMessage(NetByteBuf buffer, IMsgWriteCtx ctx) {
            FluidVolume fluid = FluidSmoother.this.tank.getInvFluid(0);
            boolean hasFluid = !fluid.isEmpty();
            this.sentAmount = (float)fluid.amount().asInexactDouble();
            this.sentHasFluid = hasFluid;
            buffer.method_52941(this.sentAmount);
            buffer.method_10794((class_2520)fluid.toTag());
        }
    }

    public static class FluidStackInterp {
        public final FluidVolume fluid;
        public final double amount;

        public FluidStackInterp(FluidVolume fluid, double amount) {
            this.fluid = fluid;
            this.amount = amount;
        }
    }

    @FunctionalInterface
    public static interface IPayloadWriter {
        public void write(NetByteBuf var1, IMsgWriteCtx var2);
    }
}

