package io.github.cottonmc.jankson;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import net.minecraft.class_10134;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1761;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3816;
import net.minecraft.class_3827;
import net.minecraft.class_3828;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4996;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6647;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_7106;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7923;
import net.minecraft.class_8249;
import net.minecraft.class_9023;
import net.minecraft.class_9360;
import net.minecraft.class_9428;

public class JanksonFactory {
	public static Jankson.Builder builder() {
		Jankson.Builder builder = Jankson.builder();
				
		builder
			.registerDeserializer(String.class, class_2680.class, BlockAndItemSerializers::getBlockStatePrimitive)
			.registerDeserializer(JsonObject.class, class_2680.class, BlockAndItemSerializers::getBlockState)
			.registerSerializer(class_2680.class, BlockAndItemSerializers::saveBlockState);
		
		builder
			.registerDeserializer(String.class, class_2960.class, (s, m) -> class_2960.method_60654(s))
			.registerSerializer(class_2960.class, (i,m)->new JsonPrimitive(i.toString()))
			;
		
		//All the things you could potentially specify with just a registry ID
		//Note: specifically excludes dynamic registries since we can't have static access to them.
		register(builder, class_4168.class,                    class_7923.field_41132);
		register(builder, class_2314.class,          class_7923.field_41192);
		register(builder, class_2248.class,                       class_7923.field_41175);
		register(builder, class_2591.class,             class_7923.field_41181);
		register(builder, class_6647.class,          class_7923.field_41142);
		register(builder, class_4652.class,      class_7923.field_41149);
		register(builder, class_2939.class,                      class_7923.field_41143);
		register(builder, class_7375.class,                  class_7923.field_41163);
		register(builder, class_2806.class,                 class_7923.field_41184);
		register(builder, class_10134.class_10135.class,          class_7923.field_53967);
		register(builder, class_179.class,                   class_7923.field_47496);
		register(builder, class_1320.class,             class_7923.field_41190);
		register(builder, class_1299.class,                  class_7923.field_41177);
		register(builder, class_3031.class,                     class_7923.field_41144);
		register(builder, class_5202.class,             class_7923.field_41155);
		register(builder, class_5864.class,           class_7923.field_41139);
		register(builder, class_3611.class,                       class_7923.field_41173);
		register(builder, class_4648.class,           class_7923.field_41150);
		register(builder, class_7106.class,                 class_7923.field_41164);
		register(builder, class_5712.class,                   class_7923.field_41171);
		register(builder, class_6123.class,          class_7923.field_41141);
		register(builder, class_6018.class,             class_7923.field_41140);
		register(builder, class_1792.class,                        class_7923.field_41178);
		register(builder, class_1761.class,                   class_7923.field_44687);
		register(builder, class_9360.class_8745.class,       class_7923.field_49912);
		register(builder, class_5342.class,           class_7923.field_41135);
		register(builder, class_5339.class,            class_7923.field_41134);
		register(builder, class_5650.class,         class_7923.field_41137);
		register(builder, class_5657.class,      class_7923.field_41136);
		register(builder, class_5338.class,           class_7923.field_41133);
		register(builder, class_5669.class,       class_7923.field_41138);
		register(builder, class_9428.class,           class_7923.field_50078);
		register(builder, class_4140.class,            class_7923.field_41129);
		register(builder, class_9023.class,            class_7923.field_47555);
		register(builder, class_2396.class,                class_7923.field_41180);
		register(builder, class_6798.class,       class_7923.field_41148);
		register(builder, class_4158.class,         class_7923.field_41128);
		register(builder, class_5717.class,          class_7923.field_41191);
		register(builder, class_4996.class,             class_7923.field_41186);
		register(builder, class_1842.class,                      class_7923.field_41179);
		register(builder, class_10355.class,          class_7923.field_54927);
		register(builder, class_10295.class_10296.class,    class_7923.field_54874);
		register(builder, class_1865.class,            class_7923.field_41189);
		register(builder, class_3956.class,                  class_7923.field_41188);
		register(builder, class_7388.class,              class_7923.field_41152);
		register(builder, class_8249.class, class_7923.field_43381);
		register(builder, class_3827.class,                class_7923.field_41185);
		register(builder, class_4170.class,                    class_7923.field_41131);
		register(builder, class_3917.class,           class_7923.field_41187);
		register(builder, class_4149.class,                  class_7923.field_41130);
		register(builder, class_10302.class_10312.class,      class_7923.field_54873);
		register(builder, class_3414.class,                  class_7923.field_41172);
		register(builder, class_3448.class,                    class_7923.field_41193);
		register(builder, class_1291.class,                class_7923.field_41174);
		register(builder, class_6875.class,      class_7923.field_41145);
		register(builder, class_3773.class,          class_7923.field_41146);
		register(builder, class_3816.class,    class_7923.field_41162);
		register(builder, class_3828.class,      class_7923.field_41161);
		register(builder, class_7151.class,               class_7923.field_41147);
		register(builder, class_4663.class,           class_7923.field_41153);
		register(builder, class_5142.class,             class_7923.field_41151);
		register(builder, class_3852.class,          class_7923.field_41195);
		register(builder, class_3854.class,                class_7923.field_41194);
		register(builder, class_2378.class,                    class_7923.field_41167);
		
		return builder;
	}
	
	private static <T> void register(Jankson.Builder builder, Class<T> clazz, class_2378<? extends T> registry) {
		builder.registerDeserializer(String.class, clazz, (s,m)->lookupDeserialize(s, registry));
		builder.registerSerializer(clazz, (o,m)->lookupSerialize(o, registry));
	}
	
	private static <T> T lookupDeserialize(String s, class_2378<T> registry) {
		return registry.method_63535(class_2960.method_60654(s));
	}
	
	private static <T, U extends T> JsonElement lookupSerialize(T t, class_2378<U> registry) {
		@SuppressWarnings("unchecked") //Widening cast happening because of generic type parameters in the registry class
		class_2960 id = registry.method_10221((U)t);
		if (id==null) return JsonNull.INSTANCE;
		return new JsonPrimitive(id.toString());
	}
	
	
	public static Jankson createJankson() {
		return builder().build();
	}
	
}
