package io.github.cottonmc.cotton.gui.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import io.github.cottonmc.cotton.gui.impl.client.NinePatchTextureRendererImpl;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import juuxel.libninepatch.NinePatch;

import java.util.function.Consumer;

/**
 * Nine-patch background painters paint rectangles using a special nine-patch texture.
 * The texture is divided into nine sections: four corners, four edges and a center part.
 * The edges and the center are either tiled or stretched, depending on the mode of the painter,
 * to fill the area between the corners. By default, the texture is tiled.
 *
 * <p>Nine-patch background painters can be created using {@link BackgroundPainter#createNinePatch(class_2960)},
 * {@link #createNinePatch(Texture, Consumer)}, or with the constructor directly. The latter two let you customise
 * the look of the background more finely.
 *
 * <p>{@code NinePatchBackgroundPainter} has a customizable padding that can be applied.
 * By default there is no padding, but you can set it using {@link NinePatchBackgroundPainter#setPadding(int)}.
 *
 * @since 4.0.0
 */
@Environment(EnvType.CLIENT)
public final class NinePatchBackgroundPainter implements BackgroundPainter {
	private final NinePatch<class_2960> ninePatch;
	private int topPadding = 0;
	private int leftPadding = 0;
	private int bottomPadding = 0;
	private int rightPadding = 0;

	public NinePatchBackgroundPainter(NinePatch<class_2960> ninePatch) {
		this.ninePatch = ninePatch;
	}

	public int getTopPadding() {
		return topPadding;
	}

	public NinePatchBackgroundPainter setTopPadding(int topPadding) {
		this.topPadding = topPadding;
		return this;
	}

	public int getLeftPadding() {
		return leftPadding;
	}

	public NinePatchBackgroundPainter setLeftPadding(int leftPadding) {
		this.leftPadding = leftPadding;
		return this;
	}

	public int getBottomPadding() {
		return bottomPadding;
	}

	public NinePatchBackgroundPainter setBottomPadding(int bottomPadding) {
		this.bottomPadding = bottomPadding;
		return this;
	}

	public int getRightPadding() {
		return rightPadding;
	}

	public NinePatchBackgroundPainter setRightPadding(int rightPadding) {
		this.rightPadding = rightPadding;
		return this;
	}

	public NinePatchBackgroundPainter setPadding(int padding) {
		this.topPadding = this.leftPadding = this.bottomPadding = this.rightPadding = padding;
		return this;
	}

	public NinePatchBackgroundPainter setPadding(int vertical, int horizontal) {
		this.topPadding = this.bottomPadding = vertical;
		this.leftPadding = this.rightPadding = horizontal;
		return this;
	}

	public NinePatchBackgroundPainter setPadding(int topPadding, int leftPadding, int bottomPadding, int rightPadding) {
		this.topPadding = topPadding;
		this.leftPadding = leftPadding;
		this.bottomPadding = bottomPadding;
		this.rightPadding = rightPadding;

		return this;
	}

	@Override
	public void paintBackground(class_332 context, int left, int top, WWidget panel) {
		var matrices = context.method_51448();
		matrices.method_22903();
		matrices.method_46416(left - leftPadding, top - topPadding, 0);
		ninePatch.draw(NinePatchTextureRendererImpl.INSTANCE, context, panel.getWidth() + leftPadding + rightPadding, panel.getHeight() + topPadding + bottomPadding);
		matrices.method_22909();
	}
}
