/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import java.util.ArrayDeque;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public final class Scissors {
    private static final ArrayDeque<Frame> STACK = new ArrayDeque();

    private Scissors() {
    }

    public static Frame push(int x, int y, int width, int height) {
        return Scissors.push(null, x, y, width, height);
    }

    public static Frame push(@Nullable class_332 context, int x, int y, int width, int height) {
        Frame frame = new Frame(x, y, width, height, context);
        STACK.push(frame);
        if (context != null) {
            context.method_51452();
        }
        Scissors.refreshScissors();
        return frame;
    }

    public static void pop() {
        if (STACK.isEmpty()) {
            throw new IllegalStateException("No scissors on the stack!");
        }
        Frame frame = STACK.pop();
        if (frame.context != null) {
            frame.context.method_51452();
        }
        Scissors.refreshScissors();
    }

    static void refreshScissors() {
        class_310 mc = class_310.method_1551();
        if (STACK.isEmpty()) {
            GL11.glScissor((int)0, (int)0, (int)mc.method_22683().method_4489(), (int)mc.method_22683().method_4506());
            return;
        }
        int x = Integer.MIN_VALUE;
        int y = Integer.MIN_VALUE;
        int width = -1;
        int height = -1;
        for (Frame frame : STACK) {
            if (x < frame.x) {
                x = frame.x;
            }
            if (y < frame.y) {
                y = frame.y;
            }
            if (width == -1 || x + width > frame.x + frame.width) {
                width = frame.width - (x - frame.x);
            }
            if (height != -1 && y + height <= frame.y + frame.height) continue;
            height = frame.height - (y - frame.y);
        }
        int windowHeight = mc.method_22683().method_4506();
        double scale = mc.method_22683().method_4495();
        int scaledWidth = (int)((double)width * scale);
        int scaledHeight = (int)((double)height * scale);
        GL11.glScissor((int)((int)((double)x * scale)), (int)((int)((double)windowHeight - (double)y * scale - (double)scaledHeight)), (int)scaledWidth, (int)scaledHeight);
    }

    static void checkStackIsEmpty() {
        if (!STACK.isEmpty()) {
            throw new IllegalStateException("Unpopped scissor frames: " + STACK.stream().map(Frame::toString).collect(Collectors.joining(", ")));
        }
    }

    public static final class Frame
    implements AutoCloseable {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        @Nullable
        private final class_332 context;

        private Frame(int x, int y, int width, int height, @Nullable class_332 context) {
            if (width < 0) {
                throw new IllegalArgumentException("Negative width for a stack frame");
            }
            if (height < 0) {
                throw new IllegalArgumentException("Negative height for a stack frame");
            }
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.context = context;
        }

        @Override
        public void close() {
            if (STACK.peekLast() != this) {
                if (STACK.contains(this)) {
                    throw new IllegalStateException(String.valueOf(this) + " is not on top of the stack!");
                }
                throw new IllegalStateException(String.valueOf(this) + " is not on the stack!");
            }
            Scissors.pop();
        }

        public String toString() {
            return "Frame{ at = (" + this.x + ", " + this.y + "), size = (" + this.width + ", " + this.height + ") }";
        }
    }
}

