package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.FocusElements;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.impl.mixin.client.ScreenAccessor;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

/**
 * A screen for a {@link SyncedGuiDescription}.
 *
 * @param <T> the description type
 */
public class CottonInventoryScreen<T extends SyncedGuiDescription> extends class_465<T> implements CottonScreenImpl {
	private static final VisualLogger LOGGER = new VisualLogger(CottonInventoryScreen.class);
	protected SyncedGuiDescription description;
	@Nullable protected WWidget lastResponder = null;
	private final MouseInputHandler<CottonInventoryScreen<T>> mouseInputHandler = new MouseInputHandler<>(this);

	/**
	 * Constructs a new screen without a title.
	 *
	 * @param description the GUI description
	 * @param inventory   the player inventory
	 * @since 5.2.0
	 */
	public CottonInventoryScreen(T description, class_1661 inventory) {
		this(description, inventory, class_5244.field_39003);
	}

	/**
	 * Constructs a new screen.
	 *
	 * @param description the GUI description
	 * @param inventory   the player inventory
	 * @param title       the screen title
	 * @since 5.2.0
	 */
	public CottonInventoryScreen(T description, class_1661 inventory, class_2561 title) {
		super(description, inventory, title);
		this.description = description;
		field_22789 = 18*9;
		field_22790 = 18*9;
		this.field_2792 = 18*9;
		this.field_2779 = 18*9;
		description.getRootPanel().validate(description);
	}

	/**
	 * Constructs a new screen without a title.
	 *
	 * @param description the GUI description
	 * @param player     the player
	 */
	public CottonInventoryScreen(T description, class_1657 player) {
		this(description, player.method_31548());
	}

	/**
	 * Constructs a new screen.
	 *
	 * @param description the GUI description
	 * @param player      the player
	 * @param title       the screen title
	 */
	public CottonInventoryScreen(T description, class_1657 player, class_2561 title) {
		this(description, player.method_31548(), title);
	}
	
	/*
	 * RENDERING NOTES:
	 * 
	 * * "width" and "height" are the width and height of the overall screen
	 * * "backgroundWidth" and "backgroundHeight" are the width and height of the panel to render
	 * * ~~"left" and "top" are *actually* self-explanatory~~
	 *   * "left" and "top" are now (1.15) "x" and "y". A bit less self-explanatory, I guess.
	 * * coordinates start at 0,0 at the topleft of the screen.
	 */
	
	@Override
	public void method_25426() {
		super.method_25426();

		WPanel root = description.getRootPanel();
		if (root != null) root.addPainters();
		description.addPainters();
		
		reposition(field_22789, field_22790);

		if (root != null) {
			class_364 rootPanelElement = FocusElements.ofPanel(root);
			((ScreenAccessor) this).libgui$getChildren().add(rootPanelElement);
			method_48265(rootPanelElement);
		} else {
			LOGGER.warn("No root panel found, keyboard navigation disabled");
		}
	}

	@Override
	public void method_25432() {
		super.method_25432();
		VisualLogger.reset();
	}

	@ApiStatus.Internal
	@Override
	public GuiDescription getDescription() {
		return description;
	}

	@Nullable
	@Override
	public WWidget getLastResponder() {
		return lastResponder;
	}

	@Override
	public void setLastResponder(@Nullable WWidget lastResponder) {
		this.lastResponder = lastResponder;
	}

	/**
	 * Clears the heavyweight peers of this screen's GUI description.
	 */
	private void clearPeers() {
		description.field_7761.clear();
	}

	/**
	 * Repositions the root panel.
	 *
	 * @param screenWidth  the width of the screen
	 * @param screenHeight the height of the screen
	 */
	protected void reposition(int screenWidth, int screenHeight) {
		WPanel basePanel = description.getRootPanel();
		if (basePanel!=null) {
			clearPeers();
			basePanel.validate(description);

			field_2792 = basePanel.getWidth();
			field_2779 = basePanel.getHeight();
			
			//DEBUG
			if (field_2792<16) field_2792=300;
			if (field_2779<16) field_2779=300;
		}

		field_25267 = description.getTitlePos().x();
		field_25268 = description.getTitlePos().y();

		if (!description.isFullscreen()) {
			field_2776 = (screenWidth / 2) - (field_2792 / 2);
			field_2800 = (screenHeight / 2) - (field_2779 / 2);
		} else {
			field_2776 = 0;
			field_2800 = 0;

			if (basePanel != null) {
				basePanel.setSize(screenWidth, screenHeight);
			}
		}
	}
	
	@Override
	public boolean method_25421() {
		//...yeah, we're going to go ahead and override that.
		return false;
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
		super.method_25402(mouseX, mouseY, mouseButton);

		int containerX = (int)mouseX-field_2776;
		int containerY = (int)mouseY-field_2800;
		mouseInputHandler.checkFocus(containerX, containerY);
		if (containerX<0 || containerY<0 || containerX>=field_22789 || containerY>=field_22790) return true;
		mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);

		return true;
	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
		super.method_25406(mouseX, mouseY, mouseButton);

		int containerX = (int)mouseX-field_2776;
		int containerY = (int)mouseY-field_2800;
		mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);

		return true;
	}

	@Override
	public boolean method_25403(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
		super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);

		int containerX = (int)mouseX-field_2776;
		int containerY = (int)mouseY-field_2800;
		mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);

		return true;
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);

		int containerX = (int)mouseX-field_2776;
		int containerY = (int)mouseY-field_2800;
		mouseInputHandler.onMouseScroll(containerX, containerY, horizontalAmount, verticalAmount);

		return true;
	}

	@Override
	public void method_16014(double mouseX, double mouseY) {
		super.method_16014(mouseX, mouseY);

		int containerX = (int)mouseX-field_2776;
		int containerY = (int)mouseY-field_2800;
		mouseInputHandler.onMouseMove(containerX, containerY);
	}

	@Override
	public boolean method_25400(char ch, int keyCode) {
		WWidget focus = description.getFocus();
		if (focus != null && focus.onCharTyped(ch) == InputResult.PROCESSED) {
			return true;
		}

		return super.method_25400(ch, keyCode);
	}

	@Override
	public boolean method_25404(int ch, int keyCode, int modifiers) {
		WWidget focus = description.getFocus();
		if (focus != null && focus.onKeyPressed(ch, keyCode, modifiers) == InputResult.PROCESSED) {
			return true;
		}

		return super.method_25404(ch, keyCode, modifiers);
	}

	@Override
	public boolean method_16803(int ch, int keyCode, int modifiers) {
		WWidget focus = description.getFocus();
		if (focus != null && focus.onKeyReleased(ch, keyCode, modifiers) == InputResult.PROCESSED) {
			return true;
		}

		return super.method_16803(ch, keyCode, modifiers);
	}

	@Override
	protected void method_2389(class_332 context, float partialTicks, int mouseX, int mouseY) {} //This is just an AbstractContainerScreen thing; most Screens don't work this way.

	/**
	 * Paints the GUI description of this screen.
	 *
	 * @param context the draw context
	 * @param mouseX  the absolute X coordinate of the mouse cursor
	 * @param mouseY  the absolute Y coordinate of the mouse cursor
	 * @param delta   the tick delta
	 * @since 9.2.0
	 */
	public void paintDescription(class_332 context, int mouseX, int mouseY, float delta) {
		if (description!=null) {
			WPanel root = description.getRootPanel();
			if (root!=null) {
				GL11.glEnable(GL11.GL_SCISSOR_TEST);
				Scissors.refreshScissors();
				root.paint(context, field_2776, field_2800, mouseX-field_2776, mouseY-field_2800);
				GL11.glDisable(GL11.GL_SCISSOR_TEST);
				Scissors.checkStackIsEmpty();
			}
		}
	}
	
	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(context, mouseX, mouseY, partialTicks);
		class_308.method_24210(); //Needed because super.render leaves dirty state
		
		if (description!=null) {
			WPanel root = description.getRootPanel();
			if (root!=null) {
				WWidget hitChild = root.hit(mouseX-field_2776, mouseY-field_2800);
				if (hitChild!=null) hitChild.renderTooltip(context, field_2776, field_2800, mouseX-field_2776, mouseY-field_2800);
			}
		}
		
		method_2380(context, mouseX, mouseY); //Draws the itemstack tooltips
		VisualLogger.render(context);
	}

	@Override
	protected void method_2388(class_332 context, int mouseX, int mouseY) {
		if (description != null && description.isTitleVisible()) {
			int width = description.getRootPanel().getWidth();
			ScreenDrawing.drawString(context, method_25440().method_30937(), description.getTitleAlignment(), field_25267, field_25268, width - 2 * field_25267, description.getTitleColor());
		}

		// Don't draw the player inventory label as it's drawn by the widget itself
	}

	@Override
	protected void method_37432() {
		super.method_37432();
		if (description!=null) {
			WPanel root = description.getRootPanel();
			if (root!=null) {
				root.tick();
			}
		}
	}

	@Override
	protected void method_37056(class_6382 builder) {
		if (description != null) NarrationHelper.addNarrations(description.getRootPanel(), builder);
	}
}
