package io.github.cottonmc.cotton.gui.impl.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.mixin.client.DrawContextAccessor;
import juuxel.libninepatch.ContextualTextureRenderer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4573;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

/**
 * An implementation of LibNinePatch's {@link ContextualTextureRenderer} for identifiers.
 */
public enum NinePatchTextureRendererImpl implements ContextualTextureRenderer<class_2960, class_332> {
	INSTANCE;

	@Override
	public void draw(class_2960 texture, class_332 context, int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
		ScreenDrawing.texturedRect(context, x, y, width, height, texture, u1, v1, u2, v2, 0xFF_FFFFFF);
	}

	@Override
	public void drawTiled(class_2960 texture, class_332 context, int x, int y, int regionWidth, int regionHeight, int tileWidth, int tileHeight, float u1, float v1, float u2, float v2) {
		Matrix4f positionMatrix = context.method_51448().method_23760().method_23761();
		onRenderThread(() -> {
			@Nullable class_5944 program = RenderSystem.getShader();
			if (program != null) {
				program.method_35785("LibGuiRectanglePos").method_1255((float) x, (float) y);
				program.method_35785("LibGuiTileDimensions").method_1255((float) tileWidth, (float) tileHeight);
				program.method_35785("LibGuiTileUvs").method_35657(u1, v1, u2, v2);
				program.method_35785("LibGuiPositionMatrix").method_1250(positionMatrix);
			}
		});

		RenderSystem.setShaderColor(1, 1, 1, 1);
		var renderLayer = LibGuiShaders.TILED_RECTANGLE_LAYER.apply(texture);
		var buffer = ((DrawContextAccessor) context).libgui$getVertexConsumers().getBuffer(renderLayer);
		buffer.method_22918(positionMatrix, x, y, 0);
		buffer.method_22918(positionMatrix, x, y + regionHeight, 0);
		buffer.method_22918(positionMatrix, x + regionWidth, y + regionHeight, 0);
		buffer.method_22918(positionMatrix, x + regionWidth, y, 0);
		context.method_51452();
	}

	private static void onRenderThread(class_4573 renderCall) {
		if (RenderSystem.isOnRenderThread()) {
			renderCall.execute();
		} else {
			RenderSystem.recordRenderCall(renderCall);
		}
	}
}
