/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.client.NinePatchBackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import java.util.Objects;
import java.util.function.Consumer;
import juuxel.libninepatch.NinePatch;
import juuxel.libninepatch.TextureRegion;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@FunctionalInterface
public interface BackgroundPainter {
    public static final BackgroundPainter VANILLA = BackgroundPainter.createLightDarkVariants(BackgroundPainter.createGuiSprite(LibGuiCommon.id("widget/panel_light")), BackgroundPainter.createGuiSprite(LibGuiCommon.id("widget/panel_dark")));
    public static final BackgroundPainter SLOT = (context, left, top, panel) -> {
        if (!(panel instanceof WItemSlot)) {
            ScreenDrawing.drawBeveledPanel(context, left - 1, top - 1, panel.getWidth() + 2, panel.getHeight() + 2, -1207959552, 0x4C000000, -1191182337);
        } else {
            WItemSlot slot = (WItemSlot)panel;
            for (int x = 0; x < slot.getWidth() / 18; ++x) {
                for (int y = 0; y < slot.getHeight() / 18; ++y) {
                    int sy;
                    int sx;
                    int index = x + y * (slot.getWidth() / 18);
                    float px = 0.015625f;
                    if (slot.isBigSlot()) {
                        sx = x * 18 + left - 4;
                        sy = y * 18 + top - 4;
                        ScreenDrawing.texturedRect(context, sx, sy, 26, 26, WItemSlot.SLOT_TEXTURE, 18.0f * px, 0.0f, 44.0f * px, 26.0f * px, -1);
                        if (slot.getFocusedSlot() != index) continue;
                        ScreenDrawing.texturedRect(context, sx, sy, 26, 26, WItemSlot.SLOT_TEXTURE, 18.0f * px, 26.0f * px, 44.0f * px, 52.0f * px, -1);
                        continue;
                    }
                    sx = x * 18 + left;
                    sy = y * 18 + top;
                    ScreenDrawing.texturedRect(context, sx, sy, 18, 18, WItemSlot.SLOT_TEXTURE, 0.0f, 0.0f, 18.0f * px, 18.0f * px, -1);
                    if (slot.getFocusedSlot() != index) continue;
                    ScreenDrawing.texturedRect(context, sx, sy, 18, 18, WItemSlot.SLOT_TEXTURE, 0.0f, 26.0f * px, 18.0f * px, 44.0f * px, -1);
                }
            }
        }
    };

    public void paintBackground(class_332 var1, int var2, int var3, WWidget var4);

    public static BackgroundPainter createColorful(int panelColor) {
        return (context, left, top, panel) -> ScreenDrawing.drawGuiPanel(context, left, top, panel.getWidth(), panel.getHeight(), panelColor);
    }

    public static BackgroundPainter createColorful(int panelColor, float contrast) {
        return (context, left, top, panel) -> {
            int shadowColor = ScreenDrawing.multiplyColor(panelColor, 1.0f - contrast);
            int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.0f + contrast);
            ScreenDrawing.drawGuiPanel(context, left, top, panel.getWidth(), panel.getHeight(), shadowColor, panelColor, hilightColor, -16777216);
        };
    }

    public static NinePatchBackgroundPainter createNinePatch(class_2960 texture) {
        return BackgroundPainter.createNinePatch(new Texture(texture), builder -> builder.cornerSize(4).cornerUv(0.25f));
    }

    public static NinePatchBackgroundPainter createNinePatch(Texture texture, Consumer<NinePatch.Builder<class_2960>> configurator) {
        if (texture.type() != Texture.Type.STANDALONE) {
            throw new IllegalArgumentException("Non-standalone texture " + String.valueOf(texture) + " cannot be used for nine-patch");
        }
        TextureRegion region = new TextureRegion((Object)texture.image(), texture.u1(), texture.v1(), texture.u2(), texture.v2());
        NinePatch.Builder builder = NinePatch.builder((TextureRegion)region);
        configurator.accept((NinePatch.Builder<class_2960>)builder);
        return new NinePatchBackgroundPainter((NinePatch<class_2960>)builder.build());
    }

    public static BackgroundPainter createLightDarkVariants(BackgroundPainter light, BackgroundPainter dark) {
        return (context, left, top, panel) -> {
            if (panel.shouldRenderInDarkMode()) {
                dark.paintBackground(context, left, top, panel);
            } else {
                light.paintBackground(context, left, top, panel);
            }
        };
    }

    public static BackgroundPainter createGuiSprite(class_2960 texture) {
        Objects.requireNonNull(texture, "Texture cannot be null");
        return (context, left, top, panel) -> context.method_52706(class_1921::method_62277, texture, left, top, panel.getWidth(), panel.getHeight());
    }
}

