/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.impl.client.WidgetTextures;
import io.github.cottonmc.cotton.gui.impl.mixin.client.SliderWidgetAccessor;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7833;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class WLabeledSlider
extends WAbstractSlider {
    @Nullable
    private class_2561 label = null;
    @Nullable
    private LabelUpdater labelUpdater = null;
    private HorizontalAlignment labelAlignment = HorizontalAlignment.CENTER;

    public WLabeledSlider(int min, int max) {
        this(min, max, Axis.HORIZONTAL);
    }

    public WLabeledSlider(int min, int max, Axis axis) {
        super(min, max, axis);
    }

    public WLabeledSlider(int min, int max, Axis axis, @Nullable class_2561 label) {
        this(min, max, axis);
        this.label = label;
    }

    public WLabeledSlider(int min, int max, @Nullable class_2561 label) {
        this(min, max);
        this.label = label;
    }

    @Nullable
    public class_2561 getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable class_2561 label) {
        this.label = label;
    }

    @Override
    protected void onValueChanged(int value) {
        super.onValueChanged(value);
        if (this.labelUpdater != null) {
            this.label = this.labelUpdater.updateLabel(value);
        }
    }

    public HorizontalAlignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(HorizontalAlignment labelAlignment) {
        this.labelAlignment = labelAlignment;
    }

    @Nullable
    public LabelUpdater getLabelUpdater() {
        return this.labelUpdater;
    }

    public void setLabelUpdater(@Nullable LabelUpdater labelUpdater) {
        this.labelUpdater = labelUpdater;
    }

    @Override
    protected int getThumbWidth() {
        return 8;
    }

    @Override
    protected boolean isMouseInsideBounds(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        int aHeight;
        int aWidth = this.axis == Axis.HORIZONTAL ? this.width : this.height;
        int n = aHeight = this.axis == Axis.HORIZONTAL ? this.height : this.width;
        int rotMouseX = this.axis == Axis.HORIZONTAL ? (this.direction == WAbstractSlider.Direction.LEFT ? this.width - mouseX : mouseX) : (this.direction == WAbstractSlider.Direction.UP ? this.height - mouseY : mouseY);
        int rotMouseY = this.axis == Axis.HORIZONTAL ? mouseY : mouseX;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 0.0f);
        if (this.axis == Axis.VERTICAL) {
            matrices.method_46416(0.0f, (float)this.height, 0.0f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(270.0f));
        }
        context.method_52706(class_1921::method_62277, SliderWidgetAccessor.libgui$getTexture(), 0, 0, aWidth, aHeight);
        int thumbX = Math.round(this.coordToValueRatio * (float)(this.value - this.min));
        int thumbY = 0;
        int thumbWidth = this.getThumbWidth();
        int thumbHeight = aHeight;
        boolean hovering = rotMouseX >= thumbX && rotMouseX <= thumbX + thumbWidth && rotMouseY >= thumbY && rotMouseY <= thumbY + thumbHeight;
        class_8666 thumbTextures = WidgetTextures.getLabeledSliderHandleTextures(this.shouldRenderInDarkMode());
        class_2960 thumbTexture = thumbTextures.method_52729(true, this.dragging || hovering);
        context.method_52706(class_1921::method_62277, thumbTexture, thumbX, thumbY, thumbWidth, thumbHeight);
        if (this.label != null) {
            int color = this.isMouseInsideBounds(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
            ScreenDrawing.drawStringWithShadow(context, this.label.method_30937(), this.labelAlignment, 2, aHeight / 2 - 4, aWidth - 4, color);
        }
        matrices.method_22909();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
        if (this.getLabel() != null) {
            builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"widget.libgui.labeled_slider.narration.title", (Object[])new Object[]{this.getLabel(), this.value, this.min, this.max}));
            builder.method_37034(class_6381.field_33791, NarrationMessages.SLIDER_USAGE);
        } else {
            super.addNarrations(builder);
        }
    }

    @FunctionalInterface
    public static interface LabelUpdater {
        public class_2561 updateLabel(int var1);
    }
}

