/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.CottonInventoryScreen;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.FocusElements;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.impl.mixin.client.ScreenAccessor;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonClientScreen
extends class_437
implements CottonScreenImpl {
    private static final VisualLogger LOGGER = new VisualLogger(CottonInventoryScreen.class);
    protected GuiDescription description;
    protected int left = 0;
    protected int top = 0;
    protected int titleX;
    protected int titleY;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonClientScreen> mouseInputHandler = new MouseInputHandler<CottonClientScreen>(this);

    public CottonClientScreen(GuiDescription description) {
        this(class_5244.field_39003, description);
    }

    public CottonClientScreen(class_2561 title, GuiDescription description) {
        super(title);
        this.description = description;
        description.getRootPanel().validate(description);
    }

    @Override
    public GuiDescription getDescription() {
        return this.description;
    }

    public void method_25426() {
        super.method_25426();
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.field_22789, this.field_22790);
        if (root != null) {
            FocusElements.PanelFocusElement rootPanelElement = FocusElements.ofPanel(root);
            ((ScreenAccessor)((Object)this)).libgui$getChildren().add(rootPanelElement);
            this.method_48265(rootPanelElement);
        } else {
            LOGGER.warn("No root panel found, keyboard navigation disabled", new Object[0]);
        }
    }

    public void method_25432() {
        super.method_25432();
        VisualLogger.reset();
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel root;
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            this.titleX = this.description.getTitlePos().x();
            this.titleY = this.description.getTitlePos().y();
            if (!this.description.isFullscreen()) {
                this.left = (screenWidth - root.getWidth()) / 2;
                this.top = (screenHeight - root.getHeight()) / 2;
            } else {
                this.left = 0;
                this.top = 0;
                root.setSize(screenWidth, screenHeight);
            }
        }
    }

    private void paint(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.description != null) {
            WPanel root = this.description.getRootPanel();
            if (root != null) {
                GL11.glEnable((int)3089);
                Scissors.refreshScissors();
                root.paint(context, this.left, this.top, mouseX - this.left, mouseY - this.top);
                GL11.glDisable((int)3089);
                Scissors.checkStackIsEmpty();
            }
            if (this.method_25440() != null && this.description.isTitleVisible()) {
                int width = this.description.getRootPanel().getWidth();
                ScreenDrawing.drawString(context, this.method_25440().method_30937(), this.description.getTitleAlignment(), this.left + this.titleX, this.top + this.titleY, width - 2 * this.titleX, this.description.getTitleColor());
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        super.method_25394(context, mouseX, mouseY, partialTicks);
        this.paint(context, mouseX, mouseY, partialTicks);
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.left, mouseY - this.top)) != null) {
            hitChild.renderTooltip(context, this.left, this.top, mouseX - this.left, mouseY - this.top);
        }
        VisualLogger.render(context);
    }

    public void method_25393() {
        WPanel root;
        super.method_25393();
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            root.tick();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        super.method_25402(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.checkFocus(containerX, containerY);
        if (containerX < 0 || containerY < 0 || containerX >= this.field_22789 || containerY >= this.field_22790) {
            return true;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        super.method_25406(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, horizontalAmount, verticalAmount);
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    public boolean method_25400(char ch, int keyCode) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onCharTyped(ch) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_25400(ch, keyCode);
    }

    public boolean method_25404(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyPressed(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_25404(ch, keyCode, modifiers);
    }

    public boolean method_16803(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyReleased(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_16803(ch, keyCode, modifiers);
    }

    protected void method_37056(class_6382 builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }
}

