/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.mixin.client.TextFieldWidgetAccessor;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WTextField
extends WWidget {
    public static final int TEXT_PADDING_X = 4;
    public static final int TEXT_PADDING_Y = 6;
    public static final int CURSOR_PADDING_Y = 4;
    public static final int CURSOR_HEIGHT = 12;
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private class_327 textRenderer;
    private String text = "";
    private int maxLength = 16;
    private boolean editable = true;
    private int tickCount = 0;
    private int disabledColor = 0x707070;
    private int enabledColor = 0xE0E0E0;
    private int suggestionColor = 0x808080;
    private static final int CURSOR_COLOR = -3092272;
    @Nullable
    private class_2561 suggestion = null;
    private int scrollOffset = 0;
    private int cursor = 0;
    private int select = -1;
    private Consumer<String> onChanged;
    private Predicate<String> textPredicate;

    public WTextField() {
    }

    public WTextField(class_2561 suggestion) {
        this.suggestion = suggestion;
    }

    public void setText(String s) {
        this.setTextWithResult(s);
    }

    private boolean setTextWithResult(String s) {
        if (this.textPredicate == null || this.textPredicate.test(s)) {
            String string = this.text = s.length() > this.maxLength ? s.substring(0, this.maxLength) : s;
            if (this.onChanged != null) {
                this.onChanged.accept(this.text);
            }
            this.cursor = this.clampCursor(this.cursor);
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tickCount;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    private int clampCursor(int cursor) {
        return class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorPos(int location) {
        this.cursor = this.clampCursor(location);
        this.scrollCursorIntoView();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.cursor;
    }

    @Environment(value=EnvType.CLIENT)
    private class_327 getTextRenderer() {
        return this.textRenderer != null ? this.textRenderer : (this.textRenderer = class_310.method_1551().field_1772);
    }

    @Environment(value=EnvType.CLIENT)
    public void scrollCursorIntoView() {
        class_327 font = this.getTextRenderer();
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor && font.method_27523(this.text.substring(this.scrollOffset), this.width - 8).length() + this.scrollOffset < this.cursor) {
            this.scrollOffset = this.cursor;
        }
        this.checkScrollOffset();
    }

    @Environment(value=EnvType.CLIENT)
    private void checkScrollOffset() {
        int rightMostScrollOffset = this.text.length() - this.getTextRenderer().method_27524(this.text, this.width - 8, true).length();
        this.scrollOffset = Math.min(rightMostScrollOffset, this.scrollOffset);
    }

    @Nullable
    public String getSelection() {
        if (this.select < 0) {
            return null;
        }
        if (this.select == this.cursor) {
            return null;
        }
        if (this.select > this.text.length()) {
            this.select = this.text.length();
        }
        this.cursor = this.clampCursor(this.cursor);
        int start = Math.min(this.select, this.cursor);
        int end = Math.max(this.select, this.cursor);
        return this.text.substring(start, end);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderBox(class_332 context, int x, int y) {
        class_2960 texture = TextFieldWidgetAccessor.libgui$getTextures().method_52729(this.isEditable(), this.isFocused());
        context.method_52706(class_1921::method_62277, texture, x - 1, y - 1, this.width + 2, this.height + 2);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderText(class_332 context, int x, int y, String visibleText) {
        int textColor = this.editable ? this.enabledColor : this.disabledColor;
        context.method_51433(this.getTextRenderer(), visibleText, x + 4, y + 6, textColor, true);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderCursor(class_332 context, int x, int y, String visibleText) {
        if (this.tickCount / 6 % 2 == 0) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        if (this.cursor > this.scrollOffset + visibleText.length()) {
            return;
        }
        int cursorOffset = this.getTextRenderer().method_1727(visibleText.substring(0, this.cursor - this.scrollOffset));
        ScreenDrawing.coloredRect(context, x + 4 + cursorOffset, y + 4, 1, 12, -3092272);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderSuggestion(class_332 context, int x, int y) {
        if (this.suggestion == null) {
            return;
        }
        context.method_51439(this.getTextRenderer(), this.suggestion, x + 4, y + 6, this.suggestionColor, true);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderSelection(class_332 context, int x, int y, String visibleText) {
        if (this.select == this.cursor || this.select == -1) {
            return;
        }
        int textLength = visibleText.length();
        int left = Math.min(this.cursor, this.select);
        int right = Math.max(this.cursor, this.select);
        if (right < this.scrollOffset || left > this.scrollOffset + textLength) {
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        int normalizedRight = Math.min(this.scrollOffset + textLength, right) - this.scrollOffset;
        class_327 font = this.getTextRenderer();
        int leftCaret = font.method_1727(visibleText.substring(0, normalizedLeft));
        int selectionWidth = font.method_1727(visibleText.substring(normalizedLeft, normalizedRight));
        this.drawHighlight(context, x + 4 + leftCaret, y + 4, selectionWidth, 12);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderTextField(class_332 context, int x, int y) {
        this.checkScrollOffset();
        String visibleText = this.getTextRenderer().method_27523(this.text.substring(this.scrollOffset), this.width - 8);
        this.renderBox(context, x, y);
        this.renderText(context, x, y, visibleText);
        if (this.text.isEmpty() && !this.isFocused()) {
            this.renderSuggestion(context, x, y);
        }
        if (this.isFocused()) {
            this.renderCursor(context, x, y, visibleText);
        }
        this.renderSelection(context, x, y, visibleText);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawHighlight(class_332 context, int x, int y, int width, int height) {
        context.method_51739(class_1921.method_51786(), x, y, x + width, y + height, -16776961);
    }

    public WTextField setTextPredicate(Predicate<String> predicate_1) {
        this.textPredicate = predicate_1;
        return this;
    }

    public WTextField setChangedListener(Consumer<String> listener) {
        this.onChanged = listener;
        return this;
    }

    public WTextField setMaxLength(int max) {
        this.maxLength = max;
        if (this.text.length() > max) {
            this.setText(this.text.substring(0, max));
        }
        return this;
    }

    public WTextField setEnabledColor(int col) {
        this.enabledColor = col;
        return this;
    }

    public WTextField setSuggestionColor(int suggestionColor) {
        this.suggestionColor = suggestionColor;
        return this;
    }

    public WTextField setDisabledColor(int col) {
        this.disabledColor = col;
        return this;
    }

    public WTextField setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Nullable
    public class_2561 getSuggestion() {
        return this.suggestion;
    }

    public WTextField setSuggestion(@Nullable class_2561 suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public void onFocusGained() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        this.renderTextField(context, x, y);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        this.requestFocus();
        this.cursor = this.getCaretPosition(x - 4);
        this.scrollCursorIntoView();
        return InputResult.PROCESSED;
    }

    @Environment(value=EnvType.CLIENT)
    public int getCaretPosition(int clickX) {
        if (clickX < 0) {
            return 0;
        }
        int lastPos = 0;
        this.checkScrollOffset();
        String string = this.text.substring(this.scrollOffset);
        class_327 font = this.getTextRenderer();
        for (int i = 0; i < string.length(); ++i) {
            int w = font.method_1727("" + string.charAt(i));
            if (lastPos + w >= clickX && clickX - lastPos < w / 2) {
                return i + this.scrollOffset;
            }
            lastPos += w;
        }
        return string.length();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onCharTyped(char ch) {
        if (!this.isEditable()) {
            return InputResult.IGNORED;
        }
        this.insertText("" + ch);
        return InputResult.PROCESSED;
    }

    @Environment(value=EnvType.CLIENT)
    private void insertText(String toInsert) {
        String after;
        String before;
        if (this.select != -1 && this.select != this.cursor) {
            int left = Math.min(this.cursor, this.select);
            int right = Math.max(this.cursor, this.select);
            before = this.text.substring(0, left);
            after = this.text.substring(right);
        } else {
            before = this.text.substring(0, this.cursor);
            after = this.text.substring(this.cursor);
        }
        if (before.length() + after.length() + toInsert.length() > this.maxLength) {
            return;
        }
        if (this.setTextWithResult(before + toInsert + after)) {
            this.select = -1;
            this.cursor = (before + toInsert).length();
            this.scrollCursorIntoView();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void copySelection() {
        String selection = this.getSelection();
        if (selection != null) {
            class_310.method_1551().field_1774.method_1455(selection);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void paste() {
        String clip = class_310.method_1551().field_1774.method_1460();
        this.insertText(clip);
    }

    @Environment(value=EnvType.CLIENT)
    private void deleteSelection() {
        int left = Math.min(this.cursor, this.select);
        int right = Math.max(this.cursor, this.select);
        if (this.setTextWithResult(this.text.substring(0, left) + this.text.substring(right))) {
            this.select = -1;
            this.cursor = this.clampCursor(left);
            this.scrollCursorIntoView();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void delete(int modifiers, boolean backwards) {
        if (this.select == -1 || this.select == this.cursor) {
            this.select = this.skipCharacters((2 & modifiers) != 0, backwards ? -1 : 1);
        }
        this.deleteSelection();
    }

    @Environment(value=EnvType.CLIENT)
    private int skipCharacters(boolean skipMany, int direction) {
        if (direction != -1 && direction != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += direction) < 0) {
                return 0;
            }
            if (position > this.text.length()) {
                return this.text.length();
            }
            if (skipMany) continue;
            return position;
        } while (position >= this.text.length() || !Character.isWhitespace(this.text.charAt(position)));
        return position;
    }

    @Environment(value=EnvType.CLIENT)
    public void onDirectionalKey(int direction, int modifiers) {
        if ((1 & modifiers) != 0) {
            if (this.select == -1 || this.select == this.cursor) {
                this.select = this.cursor;
            }
            this.cursor = this.skipCharacters((2 & modifiers) != 0, direction);
        } else if (this.select != -1) {
            this.cursor = direction < 0 ? Math.min(this.cursor, this.select) : Math.max(this.cursor, this.select);
            this.select = -1;
        } else {
            this.cursor = this.skipCharacters((2 & modifiers) != 0, direction);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (!this.isEditable()) {
            return InputResult.IGNORED;
        }
        if (class_437.method_25438((int)ch)) {
            this.copySelection();
            return InputResult.PROCESSED;
        }
        if (class_437.method_25437((int)ch)) {
            this.paste();
            return InputResult.PROCESSED;
        }
        if (class_437.method_25439((int)ch)) {
            this.select = 0;
            this.cursor = this.text.length();
            return InputResult.PROCESSED;
        }
        switch (ch) {
            case 261: {
                this.delete(modifiers, false);
                break;
            }
            case 259: {
                this.delete(modifiers, true);
                break;
            }
            case 263: {
                this.onDirectionalKey(-1, modifiers);
                break;
            }
            case 262: {
                this.onDirectionalKey(1, modifiers);
                break;
            }
            case 265: 
            case 268: {
                if ((1 & modifiers) == 0) {
                    this.select = -1;
                }
                this.cursor = 0;
                break;
            }
            case 264: 
            case 269: {
                if ((1 & modifiers) == 0) {
                    this.select = -1;
                }
                this.cursor = this.text.length();
                break;
            }
            default: {
                return InputResult.IGNORED;
            }
        }
        this.scrollCursorIntoView();
        return InputResult.PROCESSED;
    }

    @Override
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"widget.libgui.text_field.narration.title", (Object[])new Object[]{this.text}));
        if (this.suggestion != null) {
            builder.method_37034(class_6381.field_33790, (class_2561)class_2561.method_43469((String)"widget.libgui.text_field.narration.suggestion", (Object[])new Object[]{this.suggestion}));
        }
    }
}

