/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import com.mojang.datafixers.util.Unit;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.ScreenNetworkingImpl;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.FocusElements;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.impl.mixin.client.ScreenAccessor;
import io.github.cottonmc.cotton.gui.networking.NetworkSide;
import io.github.cottonmc.cotton.gui.networking.ScreenNetworking;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonInventoryScreen<T extends SyncedGuiDescription>
extends class_465<T>
implements CottonScreenImpl {
    private static final VisualLogger LOGGER = new VisualLogger(CottonInventoryScreen.class);
    protected SyncedGuiDescription description;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonInventoryScreen<T>> mouseInputHandler = new MouseInputHandler<CottonInventoryScreen>(this);

    public CottonInventoryScreen(T description, class_1661 inventory) {
        this(description, inventory, class_5244.field_39003);
    }

    public CottonInventoryScreen(T description, class_1661 inventory, class_2561 title) {
        super(description, inventory, title);
        this.description = description;
        this.field_22789 = 162;
        this.field_22790 = 162;
        this.field_2792 = 162;
        this.field_2779 = 162;
        ((SyncedGuiDescription)description).getRootPanel().validate((GuiDescription)description);
    }

    public CottonInventoryScreen(T description, class_1657 player) {
        this(description, player.method_31548());
    }

    public CottonInventoryScreen(T description, class_1657 player, class_2561 title) {
        this(description, player.method_31548(), title);
    }

    public void method_25426() {
        super.method_25426();
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.field_22789, this.field_22790);
        if (root != null) {
            FocusElements.PanelFocusElement rootPanelElement = FocusElements.ofPanel(root);
            ((ScreenAccessor)((Object)this)).libgui$getChildren().add(rootPanelElement);
            this.method_48265(rootPanelElement);
        } else {
            LOGGER.warn("No root panel found, keyboard navigation disabled", new Object[0]);
        }
    }

    public void method_25432() {
        super.method_25432();
        VisualLogger.reset();
    }

    @Override
    @ApiStatus.Internal
    public GuiDescription getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    private void clearPeers() {
        this.description.field_7761.clear();
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel basePanel = this.description.getRootPanel();
        if (basePanel != null) {
            this.clearPeers();
            basePanel.validate(this.description);
            this.field_2792 = basePanel.getWidth();
            this.field_2779 = basePanel.getHeight();
            if (this.field_2792 < 16) {
                this.field_2792 = 300;
            }
            if (this.field_2779 < 16) {
                this.field_2779 = 300;
            }
        }
        this.field_25267 = this.description.getTitlePos().x();
        this.field_25268 = this.description.getTitlePos().y();
        if (!this.description.isFullscreen()) {
            this.field_2776 = screenWidth / 2 - this.field_2792 / 2;
            this.field_2800 = screenHeight / 2 - this.field_2779 / 2;
        } else {
            this.field_2776 = 0;
            this.field_2800 = 0;
            if (basePanel != null) {
                basePanel.setSize(screenWidth, screenHeight);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        super.method_25402(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.checkFocus(containerX, containerY);
        if (containerX < 0 || containerY < 0 || containerX >= this.field_22789 || containerY >= this.field_22790) {
            return true;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        super.method_25406(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, horizontalAmount, verticalAmount);
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        int containerX = (int)mouseX - this.field_2776;
        int containerY = (int)mouseY - this.field_2800;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    public boolean method_25400(char ch, int keyCode) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onCharTyped(ch) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_25400(ch, keyCode);
    }

    public boolean method_25404(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyPressed(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_25404(ch, keyCode, modifiers);
    }

    public boolean method_16803(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyReleased(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.method_16803(ch, keyCode, modifiers);
    }

    protected void method_2389(class_332 context, float partialTicks, int mouseX, int mouseY) {
    }

    public void paintDescription(class_332 context, int mouseX, int mouseY, float delta) {
        WPanel root;
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            GL11.glEnable((int)3089);
            Scissors.refreshScissors();
            root.paint(context, this.field_2776, this.field_2800, mouseX - this.field_2776, mouseY - this.field_2800);
            GL11.glDisable((int)3089);
            Scissors.checkStackIsEmpty();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        super.method_25394(context, mouseX, mouseY, partialTicks);
        class_308.method_24210();
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.field_2776, mouseY - this.field_2800)) != null) {
            hitChild.renderTooltip(context, this.field_2776, this.field_2800, mouseX - this.field_2776, mouseY - this.field_2800);
        }
        this.method_2380(context, mouseX, mouseY);
        VisualLogger.render(context);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        if (this.description != null && this.description.isTitleVisible()) {
            int width = this.description.getRootPanel().getWidth();
            ScreenDrawing.drawString(context, this.method_25440().method_30937(), this.description.getTitleAlignment(), this.field_25267, this.field_25268, width - 2 * this.field_25267, this.description.getTitleColor());
        }
    }

    protected void method_37432() {
        super.method_37432();
        if (this.description != null) {
            WPanel root = this.description.getRootPanel();
            if (root != null) {
                root.tick();
            }
            this.description.sendDataSlotUpdates();
        }
    }

    protected void method_37056(class_6382 builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }

    public void method_49589() {
        if (this.description != null) {
            ScreenNetworking networking = this.description.getNetworking(NetworkSide.CLIENT);
            ((ScreenNetworkingImpl)networking).markReady();
            networking.send(ScreenNetworkingImpl.CLIENT_READY_MESSAGE_KEY, Unit.INSTANCE);
        }
    }
}

