/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WScrollBar;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_332;

public class WScrollPanel
extends WPanel {
    private static final int SCROLL_BAR_SIZE = 8;
    private final WWidget widget;
    private TriState scrollingHorizontally = TriState.DEFAULT;
    private TriState scrollingVertically = TriState.DEFAULT;
    protected WScrollBar horizontalScrollBar = new WScrollBar(Axis.HORIZONTAL);
    protected WScrollBar verticalScrollBar = new WScrollBar(Axis.VERTICAL);
    private int lastHorizontalScroll = -1;
    private int lastVerticalScroll = -1;
    private Insets insets = Insets.NONE;

    public WScrollPanel(WWidget widget) {
        this.widget = widget;
        widget.setParent(this);
        this.horizontalScrollBar.setParent(this);
        this.verticalScrollBar.setParent(this);
        this.children.add(widget);
        this.children.add(this.verticalScrollBar);
    }

    public WScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public WScrollPanel setHorizontalScrollBar(WScrollBar horizontalScrollBar) {
        this.horizontalScrollBar = Objects.requireNonNull(horizontalScrollBar, "horizontalScrollBar");
        return this;
    }

    public TriState isScrollingHorizontally() {
        return this.scrollingHorizontally;
    }

    public WScrollPanel setScrollingHorizontally(TriState scrollingHorizontally) {
        if (scrollingHorizontally != this.scrollingHorizontally) {
            this.scrollingHorizontally = scrollingHorizontally;
            this.layout();
        }
        return this;
    }

    public WScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public WScrollPanel setVerticalScrollBar(WScrollBar verticalScrollBar) {
        this.verticalScrollBar = Objects.requireNonNull(verticalScrollBar, "verticalScrollBar");
        return this;
    }

    public TriState isScrollingVertically() {
        return this.scrollingVertically;
    }

    public WScrollPanel setScrollingVertically(TriState scrollingVertically) {
        if (scrollingVertically != this.scrollingVertically) {
            this.scrollingVertically = scrollingVertically;
            this.layout();
        }
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        BackgroundPainter backgroundPainter;
        if (this.verticalScrollBar.getValue() != this.lastVerticalScroll || this.horizontalScrollBar.getValue() != this.lastHorizontalScroll) {
            this.layout();
            this.lastHorizontalScroll = this.horizontalScrollBar.getValue();
            this.lastVerticalScroll = this.verticalScrollBar.getValue();
        }
        if ((backgroundPainter = this.getBackgroundPainter()) != null) {
            backgroundPainter.paintBackground(context, x, y, this);
        }
        Insets insets = this.getInsets();
        for (WWidget child : this.children) {
            if (child == this.widget) {
                Scissors.push(context, x + insets.left(), y + insets.top(), this.width - insets.width(), this.height - insets.height());
            }
            child.paint(context, x + child.getX(), y + child.getY(), mouseX - child.getX(), mouseY - child.getY());
            if (child != this.widget) continue;
            Scissors.pop();
        }
    }

    @Override
    public void layout() {
        this.children.clear();
        boolean horizontal = this.hasHorizontalScrollbar();
        boolean vertical = this.hasVerticalScrollbar();
        int offset = horizontal && vertical ? 8 : 0;
        this.verticalScrollBar.setSize(8, this.height - offset);
        this.verticalScrollBar.setLocation(this.width - this.verticalScrollBar.getWidth(), 0);
        this.horizontalScrollBar.setSize(this.width - offset, 8);
        this.horizontalScrollBar.setLocation(0, this.height - this.horizontalScrollBar.getHeight());
        WWidget wWidget = this.widget;
        if (wWidget instanceof WPanel) {
            WPanel panel = (WPanel)wWidget;
            panel.layout();
        }
        this.children.add(this.widget);
        Insets insets = this.getInsets();
        int x = insets.left() + (horizontal ? -this.horizontalScrollBar.getValue() : 0);
        int y = insets.top() + (vertical ? -this.verticalScrollBar.getValue() : 0);
        this.widget.setLocation(x, y);
        this.verticalScrollBar.setWindow(this.height - insets.height() - (horizontal ? 8 : 0));
        this.verticalScrollBar.setMaxValue(this.widget.getHeight());
        this.horizontalScrollBar.setWindow(this.width - insets.width() - (vertical ? 8 : 0));
        this.horizontalScrollBar.setMaxValue(this.widget.getWidth());
        if (vertical) {
            this.children.add(this.verticalScrollBar);
        }
        if (horizontal) {
            this.children.add(this.horizontalScrollBar);
        }
    }

    private boolean hasHorizontalScrollbar() {
        return this.scrollingHorizontally == TriState.DEFAULT ? this.widget.width > this.width - 8 : this.scrollingHorizontally.get();
    }

    private boolean hasVerticalScrollbar() {
        return this.scrollingVertically == TriState.DEFAULT ? this.widget.height > this.height - 8 : this.scrollingVertically.get();
    }

    @Override
    public InputResult onMouseScroll(int x, int y, double horizontalAmount, double verticalAmount) {
        InputResult horizontalResult = InputResult.IGNORED;
        InputResult verticalResult = InputResult.IGNORED;
        if (this.hasHorizontalScrollbar()) {
            horizontalResult = this.horizontalScrollBar.onMouseScroll(x, y, horizontalAmount, 0.0);
        }
        if (this.hasVerticalScrollbar()) {
            verticalResult = this.verticalScrollBar.onMouseScroll(0, 0, 0.0, verticalAmount);
        }
        return horizontalResult.or(verticalResult);
    }

    @Override
    public void validate(GuiDescription c) {
        this.horizontalScrollBar.validate(c);
        this.verticalScrollBar.validate(c);
        super.validate(c);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public WScrollPanel setInsets(Insets insets) {
        this.insets = Objects.requireNonNull(insets, "Insets cannot be null");
        return this;
    }
}

