/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl;

import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.networking.NetworkSide;
import io.github.cottonmc.cotton.gui.networking.ScreenMessageKey;
import io.github.cottonmc.cotton.gui.networking.ScreenNetworking;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2505;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenNetworkingImpl
implements ScreenNetworking {
    private static final long MAX_NBT_SIZE = 0x200000L;
    public static final ScreenMessageKey<Unit> CLIENT_READY_MESSAGE_KEY = new ScreenMessageKey(LibGuiCommon.id("client_ready"), Codec.unit((Object)Unit.INSTANCE));
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenNetworkingImpl.class);
    private final Map<class_2960, ReceiverData<?>> receivers = new HashMap();
    private final SyncedGuiDescription description;
    private final NetworkSide side;
    private final Event<ScreenNetworking.ReadyListener> readyEvent;
    private boolean ready = false;

    public ScreenNetworkingImpl(SyncedGuiDescription description, NetworkSide side) {
        this.description = description;
        this.side = side;
        this.readyEvent = EventFactory.createArrayBacked(ScreenNetworking.ReadyListener.class, listeners -> screenNetworking -> {
            for (ScreenNetworking.ReadyListener listener : listeners) {
                listener.onConnected(screenNetworking);
            }
        });
        if (side == NetworkSide.SERVER) {
            this.receive(CLIENT_READY_MESSAGE_KEY, data -> this.markReady());
        }
    }

    private static class_6903<class_2520> getRegistryOps(class_5455 registryManager) {
        return registryManager.method_57093((DynamicOps)class_2509.field_11560);
    }

    @Override
    public <D> void receive(class_2960 message, Decoder<D> decoder, ScreenNetworking.MessageReceiver<D> receiver) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(decoder, "decoder");
        Objects.requireNonNull(receiver, "receiver");
        if (this.receivers.containsKey(message)) {
            throw new IllegalStateException("Message " + String.valueOf(message) + " on side " + String.valueOf((Object)this.side) + " already registered");
        }
        this.receivers.put(message, new ReceiverData<D>(decoder, receiver));
    }

    @Override
    public <D> void send(class_2960 message, Encoder<D> encoder, D data) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(encoder, "encoder");
        class_6903<class_2520> ops = ScreenNetworkingImpl.getRegistryOps(this.description.getWorld().method_30349());
        class_2520 encoded = (class_2520)encoder.encodeStart(ops, data).getOrThrow();
        ScreenMessage packet = new ScreenMessage(this.description.field_7763, message, encoded);
        this.description.getPacketSender().sendPacket((class_8710)packet);
    }

    @Override
    public Event<ScreenNetworking.ReadyListener> getReadyEvent() {
        return this.readyEvent;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void markReady() {
        this.ready = true;
        ((ScreenNetworking.ReadyListener)this.getReadyEvent().invoker()).onConnected(this);
    }

    public static void init() {
        PayloadTypeRegistry.playS2C().register(ScreenMessage.ID, ScreenMessage.CODEC);
        PayloadTypeRegistry.playC2S().register(ScreenMessage.ID, ScreenMessage.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ScreenMessage.ID, (payload, context) -> ScreenNetworkingImpl.handle((Executor)context.player().method_5682(), (class_1657)context.player(), payload));
    }

    public static void handle(Executor executor, class_1657 player, ScreenMessage packet) {
        class_1703 screenHandler = player.field_7512;
        if (!(screenHandler instanceof SyncedGuiDescription)) {
            LOGGER.error("Received message packet for screen handler {} which is not a SyncedGuiDescription", (Object)screenHandler);
            return;
        }
        SyncedGuiDescription guiDescription = (SyncedGuiDescription)screenHandler;
        if (packet.syncId() != screenHandler.field_7763) {
            LOGGER.error("Received message for sync ID {}, current sync ID: {}", (Object)packet.syncId(), (Object)screenHandler.field_7763);
            return;
        }
        ScreenNetworkingImpl networking = (ScreenNetworkingImpl)guiDescription.getNetworking(guiDescription.getNetworkSide());
        ReceiverData<?> receiverData = networking.receivers.get(packet.message());
        if (receiverData != null) {
            ScreenNetworkingImpl.processMessage(executor, player, packet, screenHandler, receiverData);
        } else {
            LOGGER.error("Message {} not registered for {} on side {}", new Object[]{packet.message(), screenHandler, networking.side});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <D> void processMessage(Executor executor, class_1657 player, ScreenMessage packet, class_1703 description, ReceiverData<D> receiverData) {
        DataResult result;
        class_6903<class_2520> ops = ScreenNetworkingImpl.getRegistryOps(player.method_56673());
        DataResult dataResult = result = receiverData.decoder().parse(ops, (Object)packet.nbt());
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success success = (DataResult.Success)dataResult2;
                try {
                    Object object;
                    Object data = object = success.value();
                    Object lifecycle = object = success.lifecycle();
                    executor.execute(() -> {
                        try {
                            receiverData.receiver().onMessage(data);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error handling screen message {} for {}", new Object[]{packet.message(), description, e});
                        }
                    });
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        DataResult.Error error = (DataResult.Error)dataResult2;
        LOGGER.error("Could not parse screen message {}: {}", (Object)packet.message(), (Object)error.message());
    }

    private record ReceiverData<D>(Decoder<D> decoder, ScreenNetworking.MessageReceiver<D> receiver) {
    }

    public record ScreenMessage(int syncId, class_2960 message, class_2520 nbt) implements class_8710
    {
        public static final class_8710.class_9154<ScreenMessage> ID = new class_8710.class_9154(LibGuiCommon.id("screen_message"));
        public static final class_9139<class_9129, ScreenMessage> CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, ScreenMessage::syncId, (class_9139)class_2960.field_48267, ScreenMessage::message, (class_9139)class_9135.method_56378(() -> class_2505.method_53899((long)0x200000L)), ScreenMessage::nbt, ScreenMessage::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public static final class DummyNetworking
    extends ScreenNetworkingImpl {
        public DummyNetworking() {
            super(null, null);
        }

        @Override
        public <D> void receive(class_2960 message, Decoder<D> decoder, ScreenNetworking.MessageReceiver<D> receiver) {
        }

        @Override
        public <D> void send(class_2960 message, Encoder<D> encoder, D data) {
        }
    }
}

